
package jp.riken.brain.ni.samuraigraph.figure;

import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIProgressControl;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeMultipleData;


/**
 * Figure for the two-dimensional scalar-type data.
 * 
 */
public class SGSXYFigure extends SGXYFigure implements SGIFigureTypeConstants
{

	public static final float DEFAULT_WIDTH = 15.0f;
	public static final float DEFAULT_HEIGHT = 9.0f;


//	/**
//	 *
//	 */
//	public SGSXYFigure()
//	{
//		super();
//	}



	/**
	 *
	 */
	public SGSXYFigure( final SGDrawingWindow wnd )
	{
		super( wnd );
	}


	/**
	 * 
	 */
	public String getClassType()
	{
		return FIGURE_TYPE_SXY;
	}


	/**
	 * 
	 */
	protected boolean createDialog()
	{
		final SGXYFigureDialog dg = new SGXYFigureDialog( this.mWnd, true );
		this.mDialog = dg;
		return true;

	}

	/**
	 * validate data type
	 * @param data - target data for validaty
	 * @return result
	 */
	protected boolean validateDataType( final SGData data )
	{
		if ( ( ( data instanceof SGISXYTypeData ) || ( data instanceof SGISXYTypeMultipleData ) )  == false )
			return false;
		return true;
	}
	
	/**
	 * 
	 */
	public boolean addData(
		final SGData data, final String name, final SGIFigureElement[] array,
		final SGIProgressControl progress, final float min, final float max )
	{
		if( validateDataType(data) == false )
		{
			return false;
		}
		if( super._addData(data,name,array, progress, min, max) == false )
		{
			return false;
		}
		
		return true;
	}

}

