
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import jp.riken.brain.ni.samuraigraph.base.SGITwoAxesHolder;


/**
 * An observer of the property dialog for two-dimensional scalar type data.
 */
public interface SGISXYDataDialogObserver
	extends SGIDataPropertyDialogObserver, SGITwoAxesHolder
{

	/**
	 * Returns the index of clicked objects.
	 * @return
	 */
	public int getSelectedTabIndex();


	// Line
	/**
	 * @return
	 * @uml.property  name="lineVisible"
	 */
	public boolean isLineVisible();
	public float getLineWidth( final String unit );
	/**
	 * @return
	 * @uml.property  name="lineType"
	 */
	public int getLineType();
	/**
	 * @return
	 * @uml.property  name="lineColor"
	 */
	public Color getLineColor();
	/**
	 * @param b
	 * @return
	 * @uml.property  name="lineVisible"
	 */
	public boolean setLineVisible( final boolean b );
	public boolean setLineWidth( final float width, final String unit );
	/**
	 * @param type
	 * @return
	 * @uml.property  name="lineType"
	 */
	public boolean setLineType( final int type );
	/**
	 * @param cl
	 * @return
	 * @uml.property  name="lineColor"
	 */
	public boolean setLineColor( final Color cl );


	// Symbol
	/**
	 * @return
	 * @uml.property  name="symbolVisible"
	 */
	public boolean isSymbolVisible();
	/**
	 * @return
	 * @uml.property  name="symbolType"
	 */
	public int getSymbolType();
	public float getSymbolSize( final String unit );
	public float getSymbolLineWidth( final String unit );
	/**
	 * @return
	 * @uml.property  name="symbolInnerColor"
	 */
	public Color getSymbolInnerColor();
	/**
	 * @return
	 * @uml.property  name="symbolLineColor"
	 */
	public Color getSymbolLineColor();
	/**
	 * @param b
	 * @return
	 * @uml.property  name="symbolVisible"
	 */
	public boolean setSymbolVisible( final boolean b );
	/**
	 * @param type
	 * @return
	 * @uml.property  name="symbolType"
	 */
	public boolean setSymbolType( final int type );
	public boolean setSymbolSize( final float size, final String unit );
	public boolean setSymbolLineWidth( final float width, final String unit );
	/**
	 * @param cl
	 * @return
	 * @uml.property  name="symbolInnerColor"
	 */
	public boolean setSymbolInnerColor( final Color cl );
	/**
	 * @param cl
	 * @return
	 * @uml.property  name="symbolLineColor"
	 */
	public boolean setSymbolLineColor( final Color cl );


	// Bar
	/**
	 * @return
	 * @uml.property  name="barVisible"
	 */
	public boolean isBarVisible();
	/**
	 * @return
	 * @uml.property  name="barBaselineValue"
	 */
	public double getBarBaselineValue();
	/**
	 * @return
	 * @uml.property  name="barWidthValue"
	 */
	public double getBarWidthValue();
	public float getBarEdgeLineWidth( final String unit );
	/**
	 * @return
	 * @uml.property  name="barInnerColor"
	 */
	public Color getBarInnerColor();
	/**
	 * @return
	 * @uml.property  name="barEdgeLineColor"
	 */
	public Color getBarEdgeLineColor();
	/**
	 * @param b
	 * @return
	 * @uml.property  name="barVisible"
	 */
	public boolean setBarVisible( final boolean b );
	/**
	 * @param value
	 * @return
	 * @uml.property  name="barBaselineValue"
	 */
	public boolean setBarBaselineValue( final double value );
	/**
	 * @param width
	 * @return
	 * @uml.property  name="barWidthValue"
	 */
	public boolean setBarWidthValue( final double width );
	public boolean setBarEdgeLineWidth( final float width, final String unit );
	/**
	 * @param cl
	 * @return
	 * @uml.property  name="barInnerColor"
	 */
	public boolean setBarInnerColor( final Color cl );
	/**
	 * @param cl
	 * @return
	 * @uml.property  name="barEdgeLineColor"
	 */
	public boolean setBarEdgeLineColor( final Color cl );
	public boolean hasValidBaselineValue( final int config, final Number value );


	// Error Bar
	public boolean isErrorBarHolding();
	/**
	 * @return
	 * @uml.property  name="errorBarVisible"
	 */
	public boolean isErrorBarVisible();
	/**
	 * @return
	 * @uml.property  name="errorBarHeadType"
	 */
	public int getErrorBarHeadType();
	public float getErrorBarHeadSize( final String unit );
	/**
	 * @return
	 * @uml.property  name="errorBarColor"
	 */
	public Color getErrorBarColor();
	public float getErrorBarLineWidth( final String unit );
	/**
	 * @return
	 * @uml.property  name="errorBarStyle"
	 */
	public int getErrorBarStyle();
	/**
	 * @param b
	 * @return
	 * @uml.property  name="errorBarVisible"
	 */
	public boolean setErrorBarVisible( final boolean b );
	/**
	 * @param type
	 * @return
	 * @uml.property  name="errorBarHeadType"
	 */
	public boolean setErrorBarHeadType( final int type );
	public boolean setErrorBarHeadSize( final float size, final String unit );
	/**
	 * @param cl
	 * @return
	 * @uml.property  name="errorBarColor"
	 */
	public boolean setErrorBarColor( final Color cl );
	public boolean setErrorBarLineWidth( final float width, final String unit  );
	/**
	 * @param style
	 * @return
	 * @uml.property  name="errorBarStyle"
	 */
	public boolean setErrorBarStyle( final int style );


	// Tick Label
	public boolean isTickLabelHolding();
	/**
	 * @return
	 * @uml.property  name="tickLabelVisible"
	 */
	public boolean isTickLabelVisible();
	/**
	 * @return
	 * @uml.property  name="tickLabelFontName"
	 */
	public String getTickLabelFontName();
	/**
	 * @return
	 * @uml.property  name="tickLabelFontStyle"
	 */
	public int getTickLabelFontStyle();
	public float getTickLabelFontSize( final String unit );
	/**
	 * @return
	 * @uml.property  name="tickLabelColor"
	 */
	public Color getTickLabelColor();
	/**
	 * @return
	 * @uml.property  name="tickLabelHorizontal"
	 */
	public boolean isTickLabelHorizontal();
	/**
	 * @param b
	 * @return
	 * @uml.property  name="tickLabelVisible"
	 */
	public boolean setTickLabelVisible( final boolean b );
	/**
	 * @param name
	 * @return
	 * @uml.property  name="tickLabelFontName"
	 */
	public boolean setTickLabelFontName( final String name );
	/**
	 * @param style
	 * @return
	 * @uml.property  name="tickLabelFontStyle"
	 */
	public boolean setTickLabelFontStyle( final int style );
	public boolean setTickLabelFontSize( final float size, final String unit  );
	/**
	 * @param cl
	 * @return
	 * @uml.property  name="tickLabelColor"
	 */
	public boolean setTickLabelColor( final Color cl );
	/**
	 * @param b
	 * @return
	 * @uml.property  name="tickLabelHorizontal"
	 */
	public boolean setTickLabelHorizontal( final boolean b );


}

