
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;

/**
 * Constants for the figures.
 * 
 */
public interface SGIFigureConstants extends SGIConstants
{

	// figure location
	public static final String FIGURE_LOCATION_UNIT = cm;
	public static final double FIGURE_X_MIN = -50.0;
	public static final double FIGURE_X_MAX = 150.0;
	public static final double FIGURE_Y_MIN = -50.0;
	public static final double FIGURE_Y_MAX = 150.0;

	// figure size
	public static final String FIGURE_SIZE_UNIT = cm;
	public static final double FIGURE_WIDTH_MIN = 1.0;
	public static final double FIGURE_WIDTH_MAX = 50.0;
	public static final double FIGURE_HEIGHT_MIN = 1.0;
	public static final double FIGURE_HEIGHT_MAX = 50.0;

	// space
	public static final String FIGURE_SPACE_UNIT = cm;
	public static final double FIGURE_SPACE_TO_SCALE_MIN = 0.0;
	public static final double FIGURE_SPACE_TO_SCALE_MAX = 5.0;
	public static final double FIGURE_SPACE_TO_TITLE_MIN = 0.0;
	public static final double FIGURE_SPACE_TO_TITLE_MAX = 5.0;



	//
	// Default values
	//

	// space to scale
	public static final float DEFAULT_SPACE_AXIS_LINE_AND_NUMBER = 0.20f;

	// space to title
	public static final float DEFAULT_SPACE_NUMBER_AND_TITLE = 0.20f;

	// background color to white
	public static final Color DEFAULT_FIGURE_BACKGROUND_COLOR = Color.WHITE;

	// bounding box visible
	public static final boolean DEFAULT_FIGURE_BOUNDING_BOX_VISIBLE = false;

	// rubber banding enabled
	public static final boolean DEFAULT_FIGURE_RUBBER_BANDING_ENABLED = true;

	// snap to grid
	public static final boolean DEFAULT_FIGURE_SNAP_TO_GRID = true;


}

