
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JComponent;

import org.w3c.dom.Document;
import org.w3c.dom.Element;


/**
 * An interface for objects on a figure.
 */
public interface SGIFigureElement
	extends SGIUndoable, SGIConstants, SGIPaintable, SGINode, SGIDisposable,
		SGIDrawingElementConstants
{

	/**
	 * @return
	 * @uml.property  name="component"
	 */
	public JComponent getComponent();


	/**
	 * @param com
	 * @uml.property  name="component"
	 */
	public void setComponent( JComponent com );


	/**
	 * Add a data object with given name.
	 * @param data - data to be added
	 * @param name - name of data
	 * @return
	 */
	public boolean addData( final SGData data, final String name );


	/**
	 * Add a data object with given name and properties.
	 * @param data - data to be added
	 * @param name - name of data
	 * @param p - properties to be set the data
	 * @return
	 */
	public boolean addData( final SGData data, final String name, final SGProperties p );


	/**
	 * Remove a data object
	 * @param data - data to be removed
	 * @return
	 */
	public boolean removeData( SGData data );


	/**
	 * Returns a list of data.
	 */
	public List getDataList();


	/**
	 * Returns properties of the given data.
	 */
	public SGProperties getDataProperties( SGData data );


	/**
	 * Zoom in/out this component.<BR>
	 */
	public boolean zoom( float mag );


	/**
	 * Synchronize this component to the other component. <BR>
	 * @param element - the SGFigureElement object whose property has chenged.
	 * @param msg - message
	 * @return true:succeeded, false:failed
	 */
	public boolean synchronize( SGIFigureElement element, String msg );


	/**
	 * 
	 */
	public boolean synchronizeArgument( SGIFigureElement element, String msg );



	/**
	 * 
	 */
	public boolean setViewBounds( Rectangle2D rect );



	/**
	 * 
	 * @param topAndBottom
	 * @param leftAndRight
	 * @return
	 */
	public boolean getMarginAroundGraphRect(
		final SGTuple2f topAndBottom,
		final SGTuple2f leftAndRight );


	/**
	 * 
	 * @return
	 */
	public float getGraphRectX();


	/**
	 * 
	 * @return
	 */
	public float getGraphRectY();


	/**
	 * 
	 * @return
	 */
	public float getGraphRectWidth();


	/**
	 * 
	 * @return
	 */
	public float getGraphRectHeight();


	/**
	 * ]
	 * @uml.property  name="graphRect"
	 */
	public Rectangle2D getGraphRect();



	/**
	 * 
	 * @return
	 */
	public boolean setGraphRect( float x, float y, float width, float height );

	
	
	/**
	 * @param rect
	 * @return
	 * @uml.property  name="graphRect"
	 */
	public boolean setGraphRect( Rectangle2D rect );

	

	/**
	 * 
	 */
	public boolean setGraphRectLocation( float x, float y );


	/**
	 * 
	 */
	public boolean setGraphRectSize( float width, float height );


	/**
	 * 
	 */
	public boolean setDialogOwner( Frame frame );



	/**
	 * 
	 */
	public Cursor getFigureElementCursor();

	
	/**
	 * key event
	 */
	public boolean onKeyPressed( KeyEvent e );


	/**
	 * 
	 * @param e
	 */
	public boolean onMouseClicked( MouseEvent e );


	/**
	 * 
	 * @param e
	 */
	public boolean onMousePressed( MouseEvent e );


	/**
	 * 
	 * @param e
	 */
	public boolean onMouseDragged( MouseEvent e );


	/**
	 * 
	 * @param e
	 */
	public boolean onMouseReleased( MouseEvent e );


	/**
	 * 
	 * @param e
	 */
	public boolean onDrawingElement( int x, int y );



	/**
	 * 
	 */
	public void addActionListener( ActionListener listener );


	/**
	 * 
	 */
	public void removeActionListener( ActionListener listener );


	/**
	 * 
	 * @param document
	 * @return
	 */
	public Element createElement( final Document document );
	
	
	
	/**
	 * 
	 * @param element
	 * @return
	 */
	public boolean readProperty( final Element element );

	
	/**
	 * initialize compatible properties for previous property file.
	 * @return
	 */
	public boolean initCompatibleProperty();
	
	
	/**
	 * Create objects related to the data with information given by an Element object.
	 * @param el an Element object
	 * @param data a data object
	 * @return true:succeeded, false:failed
	 */
	public boolean createDataObject( Element el, SGData data );
	


	/**
	 * Clear all focused objects.
	 * @return true:succeeded, false:failed
	 */
	public boolean clearFocusedObjects();

	

	/**
	 * 
	 *
	 */
	public boolean hideSelectedObjects();


	/**
	 * Set the visibility of symbols around the focused objects.
	 * This method just hide the symbol, and does not clear
	 * the list of the focused objects.
	 * @param b visibility
	 */
	public void setSymbolsVisibleAroundFocusedObjects( final boolean b );

	
	
	/**
	 * Set the visibility of symbols around all objects.
	 * @param b visibility
	 */
	public void setSymbolsVisibleAroundAllObjects( final boolean b );
	

	
	/**
	 * 
	 * @param dx
	 * @param dy
	 */
	public void translateFocusedObjects( final int dx, final int dy );


	/**
	 * 
	 * @return
	 */
	public boolean setTemporaryPropertiesOfFocusedObjects();


	/**
	 * 
	 * @return
	 */
	public boolean setChangedFocusedObjects();


	/**
	 * 
	 * @return
	 */
	public ArrayList getFocusedObjectsList();
	

	/**
	 * Duplicate the focused objects.
	 * @return true:succeeded, false:failed
	 */
	public boolean duplicateFocusedObjects();


	/**
	 * Returns the list of copied objects.
	 * @return list of copied objects
	 */
	public ArrayList getCopiedObjectsList();


	/**
	 * Cut focused copiable objects.
	 * @return a list of cut objects
	 */
	public ArrayList cutFocusedObjects();


	/**
	 * Paste the objects.
	 * @param list of the objects to be pasted
	 * @return true:succeeded, false:failed
	 */
	public boolean paste( ArrayList list );


	/**
	 * Move the focused objects to front or back.
	 * @param toFront - flag whether to front or back
	 * @return true:succeeded, false:failed
	 */
	public boolean moveFocusedObjects( boolean toFront );



	/**
	 * 
	 * @return
	 */
	public ArrayList getPropertyDialogObserverList();



	public static final String KEY_DATA_TYPE = "Type";

	public static final String KEY_DATA_NAME = "Name";
	public static final String KEY_VISIBLE_IN_LEGEND = "VisibleInLegend";


	public static final String KEY_AXIS_POSITION = "AxisPosition";
	public static final String KEY_X_AXIS_POSITION = "XAxisPosition";
	public static final String KEY_Y_AXIS_POSITION = "YAxisPosition";

	
	/**
	 * The effective digit for the axis range.
	 */
	public static final int AXIS_SCALE_EFFECTIVE_DIGIT = 4;



	public void setMode( final int mode );


	/**
	 * 
	 */
	public boolean hideChildObject( final int id );

	/**
	 * 
	 * @param id
	 * @param toFront
	 * @return
	 */
	public boolean moveChildObject( final int id, final boolean toFront );


	/**
	 * 
	 */
	public static final String NOTIFY_CHANGE = "Notify the change";
	public static final String NOTIFY_CHANGE_ON_UNDO = "Notify the change on undo";
	public static final String SET_PROPERTIES_OF_SELECTED_OBJECTS = "Set properties of selected objects";
	public static final String CLEAR_FOCUSED_OBJECTS = "Clear focused objects";
	public static final String NOTIFY_CHANGE_TO_ROOT = "Notify the change to root";
	public static final String NOTIFY_CHANGE_CURSOR = "Notify the change of cursor";
	public static final String MERGE_DATA = "Merge Data";

}


