
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;

/**
 * An object to manage axis break symbols.
 * 
 */
public interface SGIFigureElementAxisBreak extends SGIFigureElement
{

	public static final String TAG_NAME_AXIS_BREAK = "AxisBreakSymbols";

	
	/**
	 * 
	 * @param element
	 */
	public void setAxisElement( final SGIFigureElementAxis element );
	
	
	/**
	 * 
	 * @param x
	 * @param y
	 * @return
	 */
	public boolean addAxisBreakSymbol( final int x, final int y );

	
	/**
	 * 
	 * @param x
	 * @param y
	 * @return
	 */
	public boolean addAxisBreakSymbol(
		final SGAxis xAxis, final SGAxis yAxis, final int x, final int y );


	public boolean setAxisXDirectly( final int id, final int value );
	public boolean setAxisYDirectly( final int id, final int value );
	public boolean setLocationXDirectly( final int id, final double value );
	public boolean setLocationYDirectly( final int id, final double value );
	public boolean setLengthDirectly( final int id, final float value, final String unit );
	public boolean setIntervalDirectly( final int id, final float value, final String unit );
	public boolean setDistortionDirectly( final int id, final float value );
	public boolean setAngleDirectly( final int id, final float value );
	public boolean setLineWidthDirectly( final int id, final float value, final String unit );
	public boolean setAlignmentDirectly( final int id, final boolean value );
	public boolean setLineColorDirectly( final int id, final Color value );
	public boolean setInnerColorDirectly( final int id, final Color value );
	
}

