
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGITwoAxesHolder;

/**
 * An observer of the dialog for XY-type figures.
 */
public interface SGIXYFigureDialogObserver
	extends SGIFigureDialogObserver, SGITwoAxesHolder
{

	/**
	 * @param b
	 * @return
	 * @uml.property  name="gridVisible"
	 */
	public boolean setGridVisible( final boolean b );
	/**
	 * @param b
	 * @return
	 * @uml.property  name="autoCalculateRange"
	 */
	public boolean setAutoCalculateRange( final boolean b );
	/**
	 * @param value
	 * @return
	 * @uml.property  name="gridStepValueX"
	 */
	public boolean setGridStepValueX( final double value );
	/**
	 * @param value
	 * @return
	 * @uml.property  name="gridStepValueY"
	 */
	public boolean setGridStepValueY( final double value );
	/**
	 * @param value
	 * @return
	 * @uml.property  name="gridBaselineValueX"
	 */
	public boolean setGridBaselineValueX( final double value );
	/**
	 * @param value
	 * @return
	 * @uml.property  name="gridBaselineValueY"
	 */
	public boolean setGridBaselineValueY( final double value );
	public boolean setGridLineWidth( final float width, final String unit );
	/**
	 * @param type
	 * @return
	 * @uml.property  name="gridLineType"
	 */
	public boolean setGridLineType( final int type );
	/**
	 * @param cl
	 * @return
	 * @uml.property  name="gridLineColor"
	 */
	public boolean setGridLineColor( final Color cl );

	/**
	 * @return
	 * @uml.property  name="gridVisible"
	 */
	public boolean isGridVisible();
	/**
	 * @return
	 * @uml.property  name="autoCalculateRange"
	 */
	public boolean isAutoCalculateRange();
	/**
	 * @return
	 * @uml.property  name="gridStepValueX"
	 */
	public double getGridStepValueX();
	/**
	 * @return
	 * @uml.property  name="gridStepValueY"
	 */
	public double getGridStepValueY();
	/**
	 * @return
	 * @uml.property  name="gridBaselineValueX"
	 */
	public double getGridBaselineValueX();
	/**
	 * @return
	 * @uml.property  name="gridBaselineValueY"
	 */
	public double getGridBaselineValueY();
	public float getGridLineWidth( final String unit );
	/**
	 * @return
	 * @uml.property  name="gridLineType"
	 */
	public int getGridLineType();
	/**
	 * @return
	 * @uml.property  name="gridLineColor"
	 */
	public Color getGridLineColor();

	public boolean hasValidStepXValue( final Number step );
	public boolean hasValidStepYValue( final Number step );

}

