
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGComponentGroup;
import jp.riken.brain.ni.samuraigraph.base.SGComponentGroupElement;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGILineConstants;

/**
 * A dialog to set the properties of rectangular shapes.
 */
public class SGRectangularShapeDialog extends SGPropertyDialog
{
	/**
	 * 
	 */
	public static final String TITLE = "Rectangular Shape Properties";


    /** Creates new form SGRectangularShapeDialog */
    public SGRectangularShapeDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
		this.initProperty();
		this.initialize();
    }

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mAxisPanel = new jp.riken.brain.ni.samuraigraph.base.SGTwoAxesSelectionPanel();
        mPanel = new javax.swing.JPanel();
        mEdgeLineLabel = new javax.swing.JLabel();
        mEdgeLineSeparator = new javax.swing.JSeparator();
        mLeftSpaceLabel = new javax.swing.JLabel();
        mRightSpaceLabel = new javax.swing.JLabel();
        mBoundsLabel = new javax.swing.JLabel();
        mBoundsSeparator = new javax.swing.JSeparator();
        mLeftXValueLabel = new javax.swing.JLabel();
        mLeftXValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mTopYValueLabel = new javax.swing.JLabel();
        mTopYValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mRightXValueLabel = new javax.swing.JLabel();
        mRightXValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mBottomYValueLabel = new javax.swing.JLabel();
        mBottomYValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mBackgroundLabel = new javax.swing.JLabel();
        mBackgroundSeparator = new javax.swing.JSeparator();
        mLineColorLabel = new javax.swing.JLabel();
        mLineColorButton = new jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton();
        mInnerColorLabel = new javax.swing.JLabel();
        mInnerColorButton = new jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton();
        mEdgeLineWidthLabel = new javax.swing.JLabel();
        mEdgeLineWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mBackgroundTransparentCheckBox = new jp.riken.brain.ni.samuraigraph.base.SGCheckBox();
        mEdgeLineTypeLabel = new javax.swing.JLabel();
        mEdgeLineTypeComboBox = new javax.swing.JComboBox();
        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPreviewButton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(mAxisPanel, gridBagConstraints);

        mPanel.setLayout(new java.awt.GridBagLayout());

        mPanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        mEdgeLineLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mEdgeLineLabel.setText("Edge Line ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mEdgeLineLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 4, 5, 5);
        mPanel.add(mEdgeLineSeparator, gridBagConstraints);

        mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        mPanel.add(mLeftSpaceLabel, gridBagConstraints);

        mRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        mPanel.add(mRightSpaceLabel, gridBagConstraints);

        mBoundsLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mBoundsLabel.setText("Bounds ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        mPanel.add(mBoundsLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(10, 4, 5, 5);
        mPanel.add(mBoundsSeparator, gridBagConstraints);

        mLeftXValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLeftXValueLabel.setText("Left X");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mLeftXValueLabel, gridBagConstraints);

        mLeftXValueTextField.setColumns(6);
        mLeftXValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mLeftXValueTextField, gridBagConstraints);

        mTopYValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mTopYValueLabel.setText("Top Y");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mPanel.add(mTopYValueLabel, gridBagConstraints);

        mTopYValueTextField.setColumns(6);
        mTopYValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mTopYValueTextField, gridBagConstraints);

        mRightXValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mRightXValueLabel.setText("Right X");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        mPanel.add(mRightXValueLabel, gridBagConstraints);

        mRightXValueTextField.setColumns(6);
        mRightXValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mRightXValueTextField, gridBagConstraints);

        mBottomYValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mBottomYValueLabel.setText("Bottom Y");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mBottomYValueLabel, gridBagConstraints);

        mBottomYValueTextField.setColumns(6);
        mBottomYValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mBottomYValueTextField, gridBagConstraints);

        mBackgroundLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mBackgroundLabel.setText("Background");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mBackgroundLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        mPanel.add(mBackgroundSeparator, gridBagConstraints);

        mLineColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 10);
        mPanel.add(mLineColorLabel, gridBagConstraints);

        mLineColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 7, 5);
        mPanel.add(mLineColorButton, gridBagConstraints);

        mInnerColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mInnerColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mPanel.add(mInnerColorLabel, gridBagConstraints);

        mInnerColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        mPanel.add(mInnerColorButton, gridBagConstraints);

        mEdgeLineWidthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mEdgeLineWidthLabel.setText("Line Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mEdgeLineWidthLabel, gridBagConstraints);

        mEdgeLineWidthSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mEdgeLineWidthSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mEdgeLineWidthSpinner, gridBagConstraints);

        mBackgroundTransparentCheckBox.setText("Transparency");
        mBackgroundTransparentCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 10, 5);
        mPanel.add(mBackgroundTransparentCheckBox, gridBagConstraints);

        mEdgeLineTypeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mEdgeLineTypeLabel.setText("Type");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mEdgeLineTypeLabel, gridBagConstraints);

        mEdgeLineTypeComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mEdgeLineTypeComboBox.setPreferredSize(new java.awt.Dimension(140, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mEdgeLineTypeComboBox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(mPanel, gridBagConstraints);

        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        mPreviewButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mPreviewButton.setText("Preview");
        mButtonPanel.add(mPreviewButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(mButtonPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private jp.riken.brain.ni.samuraigraph.base.SGTwoAxesSelectionPanel mAxisPanel;
    private javax.swing.JLabel mBackgroundLabel;
    private javax.swing.JSeparator mBackgroundSeparator;
    private jp.riken.brain.ni.samuraigraph.base.SGCheckBox mBackgroundTransparentCheckBox;
    private javax.swing.JLabel mBottomYValueLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mBottomYValueTextField;
    private javax.swing.JLabel mBoundsLabel;
    private javax.swing.JSeparator mBoundsSeparator;
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JLabel mEdgeLineLabel;
    private javax.swing.JSeparator mEdgeLineSeparator;
    private javax.swing.JComboBox mEdgeLineTypeComboBox;
    private javax.swing.JLabel mEdgeLineTypeLabel;
    private javax.swing.JLabel mEdgeLineWidthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mEdgeLineWidthSpinner;
    private jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton mInnerColorButton;
    private javax.swing.JLabel mInnerColorLabel;
    private javax.swing.JLabel mLeftSpaceLabel;
    private javax.swing.JLabel mLeftXValueLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mLeftXValueTextField;
    private jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton mLineColorButton;
    private javax.swing.JLabel mLineColorLabel;
    private javax.swing.JButton mOKButton;
    private javax.swing.JPanel mPanel;
    private javax.swing.JButton mPreviewButton;
    private javax.swing.JLabel mRightSpaceLabel;
    private javax.swing.JLabel mRightXValueLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mRightXValueTextField;
    private javax.swing.JLabel mTopYValueLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mTopYValueTextField;
    // ϐ錾̏I//GEN-END:variables



	private void initProperty()
	{

		// set the title
		this.setTitle( TITLE );

		//
		{
			final String typeArray[] = {
				SGILineConstants.LINE_NAME_SOLID,
				SGILineConstants.LINE_NAME_BROKEN,
				SGILineConstants.LINE_NAME_DOT,
				SGILineConstants.LINE_NAME_DASHED,
				SGILineConstants.LINE_NAME_DOUBLE_DASHED
			};
			for(int ii=0 ; ii<typeArray.length ; ii++)
			{
				this.mEdgeLineTypeComboBox.addItem( typeArray[ii] );
			}
		}

		this.pack();

		
		//
		// spinner model
		//

		// edge line width
		this.mEdgeLineWidthSpinner.initProperties(
			getLineWidthSpinnerNumberModel(),
			LINE_WIDTH_UNIT, 1, 2 );

		
		// tH[JXꂽF{^̏
		this.mFocusedColorSetButton = this.mInnerColorButton;


		SGComponentGroupElement[] array = {
			new SGComponentGroupElement( this.mInnerColorLabel ),
			new SGComponentGroupElement( this.mInnerColorButton )
		};
		
		this.mTransparentComponentGroup.addElement( array );


		// set the name
		this.mLeftXValueTextField.setDescription("Bounds-> LeftX");
		this.mRightXValueTextField.setDescription("Bounds-> RightX");
		this.mBottomYValueTextField.setDescription("Bounds-> BottomY");
		this.mTopYValueTextField.setDescription("Bounds-> TopY");
		this.mEdgeLineWidthSpinner.setDescription("Edge Line-> Line Width");


		this.mBackgroundTransparentCheckBox.addActionListener(this);

		this.mOKButton.addActionListener(this);
		this.mCancelButton.addActionListener(this);
		this.mPreviewButton.addActionListener(this);
	
	}


	/**
	 * 
	 */
	private SGComponentGroup mTransparentComponentGroup = new SGComponentGroup();



//	/**
//	 * 
//	 *
//	 */
//	public void dispose()
//	{
//		if( this.mAxisPanel!=null )
//		{
//			this.mAxisPanel.dispose();
//			this.mAxisPanel = null;
//		}
//		
//		this.mTransparentComponentGroup.dispose();
//		this.mTransparentComponentGroup = null;
//
//		super.dispose();
//	}


	/**
	 * 
	 */
	public void actionPerformed( ActionEvent e )
	{
		super.actionPerformed(e);

		Object source = e.getSource();
		String command = e.getActionCommand();
		if( source.equals( this.mBackgroundTransparentCheckBox ) )
		{
			this.setTransparent( this.isTransparent() );
		}
	}


	/**
	 * 
	 */
	public List getColorSelectionButtonsList()
	{
		final List list = new ArrayList();
		list.add( this.mLineColorButton );
		list.add( this.mInnerColorButton );
		return list;
	}


	/**
	 * 
	 */
	public List getTextFieldComponentsList()
	{
		final List list = this.getFormattedTextFieldsListFromSpinners();
		list.addAll( this.getNumberTextFieldList() );
		return list;
	}


	/**
	 * Returns a list of text fields to set number.
	 * @return
	 */
	public List getNumberTextFieldList()
	{
		final List list = new ArrayList();
		list.add( this.mLeftXValueTextField );
		list.add( this.mRightXValueTextField );
		list.add( this.mTopYValueTextField );
		list.add( this.mBottomYValueTextField );
		return list;
	}


	/**
	 * 
	 */
	public List getSpinnerList()
	{
		List list = new ArrayList();
		list.add( this.mEdgeLineWidthSpinner );
		return list;
	}



	/**
	 * 
	 * @return
	 */
	public boolean setDialogProperty()
	{

		List list = this.mPropertyDialogObserverList;

		if( this.mAxisPanel.setSelected( list ) == false )
		{
			return false;
		}

		SGIRectangularShapeDialogObserver rect0
			= (SGIRectangularShapeDialogObserver)list.get(0);

		final double leftXValue0 = rect0.getLeftXValue();
		final double leftYValue0 = rect0.getTopYValue();
		final double rightXValue0 = rect0.getRightXValue();
		final double rightYValue0 = rect0.getBottomYValue();
		final float lineWidth0 = rect0.getLineWidth( pt );
		final int lineType0 = rect0.getLineType();
		final Color innerColor0 = rect0.getInnerColor();
		final Color lineColor0 = rect0.getLineColor();
		final boolean transparent0 = rect0.isTransparent();

		Double leftXValue = new Double( leftXValue0 );
		Double leftYValue = new Double( leftYValue0 );
		Double rightXValue = new Double( rightXValue0 );
		Double rightYValue = new Double( rightYValue0 );
		Float lineWidth = new Float( lineWidth0 );
		Integer lineType = new Integer( lineType0 );
		Color innerColor = innerColor0;
		Color lineColor = lineColor0;
		Boolean transparent = Boolean.valueOf( transparent0 );

		if( list.size() > 1 )
		{
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIRectangularShapeDialogObserver rect1
					= (SGIRectangularShapeDialogObserver)list.get(ii);
				final double xValue1 = rect1.getLeftXValue();
				if( leftXValue0!=xValue1 )
				{
					leftXValue = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIRectangularShapeDialogObserver rect1
					= (SGIRectangularShapeDialogObserver)list.get(ii);
				final double yValue1 = rect1.getTopYValue();
				if( leftYValue0!=yValue1 )
				{
					leftYValue = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIRectangularShapeDialogObserver rect1
					= (SGIRectangularShapeDialogObserver)list.get(ii);
				final double xValue1 = rect1.getRightXValue();
				if( rightXValue0!=xValue1 )
				{
					rightXValue = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIRectangularShapeDialogObserver rect1
					= (SGIRectangularShapeDialogObserver)list.get(ii);
				final double yValue1 = rect1.getBottomYValue();
				if( rightYValue0!=yValue1 )
				{
					rightYValue = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIRectangularShapeDialogObserver rect1
					= (SGIRectangularShapeDialogObserver)list.get(ii);
				final float lineWidth1 = rect1.getLineWidth( pt );
				if( lineWidth0!=lineWidth1 )
				{
					lineWidth = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIRectangularShapeDialogObserver rect1
					= (SGIRectangularShapeDialogObserver)list.get(ii);
				final int lineType1 = rect1.getLineType();
				if( lineType0!=lineType1 )
				{
					lineType = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIRectangularShapeDialogObserver rect1
					= (SGIRectangularShapeDialogObserver)list.get(ii);
				final Color color1 = rect1.getInnerColor();
				if( innerColor0.equals(color1) == false )
				{
					innerColor = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIRectangularShapeDialogObserver rect1
					= (SGIRectangularShapeDialogObserver)list.get(ii);
				final Color color1 = rect1.getLineColor();
				if( lineColor0.equals(color1) == false )
				{
					lineColor = null;
					break;
				}
			}
			
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIRectangularShapeDialogObserver rect1
					= (SGIRectangularShapeDialogObserver)list.get(ii);
				final boolean  transparent1 = rect1.isTransparent();
				if( transparent0!=transparent1 )
				{
					transparent = null;
					break;
				}
			}
		}


		//
		this.setLeftXValue( leftXValue );
		this.setTopYValue( leftYValue );
		this.setRightXValue( rightXValue );
		this.setBottomYValue( rightYValue );

		this.setLineWidth( lineWidth );
		this.setLineType( lineType );
		this.setInnerColor( innerColor );
		this.setLineColor( lineColor );
		this.setTransparent( transparent );


		this.setColorButtonBorder(true);

		return true;
	}



	/**
	 * 
	 */
	public boolean setPropertiesToListeners( SGIPropertyDialogObserver l )
	{
		SGIRectangularShapeDialogObserver rect
			= (SGIRectangularShapeDialogObserver)l;


		// get values
		final int xConfig = this.mAxisPanel.getXAxisConfiguration();
		final int yConfig = this.mAxisPanel.getYAxisConfiguration();
		final Number leftX = this.getLeftXValue();
		final Number topY = this.getTopYValue();
		final Number rightX = this.getRightXValue();
		final Number bottomY = this.getBottomYValue();
		final Number lineWidth = this.getLineWidth();
		final int lineType = this.getLineType();
		final Color innerColor = this.getInnerColor();
		final Color lineColor = this.getLineColor();
		final Boolean transparent = this.isTransparent();


		// check values
		ArrayList list = new ArrayList();
		if( rect.hasValidLeftXValue( xConfig, leftX ) == false )
		{
			list.add("LeftX");
		}
		if( rect.hasValidTopYValue( yConfig, topY ) == false )
		{
			list.add("TopY");
		}
		if( rect.hasValidRightXValue( xConfig, rightX ) == false )
		{
			list.add("RightX");
		}
		if( rect.hasValidBottomYValue( yConfig, bottomY ) == false )
		{
			list.add("BottomY");
		}
		if( list.size()!=0 )
		{
			String msg = ERRMSG_AXIS_VALUE_INVALID + ":\n";
			for( int ii=0; ii<list.size(); ii++ )
			{
				String str = (String)list.get(ii);
				msg += " - " + str + "\n";
			}
			this.setInputErrorMessage(msg);
			return false;
		}


		// set the related axes
		if( xConfig!=-1 )
		{
			rect.setXAxisLocation( xConfig );
		}

		if( yConfig!=-1 )
		{
			rect.setYAxisLocation( yConfig );
		}
		
		if( leftX!=null )
		{
			rect.setLeftXValue( leftX.doubleValue() );
		}

		if( topY!=null )
		{
			rect.setTopYValue( topY.doubleValue() );
		}

		if( rightX!=null )
		{
			rect.setRightXValue( rightX.doubleValue() );
		}

		if( bottomY!=null )
		{
			rect.setBottomYValue( bottomY.doubleValue() );
		}

		if( lineWidth!=null )
		{
			rect.setLineWidth( lineWidth.floatValue(), pt );
		}

		// line type
		if( lineType!=-1 )
		{
			rect.setLineType( lineType );
		}

		if( innerColor!=null )
		{
			rect.setInnerColor( innerColor );
		}

		if( lineColor!=null )
		{
			rect.setLineColor( lineColor );
		}
		
		if( transparent!=null )
		{
			rect.setTransparent( transparent.booleanValue() );
		}

		return true;
	}



	/**
	 * 
	 * @return
	 */
	public Number getLeftXValue()
	{
		return this.getNumber( this.mLeftXValueTextField );
	}

	
	/**
	 * 
	 * @return
	 */
	public Number getRightXValue()
	{
		return this.getNumber( this.mRightXValueTextField );
	}


	/**
	 * 
	 * @return
	 */
	public Number getTopYValue()
	{
		return this.getNumber( this.mTopYValueTextField );
	}

	
	/**
	 * 
	 * @return
	 */
	public Number getBottomYValue()
	{
		return this.getNumber( this.mBottomYValueTextField );
	}


	/**
	 * 
	 * @return
	 */
	public Color getLineColor()
	{
		return this.mLineColorButton.getColor();
	}


	/**
	 * 
	 */
	public Color getInnerColor()
	{
		return this.mInnerColorButton.getColor();
	}


	/**
	 * 
	 */
	public Number getLineWidth()
	{
		return this.mEdgeLineWidthSpinner.getNumber();
	}


	/**
	 * 
	 */
	public int getLineType()
	{
		final String typeName = (String)this.mEdgeLineTypeComboBox.getSelectedItem();
		if( typeName==null )
		{
			return -1;
		}
		final Integer num = SGDrawingElementLine.getLineTypeFromName(typeName);
		return num.intValue();
	}


	/**
	 * 
	 * @return
	 */
	public Boolean isTransparent()
	{
		return this.mBackgroundTransparentCheckBox.getSelected();
	}

    
    
	/**
	 * 
	 * @param value
	 */
	public boolean setLeftXValue( final Object obj )
	{
		return this.setValue( this.mLeftXValueTextField, obj );
	}

	
	/**
	 * 
	 * @param value
	 */
	public boolean setRightXValue( final Object obj )
	{
		return this.setValue( this.mRightXValueTextField, obj );
	}


	/**
	 * 
	 * @param value
	 */
	public boolean setTopYValue( final Object obj )
	{
		return this.setValue( this.mTopYValueTextField, obj );
	}

	
	/**
	 * 
	 * @param value
	 */
	public boolean setBottomYValue( final Object obj )
	{
		return this.setValue( this.mBottomYValueTextField, obj );
	}


	/**
	 * 
	 */
	public boolean setLineColor( final Color cl )
	{
		this.mLineColorButton.setColor( cl );
		return true;
	}


	/**
	 * 
	 */
	public boolean setInnerColor( final Color cl )
	{
		this.mInnerColorButton.setColor( cl );
		return true;
	}


	/**
	 * 
	 */
	public boolean setLineWidth( Object obj )
	{
		return this.setValue( this.mEdgeLineWidthSpinner, obj );
	}


	/**
	 * 
	 */
	public boolean setLineType( final Integer type )
	{
		if( type!=null )
		{
			final String typeName = SGDrawingElementLine.getLineTypeName( type.intValue() );
			this.mEdgeLineTypeComboBox.setSelectedItem(typeName);
		}
		else
		{
			this.mEdgeLineTypeComboBox.setSelectedItem( null );
		}

		return true;
	}


	/**
	 * 
	 * @param b
	 * @return
	 */
	public boolean setTransparent( final Boolean b )
	{
		this.mBackgroundTransparentCheckBox.setSelected(b);
		this.setTransparentComponentEnabled(b);
		return true;
	}


	/**
	 * 
	 * @param b
	 * @return
	 */
	private boolean setTransparentComponentEnabled( final Boolean flag )
	{
		boolean b = true;
		if( flag!=null )
		{
			b = flag.booleanValue();
		}

		this.setTransparentComponentEnabled(!b);

		return true;
	}



	/**
	 * 
	 * @param b
	 * @return
	 */
	private boolean setTransparentComponentEnabled( final boolean b )
	{
		this.mTransparentComponentGroup.setEnabled(b);

		if( this.mInnerColorButton.equals( this.mFocusedColorSetButton ) )
		{
			this.mFocusedColorSetButton = this.mLineColorButton;
			this.setColorButtonBorder( true );
		}

		return true;
	}

}


