/* 
 * 画面制御ライブラリ
 * UTF8は2カラム文字までの対応
 */

#ifndef MINATO_CURSES_H
#define MINATO_CURSES_H

#include <stdarg.h>
#include <sys/ioctl.h>
#include <sys/types.h>

///////////////////////////////////////////////////////////////////////
// 変数定義
///////////////////////////////////////////////////////////////////////
enum eTerminalKanjiCode { kTKEucjp, kTKSjis, kTKUtf8 };
extern enum eTerminalKanjiCode gTerminalKanjiCode;

extern int gKeyEscapeWait;      // エスケープキーの待ち時間

///////////////////////////////////////////////////////////////////////
// マクロ定義
///////////////////////////////////////////////////////////////////////
#define kCAReverse 0x1          // 文字列の属性
#define kCABold 0x2
#define kCAUnderline 0x4
#define kCABlack 0x8
#define kCARed 0x10
#define kCAGreen 0x20
#define kCAYellow 0x40
#define kCABlue 0x80
#define kCAMagenta 0x100
#define kCACyan 0x200
#define kCAWhite 0x400
#define kCABackBlack 0x800
#define kCABackRed 0x1000
#define kCABackGreen 0x2000
#define kCABackYellow 0x4000
#define kCABackBlue 0x8000
#define kCABackMagenta 0x10000
#define kCABackCyan 0x20000
#define kCABackWhite 0x40000

/////////////////////////////////////////////////////////////////////
// 関数定義
/////////////////////////////////////////////////////////////////////
void mcurses_init(enum eTerminalKanjiCode code);
        // kitutuki_cursesモジュール初期化 プログラム開始時に呼ぶ
void mcurses_final();
        // kitutuki_cursesモジュール解放 プログラム終了時に呼ぶ

void minitscr();                // kitutuki_curses初期化 minato_cursesを使う前に呼ぶ
void mendwin();                 // kitutuki_curses解放 minato_cursesを使い終わった後に呼ぶ

#define kKeyMapKeysMax 10
#define kKeyMetaFirst 128
void madd_keymap(int key, char keyes[kKeyMapKeysMax]);      // キーマップにキーを追加

void mclear();                          // メモリ上の画面を消去
void mclear_immediately();              // 直接画面を消去
void mclear_online(int y);              // メモリ上の画面を一行消去

void mmove(int y, int x);                           // メモリ上のカーソルを移動
void mmove_immediately(int y, int x);               // 直接画面上のカーソルを移動
int mmvprintw(int y, int x, char* str, ...);        // メモリ上のカーソルを移動してメモリ上に文字列を書き込む
int mmvprintw_immediately(int y, int x, char* str, ...);
                                                    // 直接文字列を書き込む
int mprintw_immediately(char* str, ...);            // 直接文字列を書き込む
int mprintw(char* str, ...);                        // メモリ上に文字列を書き込む

void mattron(int attrs);                // 書き込む文字列の属性を設定
void mattroff();                        // 書き込む文字列の属性の設定を解除

void mbox(int y, int x, int width, int height);     // メモリ上にボックスを描写
void mrefresh();                                    // メモリ上の内容を画面に反映

int mgetmaxx();                 // 画面のサイズ(X方向)
int mgetmaxy();                 // 画面のサイズ(Y方向)

int mgetch(int* meta);          // キーボード入力
int mgetch_nonblock(int* meta); // キーボード入力 入力がなかったら-1を返す

int mkbuf_exist(); // キーボードバッファが存在すれば真を返す

int mis_raw_mode();            // 端末制御を行っているかどうか
void mreset_tty();              // 端末をリセット
void msave_screen();            // 端末の保存
void mrestore_screen();          // 端末の復帰
void mrestore_ttysettings();    // 端末の設定の復帰
void msave_ttysettings();       // 端末の設定の保存

void mbackspace_immediately();
void mbackspace_head_of_line_immediately();
void mmove_line_home_immediately();
void mcursor_right_immediately(int n);
void mcursor_left_immediately(int n);

extern int gMCTtyFd;

#endif

