/* 
 * 漢字関連ライブラリ
 * 湊大典 2008
 */

#ifndef MINATO_KANJI_H
#define MINATO_KANJI_H

#include "kitutuki_extra.h"
#include <wchar.h>

enum eKanjiCode { kEucjp, kSjis, kUtf8, kUtf8Mac, kUnknown };
extern char* gKanjiCodeString[5];
extern char* gIconvKanjiCodeName[5];     // ICONVの漢字コードの名前

void kanji_init();     // 初期化
void kanji_final();    // 解放

BOOL is_utf8_bytes(char* mbs);
    // 文字列がUTf8文字列かどうか
int str_pointer2kanjipos(enum eKanjiCode code, char* mbs, char* point);
    // mbsをeucjp,sjis,UTF文字列と見たときのpointの場所は何文字目かを返す
char* str_kanjipos2pointer(enum eKanjiCode code, char* mbs, int pos);
    // mbsをUTF文字列と見たときのpos文字目の位置を返す
int str_termlen_range(enum eKanjiCode code, char* mbs, int utfpos1, int utfpos2);
    // mbsを漢字と見たときutfpo1文字目からutfpos2文字目までのは端末で何文字分か






extern int is_hankaku(enum eKanjiCode code, unsigned char c);
    // 引数が半角文字一バイト目かどうか
extern int is_kanji(enum eKanjiCode code, unsigned char c);
    // 引数が漢字一バイト目かどうか
extern int is_all_ascii(char* buf);
    // FALSE:漢字まじり TRUE:全部英数字

extern int str_termlen(enum eKanjiCode code, char* mbs);
    // 引数の文字列が画面で何文字か
extern int str_termlen2(enum eKanjiCode code, char* mbs, int pos);
    // 漢字でpos文字目までの端末で何文字か
extern int str_kanjilen(enum eKanjiCode code, char* mbs);
    // 引数の文字列が漢字で何文字か

extern void str_cut(enum eKanjiCode code, char* mbs, int termsize
            , SPACE char* dest_mbs, int dest_byte);
    // mbsから端末上の文字列分(termsize)のみ残して残りを
    // 捨てた文字列をdest_mbsに返す dest_byte: dest_mbsのサイズ
extern void str_cut2(enum eKanjiCode code, char* mbs, int termsize
            , SPACE char* dest_mbs, int dest_byte);
    // mbsから端末上の文字列分(termsize)のみ残して残りを
    // 捨てた文字列をdest_mbsに返す dest_byte: dest_mbsのサイズ
    // 切り捨てた文字列をスペースで埋める
extern void str_cut3(enum eKanjiCode code, char* mbs, int termsize
            , SPACE char* dest_mbs, int dest_byte);
    // mbsから端末上の文字列分(termsize)のみ残して残りを捨てた文字列を
    // dest_mbsに返す dest_byte: dest_mbsのサイズ
    // 切り捨てた文字列をスペースで埋める
    // 切り捨てるのは文字列の前から

#if defined(HAVE_ICONV_H) || defined(HAVE_BICONV_H)

enum eKanjiCode kanji_encode_type(char* buf);
    // 引数の文字列の漢字エンコードを返す

int kanji_convert(char* input_buf, char* output_buf, size_t output_buf_size, enum eKanjiCode input_kanji_encode_type, enum eKanjiCode output_kanji_encode_type);
    // 漢字エンコードの変換。iconvのラッパー
    // output_bufは十分なスペースが割り当てられている必要がある
    // 返り値は-1はエラー 0は成功

#endif

#endif

