#include "saphire.h"
#include <string.h>
#include <strings.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <libgen.h>
#include <dirent.h>
#include <readline/readline.h>
#include <readline/history.h>
#include <oniguruma.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <pwd.h>

#include "config.h"
#include "saphire_extra.h"

#if defined(HAVE_CURSES_H)
#include <curses.h>
#elif defined(HAVE_NCURSES_H)
#include <ncurses.h>
#elif defined(HAVE_NCURSES_NCURSES_H)
#include <ncurses/ncurses.h>
#endif

#include <limits.h>

#if !defined(HAVE_ONIGUCHAR)
#define OnigUChar unsigned char
#endif

#include "saphire_inner.h"

//////////////////////////////////////////////////////////////////////
// static variable
//////////////////////////////////////////////////////////////////////
static vector_obj* files;

//////////////////////////////////////////////////////////////////////
// readline
//////////////////////////////////////////////////////////////////////
static BOOL name_sort(void* left, void* right)
{
    string_obj* l = (string_obj*)left;
    string_obj* r = (string_obj*) right;

    char* lfname = string_c_str(l);
    char* rfname = string_c_str(r);

    if(strcmp(lfname, ".") == 0) return TRUE;
    if(strcmp(lfname, "..") == 0) {
        if(strcmp(rfname, ".") == 0) return FALSE;

        return TRUE;          
    }
    if(strcmp(rfname, ".") == 0) return FALSE;
    if(strcmp(rfname, "..") == 0) return FALSE;

    return strcasecmp(lfname, rfname) < 0;
}


static string_obj* gEditingDir;
static string_obj* gEditingDirQuote;
static BOOL read_one_argument(char* p, string_obj* buf)
{
    /// 単語の区切り記号かどうかのテーブル 127以下なら
    static unsigned char table[] = { 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0 
    };

    BOOL squote = FALSE;
    BOOL dquote = FALSE;
    while(*p && (p - rl_line_buffer < rl_point)) {
        /// 空文字
        if(!squote && !dquote && *p == '"' && *(p+1) == '"') {
            p+=2;
            string_put(buf, "");
        }
        else if(!dquote && !squote && *p == '\'' && *(p+1) == '\'') {
            p+=2;
            string_put(buf, "");
        }
        else if(*p == '\\' && *(p+1) == 't') {
            string_push_back2(buf, '\t');

            p+=2;
        }
        else if(*p == '\\' && *(p+1) == 'n') {
            string_push_back2(buf, '\n');

            p+=2;
        }
        else if(*p == '\\' && *(p+1) == 'r') {
            string_push_back2(buf, '\r');

            p+=2;
        }
        else if(!squote && !dquote && *p == '\\') {
            p++;

            if(*p != 0) {
                string_push_back2(buf, *p);
                p++;
            }
            else {
                break;
            }
        }
        else if(!dquote && *p == '\'') {
            p++;
            squote = !squote;
        }
        else if(!squote && *p == '"') {
            dquote = !dquote;
            p++;
        }
        else if(squote || dquote) {
            if(*p == 0) {
                break;
            }
            else {
                string_push_back2(buf, *p);

                p++;
            }
        }
        else if(((unsigned char)*p) > 127) {
            string_push_back2(buf, *p);
            p++;
        }
        else if(table[*p]) {
            string_put(buf, "");
            p++;
        }
        else {
            string_push_back2(buf, *p);
            p++;
        }
    }
}

void parentname2(char* result, int result_size, char* path)
{
    char* p;

    if(*path == 0) {
        xstrncpy(result, "", result_size);
        return;
    }
    
    if(strcmp(path, "/") == 0) {
        xstrncpy(result, "/", result_size);
        return;
    }

    for(p=path + strlen(path)-1; p != path-1; p--) {
        if(*p == '/') {
            memcpy(result, path, p-path);
            result[p-path] = '/';
            result[p-path+1] = 0;
            
            return;
        }
    }

    xstrncpy(result, "", result_size);
}


#if defined(HAVE_MIGEMO_H)
#include <migemo.h>

migemo* gMigemo;

void migemo_init()
{
    setenv("COMPLETION_ENABLE_MIGEMO", "1", 1);

    char buf[PATH_MAX];
    char migemodir[PATH_MAX];
    gMigemo = migemo_open(NULL);

    snprintf(migemodir, PATH_MAX, "%s", SYSTEM_MIGEMODIR);

    if(gKanjiCode == kUtf8) {
        snprintf(buf, PATH_MAX, "%s/utf-8/migemo-dict", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_MIGEMO, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
        snprintf(buf, PATH_MAX, "%s/utf-8/roma2hira.dat", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_ROMA2HIRA, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
        snprintf(buf, PATH_MAX, "%s/utf-8/hira2kata.dat", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_HIRA2KATA, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
        snprintf(buf, PATH_MAX, "%s/utf-8/han2zen.dat", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_HAN2ZEN, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
    }
    else if(gKanjiCode == kEucjp) {
        snprintf(buf, PATH_MAX, "%s/euc-jp/migemo-dict", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_MIGEMO, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
        snprintf(buf, PATH_MAX, "%s/euc-jp/roma2hira.dat", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_ROMA2HIRA, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
        snprintf(buf, PATH_MAX, "%s/euc-jp/hira2kata.dat", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_HIRA2KATA, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
        snprintf(buf, PATH_MAX, "%s/euc-jp/han2zen.dat", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_HAN2ZEN, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
    }
    else {
        snprintf(buf, PATH_MAX, "%s/cp932/migemo-dict", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_MIGEMO, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
        snprintf(buf, PATH_MAX, "%s/cp932/roma2hira.dat", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_ROMA2HIRA, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
        snprintf(buf, PATH_MAX, "%s/cp932/hira2kata.dat", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_HIRA2KATA, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
        snprintf(buf, PATH_MAX, "%s/cp932/han2zen.dat", migemodir);
        if(migemo_load(gMigemo, MIGEMO_DICTID_HAN2ZEN, buf) == MIGEMO_DICTID_INVALID) {
            fprintf(stderr, "%s is not found\n", buf);
            exit(1);
        }
    }
}

void migemo_final()
{
    onig_end();
    migemo_close(gMigemo);
}

/// 先頭から同じ文字列があるかどうか調べる。
/// 0 == 同じ文字は0文字
/// 1 == 同じ文字は1文字
/// 文字列はmbsとしてみる
int str_headsame(char* str1, char* str2)
{
    char* p1 = str1;
    char* p2 = str2;

    while(*p1 && *p2 && *p1 == *p2) {
        p1++;
        p2++;
    }

    return p1 - str1;
}


char* readline_file_completion_migemo_match(char* text, char* file, regex_t* reg)
{
    int same_point = str_headsame(text, file);

    int r2;
    if(reg && same_point == 0) {
        OnigRegion* region = onig_region_new();
        
        OnigUChar* file2 = (OnigUChar*)file;

        r2 = onig_search(reg, file2, file2 + strlen((char*)file2), file2, file2 + strlen((char*)file2), region, ONIG_OPTION_NONE);

        onig_region_free(region, 1);
    }
    /// text側がfileの部分なら判定するまでも無くマッチ ///
    else if(same_point == strlen(text)) {
        char tmp[PATH_MAX];
        xstrncpy(tmp, file, PATH_MAX);
        return strdup(tmp);
    }
    else {
        OnigUChar * p = migemo_query(gMigemo, text+same_point);

        if(p == NULL) {
           return NULL;
        }

        int r;
        OnigErrorInfo err_info;

        char* p2 = MALLOC(strlen(p)*2);

        char* _p = p;
        char* _p2 = p2;

        while(*_p) {
            if(*_p == '+') {
                *_p2++ = '\\';
                *_p2++ = *_p++;
            }
            else {
                *_p2++ = *_p++;
            }
        }
        *_p2 = 0;

        regex_t* reg;
        if(gKanjiCode == kUtf8) {
            r = onig_new(&reg, p2, p2 + strlen((char*)p2), ONIG_OPTION_DEFAULT, ONIG_ENCODING_UTF8, ONIG_SYNTAX_DEFAULT,  &err_info);
        }
        else if(gKanjiCode == kEucjp) {
            r = onig_new(&reg, p2, p2 + strlen((char*)p2), ONIG_OPTION_DEFAULT, ONIG_ENCODING_EUC_JP, ONIG_SYNTAX_DEFAULT, &err_info);
        }
        else if(gKanjiCode == kSjis) {
            r = onig_new(&reg, p2, p2 + strlen((char*)p2), ONIG_OPTION_DEFAULT, ONIG_ENCODING_SJIS, ONIG_SYNTAX_DEFAULT, &err_info);
        }

        migemo_release(gMigemo, (unsigned char*) p);

        if(r != ONIG_NORMAL) {
            if(strlen(p2) > 2) { onig_free(reg); }

            FREE(p2);
            return NULL;
        }
        OnigRegion* region = onig_region_new();
        
        OnigUChar* file2 = (OnigUChar*)file + same_point;

        r2 = onig_search(reg, file2, file2 + strlen((char*)file2), file2, file2 + strlen((char*)file2), region, ONIG_OPTION_NONE);

        onig_region_free(region, 1);

        if(strlen(p2) > 2) { puts("BBB"); onig_free(reg); }

        FREE(p2);
    }

    if(r2 == 0) {
        char tmp[PATH_MAX];
        xstrncpy(tmp, file, PATH_MAX);
        return strdup(tmp);
    }

    return NULL;
}

static regex_t* gMigemoReg = NULL;

char* readline_file_completion_migemo(const char* text, int rstat)
{
    /// クォートを除外 ///
    char* text2 = MALLOC(strlen(text) +1);
    char* _p = (char*)text;
    char* _p2 = text2;

    while(*_p) {
        if(*_p == '\\') {
            _p++;
        }
        else {
            *_p2++ = *_p++;
        }
    }
    *_p2 = 0;

    static int index, wordlen;

    /// 初期化 ///
    if(rstat == 0) {
        wordlen = strlen(text2);
        index = 0;

        /// migemoのクェリーと正規表現コンパイル結果を得る
        OnigUChar* p = migemo_query(gMigemo, text2);

        if(p == NULL) {
            FREE(text2);
            return NULL;
        }

        int r;
        OnigErrorInfo err_info;

        char* p2 = MALLOC(strlen(p)*2);
        char* _p = p;
        char* _p2 = p2;

        while(*_p) {
            if(*_p == '+') {
                *_p2++ = '\\';
                *_p2++ = *_p++;
            }
            else {
                *_p2++ = *_p++;
            }
        }
        *_p2 = 0;


        if(gKanjiCode == kUtf8) {
            r = onig_new(&gMigemoReg, p2, p2 + strlen((char*)p2), ONIG_OPTION_DEFAULT, ONIG_ENCODING_UTF8, ONIG_SYNTAX_DEFAULT,  &err_info);
        }
        else if(gKanjiCode == kEucjp) {
            r = onig_new(&gMigemoReg, p2, p2 + strlen((char*)p2), ONIG_OPTION_DEFAULT, ONIG_ENCODING_EUC_JP, ONIG_SYNTAX_DEFAULT, &err_info);
        }
        else if(gKanjiCode == kSjis) {
            r = onig_new(&gMigemoReg, p2, p2 + strlen((char*)p2), ONIG_OPTION_DEFAULT, ONIG_ENCODING_SJIS, ONIG_SYNTAX_DEFAULT, &err_info);
        }

        FREE(p2);

        migemo_release(gMigemo, (unsigned char*) p);

        if(r != ONIG_NORMAL) {
            onig_free(gMigemoReg);
            gMigemoReg = NULL;
        }

        // ディレクトリのパートを得る
        string_put(gEditingDir, "");
        read_one_argument(rl_line_buffer, gEditingDir);
        char* tmp = MALLOC(string_length(gEditingDir) + 1);
        parentname2(tmp, string_length(gEditingDir) + 1, string_c_str(gEditingDir));
        string_put(gEditingDir, tmp);

        FREE(tmp);

        /// チルダから始まっている場合 ///
        if(string_c_str(gEditingDir)[0] == '~') {
            char* p = string_c_str(gEditingDir);
            p++;
            string_obj* user = STRING_NEW("");
            while(*p && *p != '/') {
                string_push_back2(user, *p);
                p++;
            }

            /// ユーザー名からホームディレクトリに展開
            string_obj* gEditingDir2 = STRING_NEW("");

            if(string_length(user) == 0) {
                char* home = getenv("HOME");
                if(home) {
                    string_put(gEditingDir2, home);
                }
                else {
                    struct passwd* pw = getpwuid(getuid());
                    if(pw) {
                        string_put(gEditingDir2, pw->pw_dir);
                    }
                    else {
                        string_put(gEditingDir2, "~");
                    }
                }
            }
            else {
                struct passwd* pw = getpwnam(string_c_str(user));
                if(pw) {
                    string_put(gEditingDir2, pw->pw_dir);
                }
                else {
                    string_put(gEditingDir2, "~");
                    string_push_back(gEditingDir2, string_c_str(user));
                }
            }

            string_push_back(gEditingDir2, p);

            string_put(gEditingDir, string_c_str(gEditingDir2));

            string_delete(gEditingDir2);
            string_delete(user);
        }

        /// 補完候補を初期化 ///
        int i;
        for(i=0;i<vector_size(files); i++) {
            string_obj* str = vector_item(files, i);
            string_delete(str);
        }
        vector_clear(files);

        /// 補完候補をディレクトリから読み込み ///
        if(strcmp(string_c_str(gEditingDir), "") != 0) {
            DIR* dir = opendir(string_c_str(gEditingDir));

            if(dir) {
                struct dirent* entry;
                while(entry = readdir(dir)) {
                    if(strcmp(entry->d_name, ".") != 0
                            && strcmp(entry->d_name, "..") != 0)
                    {
                        char buf[PATH_MAX];

                        struct stat _stat;
                        xstrncpy(buf, string_c_str(gEditingDir), PATH_MAX);
                        xstrncat(buf, entry->d_name, PATH_MAX-1);
                        stat(buf, &_stat);

#if defined(__DARWIN__)
                        {
                        char* src = entry->d_name;
                        int des_size = strlen(src)*2;
                        char* des = MALLOC(des_size);
                        if(is_all_ascii(kByte, src)) {
                            xstrncpy(des, src, des_size);
                        }
                        else {
                            /// コンバート ///
                            if(kanji_convert(src, des, des_size, kUtf8Mac, kUtf8) < 0) {
                                xstrncpy(des, src, des_size);
                            }
                        }
                        xstrncpy(buf, des, PATH_MAX);
                        FREE(des);
                        }

#else
                        xstrncpy(buf, entry->d_name, PATH_MAX);
#endif

                        if(S_ISDIR(_stat.st_mode)) {
                            xstrncat(buf, "/", PATH_MAX-1);
                        }

                        vector_add(files, STRING_NEW(buf));

                    }
                }

                closedir(dir);

                (void)vector_sort(files,name_sort);
            }
        }
        else {
            DIR* dir = opendir(".");

            if(dir) {
                struct dirent* entry;
                while(entry = readdir(dir)) {
                    if(strcmp(entry->d_name, ".") != 0
                            && strcmp(entry->d_name, "..") != 0)
                    {
                        char buf[PATH_MAX];

                        struct stat _stat;
                        xstrncpy(buf, "./", PATH_MAX);
                        xstrncat(buf, entry->d_name, PATH_MAX-1);
                        stat(buf, &_stat);

#if defined(__DARWIN__)
                        {
                        char* src = entry->d_name;
                        int des_size = strlen(src)*2;
                        char* des = MALLOC(des_size);
                        if(is_all_ascii(kByte, src)) {
                            xstrncpy(des, src, des_size);
                        }
                        else {
                            /// コンバート ///
                            if(kanji_convert(src, des, des_size, kUtf8Mac, kUtf8) < 0) {
                                xstrncpy(des, src, des_size);
                            }
                        }
                        xstrncpy(buf, des, PATH_MAX);
                        FREE(des);
                        }
#else
                        xstrncpy(buf, entry->d_name, PATH_MAX);
#endif
                        if(S_ISDIR(_stat.st_mode)) {
                            xstrncat(buf, "/", PATH_MAX-1);
                        }
                        vector_add(files, STRING_NEW(buf));
                    }
                }

                closedir(dir);

                (void)vector_sort(files, name_sort);
            }
        }
    }

    while(index < vector_size(files)) {
        char* file = string_c_str(vector_item(files, index));
        index++;

        /// ファイル名の入力がない補完は判定しなくても全てマッチ ///
        if(strcmp(text2, "") == 0) {
            char path[PATH_MAX];
            xstrncpy(path, file, PATH_MAX);

            char path2[PATH_MAX];
            struct stat stat_;

            xstrncpy(path2, string_c_str(gEditingDir), PATH_MAX);
            xstrncat(path2, file, PATH_MAX);
            if(stat(path2, &stat_) == 0) {
                if(S_ISDIR(stat_.st_mode)) {
                    rl_completion_append_character= 0;
                }
                else {
                    rl_completion_append_character= ' ';
                }
            }
            else {
                rl_completion_append_character= ' ';
            }

            string_obj* tmp2 = STRING_NEW("");
            saphire_get_quoted_fname(path, tmp2);
            char* ret = strdup(string_c_str(tmp2));
            string_delete(tmp2);

            FREE(text2);
            return ret;
        }

        /// アスキー文字同士の補完 ///
        else if(is_all_ascii(kByte, (char*)text2) && is_all_ascii(kByte, file)) {
            if(strncmp(text2, file, wordlen) == 0) {
                char path[PATH_MAX];
                xstrncpy(path, file, PATH_MAX);

                string_obj* tmp2 = STRING_NEW("");
                saphire_get_quoted_fname(path, tmp2);
                char* ret = strdup(string_c_str(tmp2));
                string_delete(tmp2);

                xstrncpy(path, string_c_str(gEditingDir), PATH_MAX);
                xstrncat(path, file, PATH_MAX);
                struct stat stat_;
                if(stat(path, &stat_) == 0) {
                    if(S_ISDIR(stat_.st_mode)) {
                        rl_completion_append_character= 0;
                    }
                    else {
                        rl_completion_append_character= ' ';
                    }
                }
                else {
                    rl_completion_append_character= ' ';
                }

                FREE(text2);
                return ret; 
            }
        }
        /// migemo 補完 ///
        else {
            char* ret = readline_file_completion_migemo_match((char*)text2 , file, gMigemoReg);
            if(ret) {
                struct stat stat_;
                char path[PATH_MAX];
                xstrncpy(path, string_c_str(gEditingDir), PATH_MAX);
                xstrncat(path, file, PATH_MAX);
                if(stat(path, &stat_) == 0) {
                    if(S_ISDIR(stat_.st_mode)) {
                        rl_completion_append_character= 0;
                    }
                    else {
                        rl_completion_append_character= ' ';
                    }
                }
                else {
                    rl_completion_append_character= ' ';
                }

                string_obj* tmp = STRING_NEW("");
                saphire_get_quoted_fname(ret, tmp);
                free(ret);
                char* ret =  strdup(string_c_str(tmp));
                string_delete(tmp);

                FREE(text2);
                return ret;
            }
        }
    }

    if(index == 0 && vector_size(files) == 0) {
        index ++;
        rl_completion_append_character= 0;
        FREE(text2);
        return strdup("");
    }

    FREE(text2);

    return NULL;
}
#endif

char* readline_program_completion(const char* text, int stat)
{
    static int index, wordlen;

    if(stat == 0) {
        wordlen = strlen(text);
        index = 0;
    }

    while(index < vector_size(gSaphireProgCompletions)) {
        char* program = string_c_str(vector_item(gSaphireProgCompletions, index));
        index++;

        if(!strncmp(text, program, wordlen)) {
            int l = strlen(program);
            if(l >= 2 && program[l-2] == '-' && program[l-1] == '>') {
                rl_completion_append_character= 0;
            }
            else {
                rl_completion_append_character= ' ';
            }
            return strdup(program);
        }
    }

    return NULL;
}

static vector_obj* gMethodCompletions;

char* readline_method_completion(const char* text, int stat)
{
    static int index, wordlen;

    if(stat == 0) {
        wordlen = strlen(text);
        index = 0;
    }

    while(index < vector_size(gMethodCompletions)) {
        char* method = string_c_str(vector_item(gMethodCompletions, index));
        index++;

        if(!strncmp(text, method, wordlen)) {
            return strdup(method);
        }
    }

    return NULL;
}

static vector_obj* gEnvirons;

char* readline_env_completion(const char* text, int stat_)
{
    static int wordlen, index;
    static hash_it* it;

    if(stat_ == 0) {
        wordlen = strlen(text);
        it = hash_loop_begin(gGlobals);

        index = 0;

        int i;
        for(i=0; i<vector_size(gEnvirons); i++) {
            string_delete(vector_item(gEnvirons, i));
        }
        vector_clear(gEnvirons);

#if !HAVE_DECL_ENVIRON
        extern char **environ;
#endif
        char** p;
        for(p = environ; *p; p++) {
            char env_name[BUFSIZ];

            char* p2 = env_name;
            char* p3 = *p;

            *p2++ = '$';
            while(*p3 != '=' && p2-env_name < BUFSIZ-2) {
                *p2++ = *p3++;
            }

            char* env = getenv(*p);
            struct stat estat;
            if(stat(env, &estat) >= 0) {
                if(S_ISDIR(estat.st_mode)) {
                    *p2++ = '/';
                }
            }
            *p2 = 0;

            vector_add(gEnvirons, STRING_NEW(env_name));
        }
    }

    while(it) {
        char* global = hash_loop_key(it);
        char buf[BUFSIZ];
        snprintf(buf, BUFSIZ, "$%s", global);
        it = hash_loop_next(it);

        if(!strncmp(text, buf, wordlen)) {
            rl_completion_append_character= ' ';
            return strdup(buf);
        }
    }

    while(index < vector_size(gEnvirons)) {
        char* env = string_c_str(vector_item(gEnvirons, index));

        index++;

        if(!strncmp(text, env, wordlen)) {
            rl_completion_append_character= ' ';
            return strdup(env);
        }
    }

    return NULL;
}

static vector_obj* gUserCompletions;

static string_obj* gUserCompletionStatment;
static sStatments* gUserCompletionStatments;

char* readline_file_completion(const char* text, int rstat);

char* readline_user_completion(const char* text, int stat)
{
    static int index, wordlen;

    if(stat == 0) {
        wordlen = strlen(text);
        index = 0;
    }

    while(index < vector_size(gUserCompletions)) {
        char* ucomp = string_c_str(vector_item(gUserCompletions, index));
        index++;

        if(!strncmp(text, ucomp, wordlen)) {
            return strdup(ucomp);
        }
    }

    return NULL;
}

BOOL gDerefCompletionProgram = FALSE;

char* readline_deref_completion(const char* text, int stat)
{
    static hash_it* it;
    static int wordlen;

    if(stat == 0) {
        wordlen = strlen(text);
        it = hash_loop_begin(gRefs);
    }

    while(it) {
        char* key = hash_loop_key(it);
        sRef* ref = hash_loop_item(it);
        it = hash_loop_next(it);

        if(!strncmp(text + 1, key, wordlen-1)) {
            if(gDerefCompletionProgram && ref->mKind == kMCObject & memchecker_is_enable_mem(ref->mMem) == kMCObject) {
                char buf[1024];
                snprintf(buf, 1024, "`%s->", key);
                rl_completion_append_character= 0;
                return strdup(buf);
            }
            else {
                char buf[1024];
                snprintf(buf, 1024, "`%s", key);
                rl_completion_append_character= ' ';
                return strdup(buf);
            }
        }
    }

    return NULL;
}

char* readline_file_completion(const char* text, int rstat)
{
    static int index;

    /// 初期化 ///
    if(rstat == 0) {
        index = 0;

        // ディレクトリのパートを得る
        string_put(gEditingDir, "");
        read_one_argument(rl_line_buffer, gEditingDir);
        char* tmp = MALLOC(string_length(gEditingDir) + 1);
        parentname2(tmp, string_length(gEditingDir) + 1, string_c_str(gEditingDir));
        string_put(gEditingDir, tmp);
        FREE(tmp);

        /// チルダから始まっている場合 ///
        if(string_c_str(gEditingDir)[0] == '~') {
            char* p = string_c_str(gEditingDir);
            p++;
            string_obj* user = STRING_NEW("");
            while(*p && *p != '/') {
                string_push_back2(user, *p);
                p++;
            }

            /// ユーザー名からホームディレクトリに展開
            string_obj* gEditingDir2 = STRING_NEW("");

            if(string_length(user) == 0) {
                char* home = getenv("HOME");
                if(home) {
                    string_put(gEditingDir2, home);
                }
                else {
                    struct passwd* pw = getpwuid(getuid());
                    if(pw) {
                        string_put(gEditingDir2, pw->pw_dir);
                    }
                    else {
                        string_put(gEditingDir2, "~");
                    }
                }
            }
            else {
                struct passwd* pw = getpwnam(string_c_str(user));
                if(pw) {
                    string_put(gEditingDir2, pw->pw_dir);
                }
                else {
                    string_put(gEditingDir2, "~");
                    string_push_back(gEditingDir2, string_c_str(user));
                }
            }

            string_push_back(gEditingDir2, p);

            string_put(gEditingDir, string_c_str(gEditingDir2));

            string_delete(user);
            string_delete(gEditingDir2);
        }

        /// 補完候補を初期化 ///
        int i;
        for(i=0;i<vector_size(files); i++) {
            string_obj* str = vector_item(files, i);
            string_delete(str);
        }
        vector_clear(files);

        /// 補完候補をディレクトリから読み込み ///
        if(strcmp(string_c_str(gEditingDir), "") != 0) {
            DIR* dir = opendir(string_c_str(gEditingDir));

            if(dir) {
                struct dirent* entry;
                while(entry = readdir(dir)) {
                    if(strcmp(entry->d_name, ".") != 0
                            && strcmp(entry->d_name, "..") != 0)
                    {
                        char buf[PATH_MAX];

                        struct stat _stat;
                        xstrncpy(buf, string_c_str(gEditingDir), PATH_MAX);
                        xstrncat(buf, entry->d_name, PATH_MAX);
                        stat(buf, &_stat);

#if defined(__DARWIN__)
                        {
                        char* src = entry->d_name;
                        int des_size = strlen(src)*2;
                        char* des = MALLOC(des_size);
                        if(is_all_ascii(kByte, src)) {
                            xstrncpy(des, src, des_size);
                        }
                        else {
                            /// コンバート ///
                            if(kanji_convert(src, des, des_size, kUtf8Mac, kUtf8) < 0) {
                                xstrncpy(des, src, des_size);
                            }
                        }
                        xstrncpy(buf, des, PATH_MAX);
                        FREE(des);
                        }
#else
                        xstrncpy(buf, entry->d_name, PATH_MAX);
#endif
                        if(S_ISDIR(_stat.st_mode)) {
                            xstrncat(buf, "/", PATH_MAX);
                        }

                        vector_add(files, STRING_NEW(buf));
                    }
                }

                closedir(dir);

                (void)vector_sort(files,name_sort);
            }
        }
        else {
            DIR* dir = opendir(".");

            if(dir) {
                struct dirent* entry;
                while(entry = readdir(dir)) {
                    if(strcmp(entry->d_name, ".") != 0
                            && strcmp(entry->d_name, "..") != 0)
                    {
                        char buf[PATH_MAX];

                        struct stat _stat;
                        xstrncpy(buf, "./", PATH_MAX);
                        xstrncat(buf, entry->d_name, PATH_MAX);
                        stat(buf, &_stat);

#if defined(__DARWIN__)
                        {
                        char* src = entry->d_name;
                        int des_size = strlen(src)*2;
                        char* des = MALLOC(des_size);
                        if(is_all_ascii(kByte, src)) {
                            xstrncpy(des, src, des_size);
                        }
                        else {
                            /// コンバート ///
                            if(kanji_convert(src, des, des_size, kUtf8Mac, kUtf8) < 0) {
                                xstrncpy(des, src, des_size);
                            }
                        }
                        xstrncpy(buf, des, PATH_MAX);
                        FREE(des);
                        }
#else
                        xstrncpy(buf, entry->d_name, PATH_MAX);
#endif
                        if(S_ISDIR(_stat.st_mode)) {
                            xstrncat(buf, "/", PATH_MAX);
                        }
                        vector_add(files, STRING_NEW(buf));
                    }
                }

                closedir(dir);

                (void)vector_sort(files, name_sort);
            }
        }
    }

    while(index < vector_size(files)) {
        char* file = string_c_str(vector_item(files, index));
        index++;

        /// ファイル名の入力がない補完は判定しなくても全てマッチ ///
        if(strcmp(text, "") == 0) {
            char path[PATH_MAX];
            xstrncpy(path, file, PATH_MAX);

            char* ret = strdup(path);

            struct stat stat_;
            xstrncpy(path, string_c_str(gEditingDir),  PATH_MAX);
            xstrncat(path, file, PATH_MAX);
            if(stat(path, &stat_) == 0) {
                if(S_ISDIR(stat_.st_mode)) {
                    rl_completion_append_character= 0;
                }
                else {
                    rl_completion_append_character= ' ';
                }
            }
            else {
                rl_completion_append_character= ' ';
            }

            return ret;
        }

        /// アスキー文字同士の補完 ///
        else {
            /// クォートを除外 ///
            char* text_noquote = MALLOC(strlen(text) +1);
            char* _p = (char*)text;
            char* _p2 = text_noquote;

            while(*_p) {
                if(*_p == '\\') {
                    _p++;
                }
                else {
                    *_p2++ = *_p++;
                }
            }
            *_p2 = 0;

            if(!strncmp(text_noquote, file, strlen(text_noquote))) {
                char path[PATH_MAX];
                xstrncpy(path, file, PATH_MAX);

                string_obj* tmp2 = STRING_NEW("");
                saphire_get_quoted_fname(path, tmp2);
                char* ret = strdup(string_c_str(tmp2));
                string_delete(tmp2);
                xstrncpy(path, string_c_str(gEditingDir), PATH_MAX);
                xstrncat(path, file, PATH_MAX);
                struct stat stat_;
                if(stat(path, &stat_) == 0) {
                    if(S_ISDIR(stat_.st_mode)) {
                        rl_completion_append_character= 0;
                    }
                    else {
                        rl_completion_append_character= ' ';
                    }
                }
                else {
                    rl_completion_append_character= ' ';
                }

                FREE(text_noquote);
                return ret; 
            }

            FREE(text_noquote);
        }
    }

    if(index == 0 && vector_size(files) == 0) {
        index ++;
        rl_completion_append_character= 0;
        return strdup("");
    }

    return NULL;
}

hash_obj* gUserCompRegex;

char** readline_on_complete(const char* text, int start, int end)
{
    BOOL program = TRUE;
    BOOL user = FALSE;
    BOOL env = FALSE;
    BOOL ref = FALSE;
    BOOL method = FALSE;
    BOOL file = FALSE;
    vector_obj* commands = VECTOR_NEW(10);
    string_obj* command = STRING_NEW("");
    string_obj* statment = STRING_NEW("");

    string_obj* buf = STRING_NEW("");

    char* p = rl_line_buffer;

    while(*p == ' ' || *p == '\t' || *p == '\n') {
        p++;
    }

    BOOL squote = FALSE;
    BOOL dquote = FALSE;
    while(p < rl_line_buffer + end) {
        // クォート
        if(*p == '\\') {
            string_push_back2(statment, *p);
            string_push_back2(buf, *p);
            if(program) { string_push_back2(command, *p); }
            p++;
            string_push_back2(buf, *p);
            string_push_back2(statment, *p);
            if(program) { string_push_back2(command, *p); }
            p++;
        }

        // シングルクォート
        else if(!dquote && *p == '\'') {
            string_push_back2(statment, *p);
            string_push_back2(buf, *p);
            if(program) { string_push_back2(command, *p); }
            p++;
            squote = !squote;

            string_put(buf, "");
        }
        // ダブルクォート
        else if(!squote && *p == '"') {
            string_push_back2(statment, *p);
            string_push_back2(buf, *p);
            if(program) { string_push_back2(command, *p); }
            p++;
            dquote = !dquote;

            string_put(buf, "");
        }

        /// シングルクォート、ダブルクォート中 ///
        else if(squote || dquote) {
            string_push_back2(statment, *p);
            string_push_back2(buf, *p);
            if(program) { string_push_back2(command, *p); }
            p++;
        }

        // ブロック、コマンド展開
        else if(*p == '(' || *p == '{') {
            string_push_back2(statment, *p);
            string_push_back2(buf, *p);
            if(program) { string_push_back2(command, *p); }
            p++;

            while(*p == ' ' || *p == '\t' || *p == '\n') { p++; }

            program = TRUE;
            user = FALSE;
            ref = FALSE;
            env = FALSE;
            method = FALSE;
            file = FALSE;

            vector_add(commands, command);
            command = STRING_NEW("");

            string_put(buf, "");
            string_put(statment, "");
        }
        // ブロック、コマンド展開終わり
        else if(*p == ')' || *p == '}') {
            string_push_back2(statment, *p);
            string_push_back2(buf, *p);
            if(program) { string_push_back2(command, *p); }
            p++;

            program = TRUE;
            user = FALSE;
            ref = FALSE;
            env = FALSE;
            method = FALSE;
            file = FALSE;

            string_delete(command);
            command = vector_pop_back(commands);

            string_put(buf, "");
            string_put(statment, "");
        }
        // リファレンス
        else if(*p == '`') {
            string_push_back2(buf, *p);
            if(program) { string_push_back2(command, *p); }
            string_push_back2(statment, *p);
            p++;
            ref = TRUE;
            env = FALSE;
            //program = FALSE;
            user = FALSE;
            method = FALSE;
            file = FALSE;
        }
        // 変数
        else if(*p == '$') {
            string_put(buf, "");
            p++;
            ref = FALSE;
            env = TRUE;
            //program = FALSE;
            user = FALSE;
            method = FALSE;
            file = FALSE;
        }
        /// ユーザー
        else if(*p == '~') {
            string_push_back2(buf, *p);
            if(program) { string_push_back2(command, *p); }
            string_push_back2(statment, *p);
            p++;

            program = FALSE;
            user = TRUE;
            ref = FALSE;
            env = FALSE;
            method = FALSE;
            file = FALSE;
        }
        /// メソッド
        else if(*p == '-' && *(p+1) == '>') {
            p+=2;
            if(program) { 
                sObject* object;
                if(string_length(buf) > 1 && string_c_str(buf)[0] == '`') 
                {
                    sRef* ref = saphire_get_ref(string_c_str(buf) + 1);

                    if(ref && ref->mKind == kMCObject && memchecker_is_enable_mem(ref->mMem) == kMCObject) {
                        object = ref->mMem;
                    }
                    else {
                        object = NULL;
                    }
                }
                else {
                    object = saphire_get_object(string_c_str(buf));
                }

                if(object) {
                    if(gMethodCompletions) {
                        int i;
                        for(i=0; i<vector_size(gMethodCompletions); i++) {
                            string_delete(vector_item(gMethodCompletions, i));
                        }
                        vector_delete(gMethodCompletions);
                    }
                    gMethodCompletions = saphire_methods_names(object);
                    method = TRUE; 
                    program = FALSE;  
                }
                string_put(buf, "");
            }

            user = FALSE;
            ref = FALSE;
            env = FALSE;
        }

        /// リダイレクト
        else if(*p == '<' || *p == '>' || *p == '%') {
            if(program) { string_push_back2(command, *p); }
            string_push_back2(statment, *p);
            p++;

            while(*p == ' ' || *p == '\t' || *p == '\n'|| *p=='>' || *p == '2') {
                string_push_back2(statment, *p);
                if(program) { string_push_back2(command, *p); }
                p++;
            }

            program = FALSE;
            user = FALSE;
            ref = FALSE;
            env = FALSE;
            method = FALSE;
            file = TRUE;

            string_put(buf, "");
        }

        /// 空白 ///
        else if(*p == ' ' || *p == '\t') {
            while(*p == ' ' || *p == '\t') {
                string_push_back2(statment, *p);
                p++;
            }

            program = FALSE;
            user = FALSE;
            ref = FALSE;
            env = FALSE;
            method = FALSE;
            file = FALSE;

            string_put(buf, "");
        }
        
        /// パイプ ///
        else if(*p == '|' && *(p+1) != '|') {
            string_push_back2(statment, *p);
            p++;

            program = TRUE;
            user = FALSE;
            ref = FALSE;
            env = FALSE;
            method = FALSE;
            file = FALSE;

            while(*p == ' ' || *p == '\t' || *p == '\n') {
                string_push_back2(statment, *p);
                p++;
            }

            string_put(command, "");
            string_put(buf, "");
        }
        
        /// 論理演算
        else if(*p == '&' && *(p+1) == '&' || *p == '|' && *(p+1) == '|') {
            p++;
            p++;

            program = TRUE;
            user = FALSE;
            ref = FALSE;
            env = FALSE;
            method = FALSE;
            file = FALSE;

            while(*p == ' ' || *p == '\t' || *p == '\n') {
                p++;
            }

            string_put(command, "");
            string_put(statment, "");
            string_put(buf, "");
        }
        /// バックグラウンド ///
        else if(*p == '&' || *p == ';' || *p == '\n') {
            p++;
            while(*p == ' ' || *p == '\t' || *p == '\n') { p++; }

            program = TRUE;
            user = FALSE;
            ref = FALSE;
            env = FALSE;
            method = FALSE;
            file = FALSE;

            string_put(buf, "");
            string_put(command, "");
            string_put(statment, "");
        }
        /// コメント ///
        else if(*p == '#') {
            p++;

            while(*p && *p != '\n') {
                p++;
            }
            while(*p == ' ' || *p == '\t' || *p == '\n') {
                p++;
            }
            program = TRUE;
            user = FALSE;
            ref = FALSE;
            env = FALSE;
            method = FALSE;
            file = FALSE;

            string_put(buf, "");
            string_put(command, "");
            string_put(statment, "");
        }
        else if(*p == '/') {
            user = FALSE;
            string_push_back2(buf, *p);
            if(program) { string_push_back2(command, *p); }
            string_push_back2(statment, *p);
            p++;
        }
        /// 終了 ///
        else if(*p == 0) {
            break;
        }

        else {
            string_push_back2(buf, *p);
            if(program) { string_push_back2(command, *p); }
            string_push_back2(statment, *p);
            p++;
        }
    }
/*
    /// 最後の単語入力に=が入っている場合ファイル名の補完がしたい
    if(strstr(string_c_str(buf), "=")) {
        file = TRUE;
    }
*/

    /// コマンドの補完でもファイル名に/が入っている場合はファイル名の補完にしたい
    if(strstr(string_c_str(command), "/")) {
        program = FALSE;
    }

    sStatments* statments = hash_item(gUserCompRegex, string_c_str(command));

    string_delete(command);
    string_delete(buf);
    int i;
    for(i=0; i<vector_size(commands); i++) {
        string_delete(vector_item(commands, i));
    }
    vector_delete(commands);

#if defined(HAVE_MIGEMO_H)
    if(file) {
        string_delete(statment);
        char** str = rl_completion_matches(text, readline_file_completion_migemo);
        if(gMigemoReg) { onig_free(gMigemoReg); gMigemoReg = NULL; }
        return str;
    }
#else
    if(file) {
        string_delete(statment);
        return rl_completion_matches(text, readline_file_completion);
    }
#endif
    else if(user) {
        rl_completion_append_character= 0;
        string_delete(statment);
        return rl_completion_matches(text, rl_username_completion_function);
    }
    else if(ref) {
        gDerefCompletionProgram = program;
        string_delete(statment);
        return rl_completion_matches(text, readline_deref_completion);
    }
    else if(env) {
        string_delete(statment);
        return rl_completion_matches(text, readline_env_completion);
    }
    else if(method) {
        rl_completion_append_character= ' ';
        string_delete(statment);
        return rl_completion_matches(text, readline_method_completion);
    }
    else if(program) {
        rl_completion_append_character= ' ';
        string_delete(statment);
        return rl_completion_matches(text, readline_program_completion);
    }
    else if(statments) {
        saphire_set_global_var("COMPLETION_ADD_SPACE", "1");

        int k;
        for(k=0; k<vector_size(gUserCompletions); k++) {
            string_obj* str = vector_item(gUserCompletions, k);
            string_delete(str);
        }
        vector_clear(gUserCompletions);

        sWFd* pipeout = WFD_NEW(-1);
        sRFd* pipein = RFD_NEW2(-1, string_c_str(statment));
        string_delete(statment);

        int rcode = saphire_run(statments, "user completion", pipeout, pipein,  2);
        if(rcode == 0) {
            char* p = pipeout->mBuffer;
            while(1) {
                string_obj* str = STRING_NEW("");
                while(1) {
                    if(*p == 0) {
                        break;
                    }
                    else if(*p == '\n') {
                        p++;
                        break;
                    }
                    else {
                        string_push_back2(str, *p);
                        p++;
                    }
                }

                if(string_c_str(str)[0] != 0) {
                    vector_add(gUserCompletions, str);
                }
                else {
                    string_delete(str);
                }

                if(*p == 0) break;
            }
        }
        else if(rcode > 0) {
            sWFd_delete(pipeout);
            sRFd_delete(pipein);

#if defined(HAVE_MIGEMO_H)
            char** str = rl_completion_matches(text, readline_file_completion_migemo);
            if(gMigemoReg) { onig_free(gMigemoReg); gMigemoReg = NULL; }
            return str;
#else
            return rl_completion_matches(text, readline_file_completion);
#endif
        }
        else {
            fprintf(stderr, "run time err\n");
            fprintf(stderr, "%s", string_c_str(gErrMsg));

            sWFd_delete(pipeout);
            sRFd_delete(pipein);
            return NULL;
        }
        sWFd_delete(pipeout);
        sRFd_delete(pipein);

        char* returned_variable = saphire_get_global_var("COMPLETION_ADD_SPACE");
        if(returned_variable && strcmp(returned_variable, "0") == 0) {
            rl_completion_append_character= 0;
        } else {
            rl_completion_append_character= ' ';
        }

        return rl_completion_matches(text, readline_user_completion);
    }
#if defined(HAVE_MIGEMO_H)
    else {
        string_delete(statment);
        char** str = rl_completion_matches(text, readline_file_completion_migemo);
        if(gMigemoReg) { onig_free(gMigemoReg); gMigemoReg = NULL; }
        return str;
    }
#else
    else {
        string_delete(statment);
        return rl_completion_matches(text, readline_file_completion);
    }
#endif

    return NULL;
}

static int skip_quoted(const char *s, int i, char q)
{
   while(s[i] && s[i]!=q) 
   {
      if(s[i]=='\\' && s[i+1]) i++;
      i++;
   }
   if(s[i]) i++;
   return i;
}

int lftp_char_is_quoted(const char *string,int eindex)
{
  int i, pass_next;

  for (i = pass_next = 0; i <= eindex; i++)
    {
      if (pass_next)
        {
          pass_next = 0;
          if (i >= eindex)
            return 1;
          continue;
        }
      else if (string[i] == '"' || string[i] == '\'')
        {
          char quote = string[i];
          i = skip_quoted (string, ++i, quote);
          if (i > eindex)
            return 1;
          i--;  /* the skip functions increment past the closing quote. */
        }
      else if (string[i] == '\\')
        {
          pass_next = 1;
          continue;
        }
    }
  return (0);
}

static int readline_macro(int count, int key)
{
    char* tmp = MALLOC(strlen(rl_line_buffer) + 1);
    xstrncpy(tmp, rl_line_buffer, strlen(rl_line_buffer) +1);
    tmp[rl_point] = 0;

    sWFd* pipeout = WFD_NEW(-1);
    sRFd* rfd = RFD_NEW(-1);
    sRFd_set_buffer(rfd, tmp);
    FREE(tmp);
    if(saphire_shell3(pipeout, "macro", "SAPHIRE_MACRO", rfd) < 0) {
        sWFd_delete(pipeout);
        sRFd_delete(rfd);
        fprintf(stderr, "run time err\n");
        fprintf(stderr, "%s", string_c_str(gErrMsg));
        fprintf(stderr, "please press cntrol + l....\n");
        return 0;
    }
    sRFd_delete(rfd);

    rl_insert_text(pipeout->mBuffer);

    sWFd_delete(pipeout);

    return 0;
}

BOOL commands_history(int* rcode, vector_obj* argv, vector_obj* blocks, vector_obj* parent_blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, BOOL input,char* sname, int sline)
{
    HIST_ENTRY** history = history_list();

    while(*history) {
        if(!statment_tree_internal_commands_write_nextout(nextout, (*history)->line) )
        {
            err_msg("signal interrupt", sname, sline);
            return FALSE;
        }
        if(!statment_tree_internal_commands_write_lf(nextout,  kLF))
        {
            err_msg("singal interrupt", sname, sline);
            return FALSE;
        }
        history++;
    }

    *rcode = 0;

    return TRUE;
}

BOOL commands_add_history(int* rcode, vector_obj* argv, vector_obj* blocks, vector_obj* parent_blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, BOOL input, char* sname, int sline)
{
    string_obj* str;
    if(input) {
        str = STRING_NEW("");
        int result = statment_tree_internal_commands_read_nextin_oneline(nextin, str, kLF);
        if(result < 0) {
            err_msg("interrupt", sname, sline);
            return FALSE;
        }
        else if(result == 1) {
            *rcode = 1;
            return TRUE;
        }
        string_chomp(str);
    }
    else if(vector_size(argv) >= 2) {
        str = vector_item(argv, 1);
    }

    /// ヒストリに追加 ///
    int histsize = atoi(getenv("SAPHIRE_HISTSIZE"));
    if(histsize < 0) histsize = 1000;

    add_history(string_c_str(str));
    HISTORY_STATE* history_state = history_get_history_state();
    int history_num = history_state->length;
    if(history_num > histsize) {
        HIST_ENTRY* history = remove_history(0);
        free(history);
    }

    *rcode = 0;

    return TRUE;
}

BOOL commands_read_history(int* rcode, vector_obj* argv, vector_obj* blocks, vector_obj* parent_blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, BOOL input, char* sname, int sline)
{
    char* histfile = getenv("SAPHIRE_HISTFILE");
    if(histfile) {
        read_history(histfile);
        *rcode = 0;
    }

    return TRUE;
}

BOOL commands_write_history(int* rcode, vector_obj* argv, vector_obj* blocks, vector_obj* parent_blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, BOOL input, char* sname, int sline)
{
    char* histfile = getenv("SAPHIRE_HISTFILE");
    if(histfile) {
        write_history(histfile);
        *rcode = 0;
    }

    return TRUE;
}

BOOL commands_clear_history(int* rcode, vector_obj* argv, vector_obj* blocks, vector_obj* parent_blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, BOOL input, char* sname, int sline)
{
    clear_history();
    *rcode = 0;

    return TRUE;
}

BOOL commands_remove_history(int* rcode, vector_obj* argv, vector_obj* blocks, vector_obj* parent_blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, BOOL input, char* sname, int sline)
{
    if(vector_size(argv) == 2) {
        HIST_ENTRY* history = remove_history(atoi(string_c_str(vector_item(argv, 1))));
        free(history);
        *rcode = 0;
    }

    return TRUE;
}

BOOL commands_call_completion(int* rcode, vector_obj* argv, vector_obj* blocks, vector_obj* parent_blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, BOOL input, char* sname, int sline)
{
    if(vector_size(argv) >= 2) {
        string_obj* command = vector_item(argv, 1);

        sStatments* statments;
        if(string_c_str(command) != 0) {
            statments = hash_item(gUserCompRegex, string_c_str(command));
        }
        else {
            statments = NULL;
        }
        if(statments) {
            *rcode = 0;
            int rcode2 = saphire_run(statments, "user completion", nextout, nextin,  nexterr);
            if(rcode2 >= 0) {
                return TRUE;
            }
        }
        else {
            return TRUE;
        }
    }

    return FALSE;
}

BOOL commands_completion(int* rcode, vector_obj* argv, vector_obj* blocks, vector_obj* parent_blocks, sWFd* nextout, sRFd* nextin, int nexterr, char* title, BOOL input, char* sname, int sline)
{
    if(vector_size(argv) >= 2 && vector_size(blocks) == 1) {
        sBlock* block = vector_item(blocks, 0);
        sStatments* statments = block->mStatments;

        int i;
        for(i=1; i<vector_size(argv); i++) {
            char* command = string_c_str(vector_item(argv, i));

            sStatments* statments2 = hash_item(gUserCompRegex, command);
            if(statments2) {
                sStatments_delete(statments2);
            }
            hash_put(gUserCompRegex, command, STATMENTS_NEW2(statments));

            *rcode = 0;
        }
    }

    return TRUE;
}

static void read_rc_obj_file()
{
    char rc_fname[PATH_MAX];
    snprintf(rc_fname, PATH_MAX, "%s/completion.sao", SYSCONFDIR);

    if(access(rc_fname, R_OK) == 0) {
        sWFd* pipeout = WFD_NEW(STDOUT_FILENO);
        sRFd* pipein = RFD_NEW(STDIN_FILENO);
        saphire_init_stack_frame();
        if(saphire_load_obj(rc_fname
           , pipeout, pipein, STDERR_FILENO, NULL) < 0)
        {
            fprintf(stderr, "%s", string_c_str(gErrMsg));
            exit(1);
        }
        if(!sWFd_flash(pipeout)) {
            fprintf(stderr, "can't flash rc");
            exit(1);
        }
        sWFd_delete(pipeout);
        sRFd_delete(pipein);
    }
    else {
        fprintf(stderr, "can't find %s file\n", rc_fname);
        exit(1);
    }

    /// ユーザーのランタイムスクリプト ////
    char* user_rc_fname = getenv("SAPHIRE_COMPL_USERRC");
    if(user_rc_fname) {
        if(access(user_rc_fname, R_OK) == 0) {
            sWFd* pipeout = WFD_NEW(STDOUT_FILENO);
            sRFd* pipein = RFD_NEW(STDIN_FILENO);
            saphire_init_stack_frame();
            if(saphire_load_obj(user_rc_fname
                , pipeout, pipein, STDERR_FILENO, NULL) < 0)
            {
                fprintf(stderr, "%s", string_c_str(gErrMsg));
                exit(1);
            }
            sWFd_flash(pipeout);
            sRFd_delete(pipein);
            sWFd_delete(pipeout);
        }
    }
}

char* readline_on_complete_entry(const char* a, int b)
{
    return NULL;
}

void readline_init(BOOL runtime_script)
{
    gUserCompRegex = HASH_NEW(100);
    gUserCompletions = VECTOR_NEW(50);

    gUserCompletionStatment = NULL;
    gUserCompletionStatments = NULL;

    rl_attempted_completion_function = readline_on_complete;
    rl_completer_quote_characters = "\"'";
    rl_completer_word_break_characters = " \t\n\"'|!&;()<>=%/";
    rl_filename_quote_characters = " \\\t\n\"|$*?[]<>{}&;#()'%";
    rl_completion_append_character= ' ';
    rl_char_is_quoted_p = (rl_linebuf_func_t*)lftp_char_is_quoted;
    rl_completion_entry_function = readline_on_complete_entry;

#if defined(HAVE_MIGEMO_H)
    migemo_init();
#endif

    gEditingDir = STRING_NEW("");
    gEditingDirQuote = STRING_NEW("");
    gMethodCompletions = NULL;

    rl_bind_key('x'-'a'+1, readline_macro);
    //rl_bind_key('x'-'a'+1, readline_select_file);
    
    saphire_add_inner_command("history", commands_history);
    saphire_add_inner_command("add_history", commands_add_history);
    saphire_add_inner_command("read_history", commands_read_history);
    saphire_add_inner_command("write_history", commands_write_history);
    saphire_add_inner_command("clear_history", commands_clear_history);
    saphire_add_inner_command("remove_history", commands_remove_history);
    saphire_add_inner_command("completion", commands_completion);
    saphire_add_inner_command("call_completion", commands_call_completion);
    char* read_rc_env = getenv("SAPHIRE_USER_COMPLETION");
    if(runtime_script && read_rc_env && strcmp(read_rc_env, "1") == 0) {
        read_rc_obj_file();
    }

    files = VECTOR_NEW(30);
    
    gEnvirons = VECTOR_NEW(10);
}

void readline_final()
{
    if(gMethodCompletions) {
        int i;
        for(i=0; i<vector_size(gMethodCompletions); i++) {
            string_delete(vector_item(gMethodCompletions, i));
        }
        vector_delete(gMethodCompletions);
    }

    hash_it* it = hash_loop_begin(gUserCompRegex);
    while(it) {
        sStatments_delete(hash_loop_item(it));

        it = hash_loop_next(it);
    }
    hash_delete(gUserCompRegex);

    int k;
    for(k=0; k<vector_size(gUserCompletions); k++) {
        string_obj* str = vector_item(gUserCompletions, k);
        string_delete(str);
    }
    vector_delete(gUserCompletions);
    int i;
    for(i=0;i<vector_size(files); i++) {
        string_obj* str = vector_item(files, i);
        string_delete(str);
    }
    vector_delete(files);
    for(i=0; i<vector_size(gEnvirons); i++) {
        string_delete(vector_item(gEnvirons, i));
    }
    vector_delete(gEnvirons);
    string_delete(gEditingDir);
    string_delete(gEditingDirQuote);
#if defined(HAVE_MIGEMO_H)
    migemo_final();
#endif
}
