#pragma once
#include <string>

/** This utility object is used to get repeated string or character.
 *  as value: copy(no), default(no).
 *  \Usage:
 StringRepeat filler('0');
 return filler*10; //=> "0000000000"
*/
class StringRepeat
{
	std::string m_str;
public:
	/** Object set original string.*/
	StringRepeat(std::string str) :m_str(str) { }
	/** Object can set character.*/
	StringRepeat(char c) :m_str("") { m_str += c; }
	/** up-cast convert to std::string.*/
	operator std::string()const { return m_str; }
	
	/** assign.*/
	StringRepeat& operator=(std::string str)
	{
		m_str = str;
		return *this;		
	}
	
	/** return new string */
	std::string repeat(unsigned n_times)const 
	{
		if (m_str.empty()){
			return "";
		}
		std::string result;
		for (unsigned i=0; i < n_times; ++i){
			result+=m_str;
		}
		return result;
	}
	
	/** abbreviation */
	std::string operator*(unsigned n_times)const { return repeat(n_times); }
	StringRepeat& operator*=(unsigned n_times)
	{
		m_str = repeat(n_times);
		return *this;
	}

};
