#pragma once

#include <map>

namespace chocolat{ namespace container {

/** container adaptor for map<T,bool>.*/
template<typename _Tp>
class Marker
{
public:
	typedef _Tp									value_type;
	typedef std::map<value_type, bool>			map;
	typedef typename map::iterator				iterator;
	typedef typename map::const_iterator		const_iterator;
	typedef boost::shared_ptr<Marker>			shared_ptr;
private:
	std::map<value_type, bool> m_map;
public:
	unsigned size()const
	{
		return m_map.size();
	}
	Marker::iterator begin()
	{
		return m_map.begin();
	}
	Marker::iterator end()
	{
		return m_map.end();
	}
	Marker::const_iterator begin()const
	{
		return m_map.begin();
	}
	Marker::const_iterator end()const
	{
		return m_map.end();
	}
	bool found(Marker::value_type val)const
	{
		return m_map.find(val) != m_map.end();
	}
	void mark(Marker::value_type val)
	{
		m_map[val] = true;
	}
	void erase(Marker::value_type val)
	{
		auto i = m_map.find(val);
		if (i != m_map.end()){
			m_map.erase(i);
		}
	}
	void clear()
	{
		m_map.clear();
	}
	
};

}}
