/*
 * $Id: heap.h,v 1.1 2004/06/22 12:23:39 jklein Exp $
 * $Author: jklein $
 * $Log: heap.h,v $
 * Revision 1.1  2004/06/22 12:23:39  jklein
 * correcting mistakes.
 *
 */


#ifndef _SCALL_HEAP_H_
#define _SCALL_HEAP_H_

#include "scale/commons.h"


typedef struct _sc_heap sheap_t;


struct _sc_heap {
	size_t memsize;
	size_t count;
	size_t next_index;
	sc_compf_t compare;
	spointer *array;
};


sheap_t *		s_heap_alloc(sc_compf_t compare);
sheap_t *		s_heap_allocn(sc_compf_t compare, size_t inisize);
void			s_heap_free(sheap_t *heap);
void			s_heap_push(sheap_t *heap, spointer contents);
spointer		s_heap_pop(sheap_t *heap);
spointer		s_heap_peek(sheap_t *heap);
size_t			s_heap_size(sheap_t *heap);


/* sub actions */
spointer		s_heap_get(sheap_t *, size_t index);


#endif /* _SCALL_HEAP_H_ */
