/**
 * $Id: stack.h,v 1.2 2004/06/21 16:44:17 jklein Exp $
 * $Author: jklein $
 * $Log: stack.h,v $
 * Revision 1.2  2004/06/21 16:44:17  jklein
 * Added iterator.
 *
 */


#ifndef _SC_STACK_H_
#define _SC_STACK_H_

#include "scale/commons.h"
#include "scale/vector.h"

typedef svector_t sstack_t;


#define s_stack_alloc()			(sstack_t *)s_vector_alloc()
#define s_stack_allocn(n)		(sstack_t *)s_vector_allocn(n)
#define s_stack_free(s)			s_vector_free((svector_t *)(s))
#define s_stack_size(s)			s_vector_size((svector_t *)(s))
#define s_stack_push(s, c)		s_vector_add((svector_t *)(s), c)
#define s_stack_find(s, c, f)	s_vector_find((svector_t *)(s), c, f);

spointer		s_stack_peek(sstack_t *);
spointer		s_stack_pop(sstack_t *);


#endif /* _SC_STACK_H_ */
