/**
 * $Id: sc_commons.c,v 1.5 2004/06/24 00:08:35 jklein Exp $
 * $Author: jklein $
 * $Log: sc_commons.c,v $
 * Revision 1.5  2004/06/24 00:08:35  jklein
 * added s_buffer_compare()
 *
 * Revision 1.4  2004/06/22 12:22:27  jklein
 * Added heap(sc_heap.c | scale/heap.h).
 *
 * Revision 1.3  2004/06/21 16:44:17  jklein
 * Added iterator.
 *
 */


#include <string.h>
#include "scale/commons.h"
#include "scale/buffer.h"


sint8
s_string_compare(const spointer p1, const spointer p2)
{
	const char *str1 = (char *)p1;
	const char *str2 = (char *)p2;

	if (p1 == NULL && p2 != NULL)
		return -1;
	else if(p1 != NULL && p2 == NULL)
		return 1;

	return strcmp(str1, str2);
}


sint8
s_string_rcompare(const spointer p1, const spointer p2)
{
	return s_string_compare(p2, p1);
}


sint8
s_buffer_compare(const spointer p1, const spointer p2)
{
	const sbuffer_t *b1 = (sbuffer_t *)p1;
	const sbuffer_t *b2 = (sbuffer_t *)p2;

	if (p1 == NULL && p2 != NULL)
		return -1;
	else if(p1 != NULL && p2 == NULL)
		return 1;

	return strcmp(b1->string, b2->string);
}


sint8
s_buffer_rcompare(const spointer p1, const spointer p2)
{
	return s_buffer_compare(p2, p1);
}


sint8
s_pointer_compare(const spointer p1, const spointer p2)
{
	return p1 - p2;
}
