/*
 * $Id: xarray.h,v 1.3 2004/06/28 09:51:09 jklein Exp $
 * $Author: jklein $
 * $Log: xarray.h,v $
 * Revision 1.3  2004/06/28 09:51:09  jklein
 * interface was changed in scale/iterator.h
 *
 * Revision 1.2  2004/06/27 13:35:17  jklein
 * Added few functions for sbuffer_t and few macros for sxarray_t.
 *
 * Revision 1.1  2004/06/24 15:16:50  jklein
 * sxarray_t was added for abstruction of collection structure.
 *
 */

/**
 * $BCj>]2DJQD9G[Ns$rI=$9(Bsxarray_t$B$H0lO"$N4X?t!J<B:]$O%^%/%m!K$rDs6!$9$k!#(B
 * sxarray_t$B$O(Bs_list_xarray()$B$d(Bs_vector_xarray()$B$rDL$7$F:n@.$5$l$k!#(B
 *
 * sxarray_t$B$K4XO"$7$?A4$F$N4X?t%^%/%m!J5Z$S(Bsxarray_t$B$K4^$^$l$k4X?t%]%$%s%?!K(B
 * $B$NBh0l0z?t$K$O(B`$BI,$:(B'$B$=$N9=B$BN<+?H$rEO$9$3$H!#$=$l$,!"H~$7$/$J$$0Y!"(B
 * $B0lHLE*$K$O4X?t%^%/%m$r;HMQ$9$k$3$H$r?d>)$9$k!#(B
 * 
 * $B!JNc!K(Bxarr->get(xarr, 1) <--> s_xarray_get(xarr, 1)
 * $B!JNc!K(Bxarr->add(xarr, p) <--> s_xarray_add(xarr, p)
 */

#ifndef _SCALE_XARRAY_H_
#define _SCALE_XARRAY_H_

#include "scale/commons.h"
#include "scale/iterator.h"


/** $BCj>]2DJQD9G[Ns%*%V%8%'%/%H(B */
typedef struct _sc_xarray sxarray_t;


#define s_xarray_free(xa) (xa->free(xa))
#define s_xarray_size(xa) (xa->size(xa))
#define s_xarray_insert_at(xa, idx, data) (xa->insert_at(xa, idx, data))
#define s_xarray_add(xa, data) (xa->add(xa, data))
#define s_xarray_get(xa, idx) (xa->get(xa, idx))
#define s_xarray_remove(xa, idx) (xa->remove(xa, idx))
#define s_xarray_find(xa, __cmpf, data) (xa->find(xa, __cmpf, data))
#define s_xarray_iterator(xa) (xa->iterator(xa))
#define s_xarray_sort(xa, __cmpf) (xa->sort(xa))
#define s_xarray_join(xd, xs) (xd->join(xd, xs))


struct _sc_xarray {
	spointer listdata;

	/* sxarray interfaces */
	
	void		(*free)(sxarray_t *);		
	size_t		(*size)(sxarray_t *);
	void		(*insert_at)(sxarray_t *, uint, spointer);
	void		(*add)(sxarray_t *, spointer); 
	spointer	(*get)(sxarray_t *, uint) ;
	spointer	(*remove)(sxarray_t *, uint);
	sint32		(*find)(sxarray_t *, sc_compf_t, spointer);
	siterator_t * (*iterator)(sxarray_t *);
	void		(*sort)(sxarray_t *, sc_compf_t);
	void		(*join)(sxarray_t *, sxarray_t *);

	/* -- CAUTION ---------------------
	   Do never touch thing below here.
	   these are for scale-library.
	---------------------------------- */
	sboolean is_origin;
};


#endif /* _SCALE_XARRAY_H_ */
