
#include "scale/heap.h"
#include "scale/alloc.h"


#define DEF_HEAP_SIZE 64

sheap_t *
s_heap_alloc(sc_compf_t compare)
{
	return s_heap_allocn(compare, DEF_HEAP_SIZE);
}


sheap_t *
s_heap_allocn(sc_compf_t compare, size_t inisize)
{
	sheap_t *heap;

	if (inisize <= 1)
		inisize = 2;

	heap = typed_malloc(sheap_t);
	heap->memsize = inisize;
	heap->count = 0;
	heap->next_index = 1; /* we are not using index=0. */
	heap->compare = compare;
	heap->array = (spointer *)s_calloc(heap->memsize, sizeof(spointer));
	
	return heap;
}


void
s_heap_free(sheap_t *heap)
{
	s_freen(heap->array, sizeof(spointer) * heap->memsize);
	s_freen(heap, sizeof(sheap_t));
}


void
s_heap_push(sheap_t *heap, spointer contents)
{
	size_t pindex, cindex;
	spointer temp;

	heap->array[heap->next_index] = contents;

	cindex = heap->next_index;
	while ((pindex = HEAP_PARENT_INDEX(cindex)) != 0 &&
		   heap->compare(heap->array[pindex], heap->array[cindex]) < 0) {
		temp = heap->array[pindex];
		heap->array[pindex] = heap->array[cindex];
		heap->array[cindex] = temp;

		cindex = pindex;
	}

	++heap->count;
	++heap->next_index;
}


spointer
s_heap_pop(sheap_t *heap)
{
	spointer contents;
	spointer temp;
	size_t pindex, lindex, rindex, tindex;

	if (s_heap_size(heap) == 0)
		return NULL;

	contents = heap->array[1];

	--heap->count;
	--heap->next_index;

	heap->array[1] = heap->array[heap->next_index];
	heap->array[heap->next_index] = NULL;

	pindex = 1;
	while (1) {
		lindex = HEAP_LCHILD_INDEX(pindex);
		rindex = HEAP_RCHILD_INDEX(pindex);

		/* which is bigger. left or right?
		 * if right-node wasn't NULL, left-node is not too.
		 */
		if (heap->array[rindex] == NULL) {
			if (heap->array[lindex] == NULL)
				tindex = 0;
			else
				tindex = lindex;
		}
		else {
			tindex = (heap->compare(heap->array[lindex],
									heap->array[rindex]) > 0)?lindex:rindex;
		}

		if (tindex == 0 ||
			heap->compare(heap->array[tindex], heap->array[pindex]) <= 0)
			break;

		/* swap */
		temp = heap->array[tindex];
		heap->array[tindex] = heap->array[pindex];
		heap->array[pindex] = temp;

		pindex = tindex;
	}
	
	return contents;
}


spointer
s_heap_peek(sheap_t *heap)
{
	return heap->array[1];
}


size_t
s_heap_size(sheap_t *heap)
{
	return heap->count;
}


spointer
s_heap_get(sheap_t *heap, size_t index)
{
	/* remember array index in heap-array is starting from 1. */
	++index;

	if (index >= s_heap_size(heap))
		return NULL;
	else
		return heap->array[index];
}
