/*
 * $Id: buffer.h,v 1.6 2004/06/28 09:51:09 jklein Exp $
 * $Author: jklein $
 * $Log: buffer.h,v $
 * Revision 1.6  2004/06/28 09:51:09  jklein
 * interface was changed in scale/iterator.h
 *
 * Revision 1.5  2004/06/27 13:35:17  jklein
 * Added few functions for sbuffer_t and few macros for sxarray_t.
 *
 * Revision 1.4  2004/06/26 06:58:13  jklein
 * small fix in each header files.
 *
 * Revision 1.3  2004/06/24 15:16:50  jklein
 * sxarray_t was added for abstruction of collection structure.
 *
 * Revision 1.2  2004/06/21 16:44:17  jklein
 * Added iterator.
 *
 */

/**
 * $BJ8;zNs%P%C%U%!$rI=$9(Bsbuffer_t$B9=B$BN$N0lO"$NA`:n4X?t$rDs6!$9$k!#(B
 * $BJ8;zNs$N?-$S=L$_$r<+F0E*$K4IM}$9$k$N$G!"MQ0U$5$l$?4X?t$rDL$7$F(B
 * $BA`:n$9$kJ,$K$O%P%C%U%!!&%*!<%P!<%U%m!<Ey$NLdBj$r2sHr$G$-$k!#(B
 * $B8z2LE*$K%a%b%j<~JU$NLdBj$r2sHr$9$k$?$a$K(Bsbuffer_t->string$B$KBP$7(B
 * $B$FD>@\=q$-$3$`$h$&$J$3$H$OHr$1$k$Y$-$@$,!"FI$_<h$j$K4X$7$F$O$3$N(B
 * $B8B$j$G$O$J$$!#0J2<!"%5%s%W%k(B
 *
 * <pre>
 * sbuffer_t *sbuf = s_buffer_alloc(10);
 * s_buffer_strcpy(sbuf, "Hoge");
 * s_buffer_strcat(sbuf, "Foo");
 * printf("sbuffer_t sample: %s\n", s_buffer_cstr(sbuf));
 * s_buffer_free(sbuf);
 * </pre>
 */


#ifndef _SCALE_BUFFER_H_
#define _SCALE_BUFFER_H_


#include <stdarg.h>
#include "scale/commons.h"


typedef struct _sc_buffer sbuffer_t;


struct _sc_buffer {
	char *string;
	size_t memsize;
};


sbuffer_t *	s_buffer_alloc(size_t n);
sbuffer_t *	s_buffer_alloc_str(const char *src);
void		s_buffer_free(sbuffer_t *sb);
void		s_buffer_clear(sbuffer_t *sb);
size_t		s_buffer_strlen(sbuffer_t *sb);
sbuffer_t *	s_buffer_strcat(sbuffer_t *sb, const char *str);
sbuffer_t *	s_buffer_strncat(sbuffer_t *sb, const char *str, size_t n);
sbuffer_t *	s_buffer_strcpy(sbuffer_t *sb, const char *str);
sbuffer_t *	s_buffer_strncpy(sbuffer_t *sb, const char *str, size_t n);
size_t		s_buffer_sprintf(sbuffer_t *sb, const char *fmt, ...);
size_t		s_buffer_vsprintf(sbuffer_t *sb, const char *fmt, va_list);
void		s_buffer_chrrep(sbuffer_t *sb, char src, char dst);
void		s_buffer_strrep(sbuffer_t *sb, const char *src, const char *dst);
char *		s_buffer_cstr(const sbuffer_t *sb);
sint		s_buffer_strcmp(const sbuffer_t *lb, const sbuffer_t *rb);
sint		s_buffer_strncmp(const sbuffer_t *lb, const sbuffer_t *rb,
							 size_t);
void		_s_buffer_grouth(sbuffer_t *sb, size_t);



#endif /* _SCALE_BUFFER_H_ */

