/**
 * $Id: sc_alloc.c,v 1.4 2004/08/05 13:54:30 jklein Exp $
 * $Author: jklein $
 * $Log: sc_alloc.c,v $
 * Revision 1.4  2004/08/05 13:54:30  jklein
 * Fixed so that Scale can be compiled on Mac OSX(10.3 or higher).
 *
 * Revision 1.3  2004/06/21 16:44:17  jklein
 * Added iterator.
 *
 */


#include <stdio.h>
#include "scale/alloc.h"


static size_t total_memory = 0;


#if MEMORY_DEBUG == 1
#  define DBG_MEMORY_ALLOC(n) do {\
	total_memory += n;\
	printf("Used Memory(alloc): %d\n", total_memory);\
}while(0)

#  define DBG_MEMORY_FREE(n) do {\
	total_memory -= n;\
	printf("Used Memory(free) : %d\n", total_memory);\
}
#elif MEMORY_DEBUG == 2
static size_t total_memory = 0;
#  define DBG_MEMORY_ALLOC(n) do { total_memory += n; } while(0)
#  define DBG_MEMORY_FREE(n)  do { total_memory -= n; } while(0)
#else
#  define DBG_MEMORY_ALLOC(n)
#  define DBG_MEMORY_FREE(n)
#endif


#define _DEF_EXIT_CODE 1




sboolean _exit_err_handler(void);
static merror_handler errhandler = _exit_err_handler;


size_t
get_total_memory(void)
{
	return total_memory;
}


sboolean
_exit_err_handler(void) 
{
	fprintf(stderr, "error: no more memory\n");
	exit(_DEF_EXIT_CODE);
	return true; /* I know this is useless.
					But I hate to seeing worning while compile. */
}


void
s_merror_handler(merror_handler handler)
{
	if (handler)
		errhandler = handler;
	else
		errhandler = _exit_err_handler;
}


spointer 
s_malloc(size_t size)
{
	spointer p;

	if (size < 1)
		size = 1;
	
	if ((p = malloc(size)) == NULL) {
		if ((*errhandler)())
			p = s_malloc(size);
		else
			exit(_DEF_EXIT_CODE);
	}

	DBG_MEMORY_ALLOC(size);

	return p;
}


spointer 
s_calloc(size_t nmemb, size_t size)
{
	spointer p;

	if (size < 1)
		size = 1;
	
	if ((p = calloc(nmemb, size)) == NULL) {
		if ((*errhandler)())
			p = s_calloc(nmemb, size);
		else
			exit(_DEF_EXIT_CODE);
	}

	DBG_MEMORY_ALLOC(size * nmemb);

	return p;
}



spointer 
s_realloc(spointer p, size_t size)
{
	return s_reallocn(p, 0, size);
}


spointer
s_reallocn(spointer p, size_t oldsize, size_t newsize)
{
	spointer newp;

	if (newsize < 1)
		newsize = 1;

	if ((newp = realloc(p, newsize)) == NULL) {
		if ((*errhandler)())
			newp = s_realloc(p, newsize);
		else
			exit(_DEF_EXIT_CODE);
	}

	DBG_MEMORY_ALLOC(newsize);
	DBG_MEMORY_FREE(oldsize);

	return newp;
}


spointer
s_creallocn(spointer p, size_t oldsize, size_t newsize)
{
	spointer newp;

	newp = s_reallocn(p, oldsize, newsize);
	if (oldsize < newsize) {
		char *tp = (char *)newp;
		tp += oldsize;
		memset(tp, 0x00, newsize - oldsize);
	}
	
	return newp;
}


void
s_free(spointer p)
{
	if (p == NULL)
		return;
	free(p);
}


void
s_freen(spointer p, size_t n)
{
	if (p == NULL)
		return;
	memset(p, '\0', n);
	free(p);

	DBG_MEMORY_FREE(n);
}


void
s_cfreen(spointer p, size_t n)
{
	memset(p, 0x00, n);
	s_freen(p, n);
}
