/*
 * $Id: buffer.h,v 1.9 2004/09/04 07:08:01 jklein Exp $
 * $Author: jklein $
 * $Log: buffer.h,v $
 * Revision 1.9  2004/09/04 07:08:01  jklein
 * fixed "const spointer" to "sconstpointer".
 *
 * Revision 1.8  2004/08/08 07:14:45  jklein
 * Added 'resize()' function to array objects.
 *
 * Revision 1.7  2004/08/05 13:54:30  jklein
 * Fixed so that Scale can be compiled on Mac OSX(10.3 or higher).
 *
 * Revision 1.6  2004/06/28 09:51:09  jklein
 * interface was changed in scale/iterator.h
 *
 * Revision 1.5  2004/06/27 13:35:17  jklein
 * Added few functions for sbuffer_t and few macros for sxarray_t.
 *
 * Revision 1.4  2004/06/26 06:58:13  jklein
 * small fix in each header files.
 *
 * Revision 1.3  2004/06/24 15:16:50  jklein
 * sxarray_t was added for abstruction of collection structure.
 *
 * Revision 1.2  2004/06/21 16:44:17  jklein
 * Added iterator.
 *
 */

/**
 * $BJ8;zNs%P%C%U%!$rI=$9(Bsbuffer_t$B9=B$BN$N0lO"$NA`:n4X?t$rDs6!$9$k!#(B
 * $BJ8;zNs$N?-$S=L$_$r<+F0E*$K4IM}$9$k$N$G!"MQ0U$5$l$?4X?t$rDL$7$F(B
 * $BA`:n$9$kJ,$K$O%P%C%U%!!&%*!<%P!<%U%m!<Ey$NLdBj$r2sHr$G$-$k!#(B
 * $B8z2LE*$K%a%b%j<~JU$NLdBj$r2sHr$9$k$?$a$K(Bsbuffer_t->string$B$KBP$7(B
 * $B$FD>@\=q$-$3$`$h$&$J$3$H$OHr$1$k$Y$-$@$,!"FI$_<h$j$K4X$7$F$O$3$N(B
 * $B8B$j$G$O$J$$!#0J2<!"%5%s%W%k(B
 *
 * <pre>
 * sbuffer_t *sbuf = s_buffer_alloc(10);
 * s_buffer_strcpy(sbuf, "Hoge");
 * s_buffer_strcat(sbuf, "Foo");
 * printf("sbuffer_t sample: %s\n", s_buffer_cstr(sbuf));
 * s_buffer_free(sbuf);
 * </pre>
 */


#ifndef _SCALE_BUFFER_H_
#define _SCALE_BUFFER_H_


#include <stdarg.h>
#include <scale/commons.h>


typedef struct _sc_buffer sbuffer_t;


struct _sc_buffer {
	char *string;
	size_t memsize;
};


/** sbuf$B$N(Bindex$BHVL\$NJ8;z$rJV$7$^$9!#(B */
#define s_buffer_charat(sbuf, index) ((sbuf)->string[index])

/** $B%G%U%)%k%H$N=i4|%5%$%:$r;}$D(Bsbuffer_t$B$r9=C[$7$^$9!#(B */
sbuffer_t *	s_buffer_alloc(void);

/** $B=i4|%5%$%:(Bn$B$N(Bsbuffer_t$B$r9=C[$7$^$9!#(B */
sbuffer_t *	s_buffer_allocn(size_t n);

/** $BJ8;zNs(Bstr$B$rJ];}$9$k(Bsbuffer_t$B$r9=C[$7$^$9!#(B */
sbuffer_t *	s_buffer_alloc_str(const char *src);

/** sbuffer_t$B$r2rJ|$7$^$9!#(B */
void		s_buffer_free(sbuffer_t *sb);

/** $BJ8;zNs$r=i4|2=$7$^$9!#(B */
void		s_buffer_clear(sbuffer_t *sb);

/** $B8=:_J];}$9$kJ8;zNsJ,$r;D$7$F!"%a%b%j$r2rJ|$7$^$9!#(B */
void		s_buffer_resize(sbuffer_t *sb);

/** $BJ];}$9$kJ8;zNs$ND9$5$rJV$7$^$9!#(B */ 
size_t		s_buffer_strlen(sbuffer_t *sb);

/** sb$B$N:G8e$N(BNULL$BJ8;z$r>e=q$-$7$F!"(Bstr$B$rO"7k$7$^$9!#(B */
sbuffer_t *	s_buffer_strcat(sbuffer_t *sb, const char *str);

/** str$B$N:G=i$N(Bn$B;z$r(Bsb$B$KO"7k$7$^$9!#(B */
sbuffer_t *	s_buffer_strncat(sbuffer_t *sb, const char *str, size_t n);

/** str$B$r(Bsb$B$K%3%T!<$7$^$9!#(B */
sbuffer_t *	s_buffer_strcpy(sbuffer_t *sb, const char *str);

/** str$B$N:G=i$N(Bn$B;z$r(Bsb$B$K%3%T!<$7$^$9!#(B */
sbuffer_t *	s_buffer_strncpy(sbuffer_t *sb, const char *str, size_t n);

/** fmt$B$K=>$C$FJ8;zNs$r@8@.$7!"(Bsb$B$K3JG<$7$^$9!#(B */
size_t		s_buffer_sprintf(sbuffer_t *sb, const char *fmt, ...);

/** s_buffer_sprintf()$B$HF1$8$G$9$,!"0z?t$r(Bva_list$B$G<u$1<h$j$^$9!#(B */
size_t		s_buffer_vsprintf(sbuffer_t *sb, const char *fmt, va_list);

/** sb$BFb$NA4$F$N(Bsrc$B$r(Bdst$B$KCV$-49$($^$9!#(B */
void		s_buffer_chrrep(sbuffer_t *sb, char src, char dst);

/** sb$BFb$NA4$F$N(Bsrc$B$r(Bdst$B$KCV$-49$($^$9!#(B */
void		s_buffer_strrep(sbuffer_t *sb, const char *src, const char *dst);

/** C$B$G$NJ8;zNsI=8=7A<0$G(Bsb$B$NCfL#$rJV$7$^$9!#(B */
char *		s_buffer_cstr(const sbuffer_t *sb);

/** sbuffer_t$BF1;N$rHf3S$7$^$9!#(B */
sint		s_buffer_strcmp(const sbuffer_t *lb, const sbuffer_t *rb);

/** sbuffer_t$BF1;N$N:G=i$N(Bn$B;z$rHf3S$7$^$9!#(B */
sint		s_buffer_strncmp(const sbuffer_t *lb, const sbuffer_t *rb,
							 size_t n);

/** sb$B$N%a%b%jNN0h$r(Bn$B$K3HD%$7$^$9!#(B */
void		_s_buffer_grouth(sbuffer_t *sb, size_t n);



#endif /* _SCALE_BUFFER_H_ */

