/**
 * $Id$
 * $Author$
 * $Log$
 */

#include <stdio.h>
#include <stdarg.h>
#include <time.h>
#include "scale/commons.h"
#include "scale/stack.h"
#include "scale/buffer.h"
#include "scale/alloc.h"


/* ΥץϰտŪ˥ƥΥƳݤޤ
   Υץư桢¾ΥեȥˤƶФ뤫ΤʤΤǡ
   ȤǤˤĶǡȤǤǼ¹ԤƤ

   ɤˤ衢ƥȥɤʤΤǼ¹ԤɬפϤޤ
   ScaleγȯԸΥɤǤ

   J-Klein <j-klein@members.jcom.home.ne.jp>
*/


#define MEMBLOCK_SIZE (8192 * 100)


/* ݤݻ */
static sstack_t *memstack;
static suint32 total_mem_size = 0;
static suint merror_counter = 0;
static sboolean exit_flag = false;


sboolean
test_merror_handler(void)
{
	spointer p = s_stack_pop(memstack);


	printf("merror_handler: total memory allocated is %u byte\n",
		   total_mem_size);

	if (p != NULL) {
		printf("merror_handler: going to free the %u byte of memory\n",
			   MEMBLOCK_SIZE);
		s_freen(p, MEMBLOCK_SIZE);
		total_mem_size -= MEMBLOCK_SIZE;
		merror_counter++;

		
		if (++merror_counter >= 101) {
			printf("merror_handler: handler called %u times.\n",
				   merror_counter);
			exit_flag = true;
		}
		return true;
	}
	else {
		printf("merror_handler: no more memory to free\n");
		return false;
	}
}


int
main(int argc, char *argv[])
{
	spointer p;
	double stime, etime;

	/* ꥨ顼ϥɥ򥻥åȤ */
	s_merror_handler(test_merror_handler);

	memstack = s_stack_alloc();
	stime = clock();
	while (1) {
		if ( (p = s_malloc(MEMBLOCK_SIZE)) == NULL) {
			printf("Error: memory error handler is not doing good\n");
			exit(1);
		}
		
		s_stack_push(memstack, p);
		total_mem_size += MEMBLOCK_SIZE;

		if (total_mem_size % (MEMBLOCK_SIZE*50) == 0) {
			etime = clock();
			printf("Allocated %u byte in %.3f sec.\n", total_mem_size,
				(etime-stime)/CLOCKS_PER_SEC);
			stime = clock();
		}

		if (exit_flag)
			break;
	}

	printf("Test done.\n");
	printf("Trying to free the memory.\n");

	while (s_stack_size(memstack) != 0) {
		s_freen(s_stack_pop(memstack), MEMBLOCK_SIZE);
	}

	return 1;
}
