

#include <stdio.h>
#include <stdarg.h>

#include "scale/buffer.h"
#include "scale/alloc.h"


#if ! defined va_copy && defined __va_copy
#  define va_copy(s,d) __va_copy((s),(d))
#endif

#define DEF_INITSIZE 128
#define DEF_GROUTH_RATE 2


void
_s_buffer_grouth(sbuffer_t *sbuf, size_t newsize)
{
	if(newsize <= sbuf->memsize)
		return;

	sbuf->string = s_reallocn(sbuf->string, sbuf->memsize, newsize);
	sbuf->memsize = newsize;
}


sbuffer_t *
s_buffer_alloc(size_t initsize)
{
	sbuffer_t *sbuf;

	if(initsize == 0)
		initsize = DEF_INITSIZE;
	
	sbuf = s_malloc(sizeof(sbuffer_t));
	sbuf->memsize = initsize;
	sbuf->string = s_calloc(sbuf->memsize, sizeof(char));

	return sbuf;
}


void
s_buffer_free(sbuffer_t *sbuf)
{
	s_buffer_clear(sbuf);

	s_freen(sbuf->string, sbuf->memsize);
	s_freen(sbuf, sizeof(sbuffer_t));
}


void
s_buffer_clear(sbuffer_t *sbuf)
{
	memset(sbuf->string, '\0', sbuf->memsize);
}


size_t
s_buffer_strlen(sbuffer_t *sbuf)
{
	return strlen(sbuf->string);
}


sbuffer_t *
s_buffer_strcat(sbuffer_t *sbuf, const char *src)
{
	return s_buffer_strncat(sbuf, src, strlen(src));
}


sbuffer_t *
s_buffer_strncat(sbuffer_t *sbuf, const char *src, size_t n)
{
	size_t buflen = strlen(sbuf->string);
	size_t newlen = n + buflen + 1;
	
	if (n == 0)
		return sbuf;
	
	if (newlen > sbuf->memsize)
		_s_buffer_grouth(sbuf, newlen);

	strncat(sbuf->string, src, n);

	sbuf->string[newlen] = '\0';
	return sbuf;
}


sbuffer_t *
s_buffer_strcpy(sbuffer_t *sbuf, const char *src)
{
	return s_buffer_strncpy(sbuf, src, strlen(src));
}


sbuffer_t *
s_buffer_strncpy(sbuffer_t *sbuf, const char *src, size_t n)
{
	if (n == 0)
		return sbuf;

	if (n + 1 > sbuf->memsize)
		_s_buffer_grouth(sbuf, n + 1);

	memset(sbuf->string, '\0', sbuf->memsize);
	strncpy(sbuf->string, src, n);
	
	return sbuf;
}


size_t
s_buffer_sprintf(sbuffer_t *sbuf, const char *fmt, ...)
{
	va_list ap;
	sint ret;

	va_start(ap, fmt);
	ret = s_buffer_vsprintf(sbuf, fmt, ap);
	va_end(ap);

	return ret;
}


size_t
s_buffer_vsprintf(sbuffer_t *sbuf, const char *fmt, va_list ap)
{
	va_list dupap;
	size_t newlen;

	/* allocate new memoty if we need it. */
	va_copy(dupap, ap);
	newlen = vsnprintf(NULL, 0, fmt, dupap);
	va_end(dupap);

	if(sbuf->memsize < newlen + 1)
		_s_buffer_grouth(sbuf, newlen + 1);
	
	vsprintf(sbuf->string, fmt, ap);
	return newlen;
}


sint
s_buffer_strcmp(const sbuffer_t *lbuf, const sbuffer_t *rbuf)
{
	return strcmp(lbuf->string, rbuf->string);
}


sint
s_buffer_strncmp(const sbuffer_t *lbuf, const sbuffer_t *rbuf, size_t n)
{
	return strncmp(lbuf->string, rbuf->string, n);
}
