

#include "scale/alloc.h"
#include "scale/vector.h"


#define DEF_VECTOR_SIZE 64
#define DEF_GROUTH_RATIO 32


void
_s_vector_grouth(svector_t *vect, size_t tsize)
{
	if (vect->memsize >= tsize)
		return; /* nothiong to do. */

	vect->array = (spointer *)s_reallocn(vect->array,
										 vect->memsize,
										 sizeof(spointer)*tsize);
	vect->memsize = tsize;
}



svector_t *
s_vector_alloc()
{
	return s_vector_allocn(DEF_VECTOR_SIZE);
}


svector_t *		
s_vector_allocn(size_t n) 
{
	svector_t *vect;

	vect = (svector_t *)s_malloc(sizeof(svector_t));
	vect->count = 0;
	vect->memsize = 0;
	vect->nextidx = 0;
	vect->array = NULL;

	_s_vector_grouth(vect, n);

	return vect;
}


void			
s_vector_free(svector_t *vect) 
{
	s_freen(vect->array, sizeof(spointer) * vect->memsize);
	s_freen(vect, sizeof(svector_t));
}


size_t
s_vector_size(svector_t *vect)
{
	return vect->count;
}


void
s_vector_add(svector_t *vect, const spointer contents) 
{
	if (vect->memsize == vect->nextidx)
		_s_vector_grouth(vect, vect->memsize + DEF_GROUTH_RATIO);

	vect->array[vect->nextidx++] = contents;
	++vect->count;
}


spointer		
s_vector_get(svector_t *vect, size_t idx) 
{
	if (vect->count <= idx)
		return NULL;

	return vect->array[idx];
}


spointer		
s_vector_remove(svector_t *vect, size_t idx) 
{
	spointer contents;
	sint i;

	if (vect->count <= idx)
		return NULL;

	contents = vect->array[idx];
	vect->array[idx] = NULL;

	/* need to slide all contents after 'idx'. */
	for (i=idx; i<vect->count-1; i++) {
		vect->array[i] = vect->array[i+1];
	}
	vect->array[vect->count-1] = NULL;
	--vect->count;
	--vect->nextidx;
	
	return contents;
}


sint32			
s_vector_find(svector_t *vect, sc_compf_t compare, spointer contents) 
{
	sint i;

	for (i=0; i<vect->count; i++) {
		if (compare(vect->array[i], contents) == 0)
			return i;
	}
	return -1;
}


sboolean		
s_vector_join(svector_t *dst, svector_t *src) 
{
	size_t newsize;
	sint i;

	newsize = dst->count + src->count;

	if (dst->memsize < newsize)
		_s_vector_grouth(dst, newsize);

	for (i=0; i<src->count; i++) {
		dst->array[dst->nextidx] = src->array[i];
		++dst->nextidx;
	}

	dst->count += src->count;

	return true;
}
