/**
 * $Id: commons.h,v 1.2 2004/06/22 12:23:39 jklein Exp $
 * $Author: jklein $
 * $Log: commons.h,v $
 * Revision 1.2  2004/06/22 12:23:39  jklein
 * correcting mistakes.
 *
 * Revision 1.1  2004/06/21 11:28:00  jklein
 * Changed source tree.
 *
 * Revision 1.1.1.1  2004/06/21 09:29:33  jklein
 * import scale
 *
 */

#ifndef _SC_COMMONS_H_
#define _SC_COMMONS_H_

#include "scale/config.h"
#include <stdlib.h>


#if HAVE_STRING_H
#  include <string.h>
#else
#  include <strings.h>
#endif


/* all of primitive types for SC libraries. */
typedef void * spointer;

#if HAVE_STDBOOL_H
enum {
	false = 0,
	true = 1
};

typedef bool sboolean
#else
typedef enum {
	false = 0,
	true = 1
} sboolean;
#endif


#if ! HAVE_STDINT_H

typedef signed char	int8_t;
typedef short int   int16_t;
typedef int         int32_t;

typedef unsigned char      uint8_t;
typedef unsigned short int uint16_t;
typedef unsigned int       uint32_t;

#else
#  include <stdint.h>
#endif

typedef int		sint;
typedef int8_t  sint8;
typedef int16_t sint16;
typedef int32_t sint32;

typedef unsigned int	suint;
typedef uint8_t			suint8;
typedef uint16_t		suint16;
typedef uint32_t		suint32;

typedef char			schar;
typedef unsigned char	suchar;

typedef short			sshort;
typedef unsigned short	sushort;

typedef long			slong;
typedef unsigned		sulong;

typedef float	sfloat;
typedef double  sdouble;


/* compare function for all SC libraries.
 * returns
 *  1 : v1 >  v2
 *  0 : v1 == v2
 * -1 : v1  < v2
 */
typedef sint8 (*sc_compf_t)(const spointer, const spointer);


sint8 s_string_compare(const spointer, const spointer);
sint8 s_string_rcompare(const spointer, const spointer);
sint8 s_pointer_compare(const spointer, const spointer);

#endif /* _SC_COMMONS_H_ */
