/**
 * $Id: sc_vector.c,v 1.3 2004/06/21 16:44:17 jklein Exp $
 * $Author: jklein $
 * $Log: sc_vector.c,v $
 * Revision 1.3  2004/06/21 16:44:17  jklein
 * Added iterator.
 *
 */


#include "scale/alloc.h"
#include "scale/vector.h"


#define DEF_VECTOR_SIZE 64
#define DEF_GROUTH_RATIO 32


void
_s_vector_grouth(svector_t *vect, size_t tsize)
{
	if (vect->memsize >= tsize)
		return; /* nothiong to do. */

	vect->array = (spointer *)s_reallocn(vect->array,
										 vect->memsize,
										 sizeof(spointer)*tsize);
	vect->memsize = tsize;
}



svector_t *
s_vector_alloc(void)
{
	return s_vector_allocn(DEF_VECTOR_SIZE);
}


svector_t *		
s_vector_allocn(size_t n) 
{
	svector_t *vect;

	vect = (svector_t *)s_malloc(sizeof(svector_t));
	vect->count = 0;
	vect->memsize = 0;
	vect->nextidx = 0;
	vect->array = NULL;

	_s_vector_grouth(vect, n);

	return vect;
}


void			
s_vector_free(svector_t *vect) 
{
	s_freen(vect->array, sizeof(spointer) * vect->memsize);
	s_freen(vect, sizeof(svector_t));
}


size_t
s_vector_size(svector_t *vect)
{
	return vect->count;
}


void
s_vector_add(svector_t *vect, const spointer contents) 
{
	if (vect->memsize == vect->nextidx)
		_s_vector_grouth(vect, vect->memsize + DEF_GROUTH_RATIO);

	vect->array[vect->nextidx++] = contents;
	++vect->count;
}


spointer		
s_vector_get(svector_t *vect, size_t idx) 
{
	if (vect->count <= idx)
		return NULL;

	return vect->array[idx];
}


spointer		
s_vector_remove(svector_t *vect, size_t idx) 
{
	spointer contents;
	sint i;

	if (vect->count <= idx)
		return NULL;

	contents = vect->array[idx];
	vect->array[idx] = NULL;

	/* need to slide all contents after 'idx'. */
	for (i=idx; i<vect->count-1; i++) {
		vect->array[i] = vect->array[i+1];
	}
	vect->array[vect->count-1] = NULL;
	--vect->count;
	--vect->nextidx;
	
	return contents;
}


sint32			
s_vector_find(svector_t *vect, sc_compf_t compare, spointer contents) 
{
	sint i;

	for (i=0; i<vect->count; i++) {
		if (compare(vect->array[i], contents) == 0)
			return i;
	}
	return -1;
}


sboolean		
s_vector_join(svector_t *dst, svector_t *src) 
{
	size_t newsize;
	sint i;

	newsize = dst->count + src->count;

	if (dst->memsize < newsize)
		_s_vector_grouth(dst, newsize);

	for (i=0; i<src->count; i++) {
		dst->array[dst->nextidx] = src->array[i];
		++dst->nextidx;
	}

	dst->count += src->count;

	return true;
}



/* for iterator */

typedef struct {
	size_t next_index;
} vector_itr_manager_t;


static spointer
_s_vector_iterator_next(siterator_t *itr)
{
	vector_itr_manager_t *mng = (vector_itr_manager_t *)itr->data;
	svector_t *vect = (svector_t *)itr->listdata;

	if (s_vector_size(vect) == mng->next_index)
		return NULL;

	return vect->array[mng->next_index++];
}


static void
_s_vector_iterator_clear(siterator_t *itr)
{
	vector_itr_manager_t *mng = (vector_itr_manager_t *)itr->data;
	mng->next_index = 0;
}


static void
_s_vector_iterator_free(siterator_t *itr)
{
	s_freen(itr->data, sizeof(vector_itr_manager_t));
	s_freen(itr, sizeof(siterator_t));
}


siterator_t *
s_vector_iterator(svector_t *vect)
{
	siterator_t *itr;

	itr = (siterator_t *)s_malloc(sizeof(siterator_t));
	itr->listdata = vect;
	itr->next = _s_vector_iterator_next;
	itr->clear = _s_vector_iterator_clear;
	itr->free = _s_vector_iterator_free;
	
	itr->data = (vector_itr_manager_t *)
		s_malloc(sizeof(vector_itr_manager_t));

	itr->clear(itr);

	return itr;
}
