package DynamicHTTP;

use strict;
use warnings;
use Carp;

use IPC::Open3;

sub new(%){
  shift;
  if(!&cannotUseWget){
    use DynamicHTTP::Wget;
    return new DynamicHTTP::Wget(@_);
  }elsif(!&cannotUseCurl){
    use DynamicHTTP::Curl;
    return new DynamicHTTP::Curl(@_);
  }elsif(!&cannotUseLWP_UserAgent){
    use DynamicHTTP::LWP_UserAgent;
    return new DynamicHTTP::LWP_UserAgent(@_);
  }
}

sub cannotUseWget{
  return `./which wget` eq '';
}
sub cannotUseCurl{
  return `./which curl` eq '';
}
sub cannotUseLWP_UserAgent{
  eval{require LWP::UserAgent;};
  return $@;
}

1;
