package Module::SubModuleList;

use strict;
use warnings;
use Carp;
use vars qw|@INC|;

use IO::Dir;

sub findInside($){
  my $sTarget = shift;
  my @asTargetPath = split(m|::|,$sTarget);
  my $sPath = join('/',@asTargetPath).'/';
  my @asResult = ();
  my @asINCEx = @INC;
  foreach my $sDirPath(grep{-e $_}map{$_ = "$_/$sPath"}@asINCEx){
    print STDERR "Module::SubModuleList : ITERATING $sDirPath\n";
    my $oDir = new IO::Dir($sDirPath);
    if(defined $oDir){
      while(defined($_ = $oDir->read)){
	 next if !defined $_ or substr($_,0,1) eq '.' or $_ eq '';
	 my $sFilePath = $sDirPath.'/'.$_;
	 next if -z $sFilePath;
	 next if !-T $sFilePath;
	 print STDERR "Module::SubModuleList : FOUND $sFilePath\n";
	 $_ = substr($_,0,length($_)-3);
	 my @asPath = split(m|/|,$_);
	 push(@asResult,$sTarget.'::'.join('::',@asPath));
      }
    }
  }
  return @asResult;
}
sub findAndDo($$$@){
  my $sTarget = shift;
  my $sSubroutineName = shift;
  my $rxSubroutineEnvs = shift;
  my @axSubroutineEnvs = @$rxSubroutineEnvs;
  my @asModules = &findInside($sTarget);
  foreach(@asModules){
    eval "require $_";
    if(!$@){
      $_ = $_->new(@_);
      no strict 'refs';
      $_->$sSubroutineName(@axSubroutineEnvs);
    }else{
      print STDERR $@;
    }
  }
}

1;
