package Section::GlobalFormat::1;
@ISA = qw|Section::base|;

use Section::base;

sub new{
    shift;
    return bless Section::base->new(@_);
}
sub out($){
    my $oS = shift;
    my $oChangeable = shift;
    my %hE = @_;
    my $nRevisionNum = $hE{revnum} || 0;
    my $sID = $hE{id} || '';
    @hE{qw|title subtitle summary reloadinterval|} = (
						      $oChangeable->title,
						      $oChangeable->subtitle,
						      $oChangeable->summary,
						      $oChangeable->reloadinterval,
					      );
    if(defined $oChangeable->content and !$oChangeable->content->isEmpty){
      $hE{content} = $oChangeable->content->HTML;
    }
    my $sRes = '';
    foreach(qw|title subtitle summary content|){
        $hE{$_} = $oS->oOut->encoded($hE{$_});
    }
    foreach(qw|begin end|){
	$hE{q|time_|.$_} = '-' if !defined $hE{q|time_|.$_};
    }
    $hE{summary} =~ s|\n|<br />|g;
    my $sIDRev = $sID.'_'.$nRevisionNum;
    $sRes = '<div id="'.$sIDRev.'" name="'.$sIDRev.'"><table class="globalformat_1"><tbody><tr><th>'
      .$oS->oOut->encoded($oS->oLng->get('TITLE'))
	.'</th><td colspan="3"><strong>'.$hE{title}.'</strong></td></tr>';
    $sRes .= '<tr><th>'.$oS->oOut->encoded($oS->oLng->get('SUBTITLE')).'</th><td colspan="3">'.$hE{subtitle}.'</td></tr>' if $hE{subtitle} ne '';
    $sRes .= '<tr><th>'.$oS->oOut->encoded($oS->oLng->get('TIME_BEGIN')).'</th><td>'.$oS->timeDisp($oChangeable->time->begin).'</td><th>'
      .$oS->oOut->encoded($oS->oLng->get('TIME_END')).'</th><td>'.$oS->timeDisp($oChangeable->time->end).'</td></tr>'
      if defined $oChangeable->time->begin or defined $oChangeable->time->end;
    $sRes .= '<tr><th>'.$oS->oOut->encoded($oS->oLng->get('SUMMARY')).'</th><td colspan="3">'.$hE{summary}.'</td></tr>' if $hE{summary} ne '';
    $sRes .= '<tr><th>'.$oS->oOut->encoded($oS->oLng->get('CONTENT')).'</th><td colspan="3">'.$hE{content}.'</td></tr>' if defined $hE{content};
    $sRes .= '<tr><th>'.$oS->oOut->encoded($oS->oLng->get('RELOADINTERVAL')).'</th><td colspan="3">'.$hE{reloadinterval}.$oS->getEncLng('TIME_SECOND').'</td></tr>';
    foreach(@{$oChangeable->locations}){
      if($_->type eq 'name'){
	my $sR = $oS->oOut->encoded($_->name);
	$sRes .= '<tr><th>'.$oS->oOut->encoded($oS->oLng->get('LOCATION')).'</th><td colspan="3"><p>'.$sR.'</p></td></tr>';
      }elsif($_->type eq 'gpx'){
	my $sR = $oS->oOut->encoded($_->name);
	$sRes .= '<tr><th>'.$oS->oOut->encoded($oS->oLng->get('LOCATION')).'</th><td colspan="3"><p>'.$sR;
	my $nLat = $_->TOKYO97lat;
	my $nLon = $_->TOKYO97lon;
	my @anMinSecLat = $oS->minSecFromNumber($nLat);
	my @anMinSecLon = $oS->minSecFromNumber($nLon);
	$sRes .= '<ul>';
	$sRes .= '<li><a href="http://maps.google.co.jp/maps?spn=0.01,0.01&ll='.$_->lat.','.$_->lon.'">[Google Maps]</a></li>';
	$sRes .= '<li><a href="http://www.mapion.co.jp/c/f?uc=1&scl=70000&grp=all&nl='.join('/',@anMinSecLat).'&el='.join('/',@anMinSecLon).'">[Mapion MAP]</a></li>';
	$sRes .= '<li><a href="http://map.yahoo.co.jp/beta/?lat='.join('.',@anMinSecLat).';lon='.join('.',@anMinSecLon).';sc=2;mode=map">[Yahoo MAP]</a></li>';
	$sRes .= '<li><a href="http://map.goo.ne.jp/map.php?ZM=9&MAP=E'.join('.',@anMinSecLat).'N'.join('.',@anMinSecLon).'">[Goo MAP]</a></li>';
	$sRes .= '</ul>';
	$sRes .= '<p><a href="./index.cgi?mode=locationlib&locationlib=registNewLocationHTML&name='.$sR.'&lat='.$_->lat.'&lon='.$_->lon.'">['.$oS->getEncLng('GLOBALFORMAT1_ADD_THIS_LOCATION_TO_LOCATIONLIB').']</a></p>'
	  if $oS->oLgi->isLoggedIn && !$oS->oLDat->findIfThisLocationExists($_);
	$sRes .= '</p></td></tr>';
      }
    }
    $sRes .= '</tbody></table></div>';
    return $sRes;
  }
sub minSecFromNumber($){
  shift;
  my $nT = shift;
  my $nDeg = int($nT);
  $nT = ($nT-$nDeg)*60;
  my $nMinute = int($nT);
  $nT = sprintf("%.3f",($nT-$nMinute)*60);
  return ($nDeg,$nMinute,$nT);
}

1;
