package Section::LocationLib;
@ISA = qw|Section::base|;

use strict;
use warnings;
use Carp;

use Section::base;
use Scheduler::Schema::LocationComplex;
use Scheduler::Parser::LocationComplex;

sub new{
  shift;
  return bless Section::base->new(@_);
}
sub out{
  my $oS = shift;
  $oS->oOut->setSubtitle('LocationLib');
  my $sStat = $oS->oCGI->param('locationlib');
  if(!defined $sStat){
    $oS->outDisp;
  }elsif($sStat eq 'wholeListRequest'){
    $oS->outWholeListRequest;
  }elsif($sStat eq 'registNewLocation'){
    $oS->outRegistNewLocation;
  }elsif($sStat eq 'removeLocation'){
    $oS->outRemoveLocation;
  }elsif($sStat eq 'registNewLocationHTML'){
    $oS->outRegistNewLocationHTML;
  }
}
sub outDisp{
  my $oS = shift;
  $oS->setHistoryStack('locationlib');
  my $sRes = $oS->oOut->sectionBegin('LOCATIONLIB','locationlib');
  my $sHeader = '<script src="http://maps.google.com/maps?file=api&amp;v=2&amp;key='.$oS->oEnv->googleMapID.'" type="text/javascript"></script><script type="text/javascript">
//<![CDATA[
';
  $sHeader .= $_ while <DATA>;
  $sHeader .= '//]]></script>';
  $oS->oOut->addHeaderEx($sHeader);undef $sHeader;
  $oS->oOut->isUsingPrototypeJS;
  $oS->oOut->isUsingEscapeCodecLibrary;
  $oS->oOut->setBodyTagAttribute('onload','load()');
  $oS->oOut->setBodyTagAttribute('onunload','GUnload()');
  print $oS->oOut->httpHeader;
  print $oS->oOut->htmlHeader;
  $sRes .=<< 'EOF';
<div id="div_map"></div>
<div id="div_select_list"><select><option value="test">loading...</option></select></div>
EOF
  $sRes .= '<input type="button" onclick="generateNewLocation();" value="'.$oS->getEncLng('LOCATION_GENERATE_NEW_LOCATION').'" />';
  print $sRes.$oS->getEncLng('LOCATION_HOW_TO_USE').$oS->oOut->sectionEnd;
  print $oS->oOut->htmlFooter;
}
sub outWholeListRequest{
  my $oS = shift;
  my $sRes = $oS->oCGI->header(
			       -type=>'application/xml',
			       -expires=>'+0d',
			       -charset=>$oS->oOut->sEncoding,
			      );
  my @asList = $oS->oLDat->getLList;
  my $oLComplex = new Scheduler::Schema::LocationComplex;
  foreach(@asList){
    my $oLocation = $oS->oLDat->getLByHash($_);
    $oLComplex->addGpxs($_,$oLocation);
  }
  my $sComplex = Scheduler::Parser::LocationComplex->docstringFromObj($oLComplex);
  print $sRes.$sComplex;
}
sub outRegistNewLocation{
  my $oS = shift;
  my $oGPX = new Scheduler::Schema::LocationGPX;
  $oGPX->setLat($oS->oCGI->param('lat'));
  $oGPX->setLon($oS->oCGI->param('lon'));
  $oGPX->setName($oS->oOut->decoded($oS->oCGI->param('name')));
  my $sID = $oS->oCGI->param('id');
  undef $sID if $sID eq '';
  $sID = $oS->oLDat->setL($oGPX,$sID);
  my $sRes = $oS->oCGI->header(
			       -type=>'text/plain',
			       -expires=>'+0d',
			       -charset=>$oS->oOut->sEncoding,
			      );
  print $sRes."LOCATION $sRes is set as ID = ".$sID;
}
sub outRemoveLocation{
  my $oS = shift;
  my $sID = $oS->oCGI->param('id');
  if(defined $sID){
    $sID = $oS->oLDat->delL($sID);
  }
  my $sRes = $oS->oCGI->header(
			       -type=>'text/plain',
			       -expires=>'+0d',
			       -charset=>$oS->oOut->sEncoding,
			      );
  print $sRes.'REMOVED '.$sID;
}
sub outRegistNewLocationHTML{
  my $oS = shift;
  my $sName = $oS->oOut->decoded($oS->oCGI->param('name'));
  my $nLat = $oS->oCGI->param('lat');
  my $nLon = $oS->oCGI->param('lon');
  my $oGPX = new Scheduler::Schema::LocationGPX;
  $oGPX->setLat($nLat);
  $oGPX->setLon($nLon);
  $oGPX->setName($sName);
  my $sID = $oS->oLDat->setL($oGPX);
  print $oS->oOut->httpHeader
    .$oS->oOut->htmlHeader
      .$oS->oOut->sectionBegin('LOCATIONLIB','locationlib')
	.'<p>Location was add as shown below.</p>'
	  .'<dl><dt>Name</dt><dd>'.$oS->oOut->encoded($sName).'</dd>'
	    .'<dt>Position</dt><dd>'."($nLat,$nLon)".'</dd>'
	      .'<dt>ID</dt><dd>'.$sID.'</dd></dl>'
	      .$oS->oOut->sectionEnd
		.$oS->oOut->htmlFooter;
}

1;

__DATA__
var _oMap;
var _aoLocations;
var _hoMarkers;

function load(){
  loadImages();
  loadMap();
  loadPositions();
  loadEtc();
}
function newLocation(_oGLatLng){
  return {
	  latlon : _oGLatLng,
	  name : undefined,
	  locked : true,
	  latlonhistory : new Array(),
	  id : ''
	 };
}
function loadImages(){
  _hoMarkers = {
		locked : new GIcon(G_DEFAULT_ICON),
		selected : new GIcon(G_DEFAULT_ICON)
	       };
  _hoMarkers.locked.image = "../../sche/marker/marker_locked.png"
  _hoMarkers.locked.iconSize = new GSize(25,39);
  _hoMarkers.locked.shadowSize = new GSize(35,39);
  _hoMarkers.locked.iconAnchor = new GPoint(9,39);
  _hoMarkers.locked.shadowAnchor = new GPoint(9,39);
  _hoMarkers.locked.infoWindowAnchor = new GPoint(9,7);
  _hoMarkers.locked.infoShadowAnchor = new GPoint(18,30);
  _hoMarkers.selected.image = "../../sche/marker/marker_selected_light.png"
  _hoMarkers.selected.iconSize = new GSize(30,44);
  _hoMarkers.selected.shadowSize = new GSize(35,39);
  _hoMarkers.selected.iconAnchor = new GPoint(14,39);
  _hoMarkers.selected.infoWindowAnchor = new GPoint(14,7);
  _hoMarkers.selected.infoShadowAnchor = new GPoint(23,30);
}
function loadMap(){
  _oMap = new GMap2($("div_map"));
  _oMap.addControl(new GLargeMapControl());
  _oMap.addControl(new GMapTypeControl());
_oMap.setCenter(new GLatLng(0,0),1);
}
function loadEtc(){
  var _oCenterIcon = new GIcon();
  _oCenterIcon.image = "../..//sche/marker/center.png";
  _oCenterIcon.iconSize = new GSize(16,16);
  _oCenterIcon.iconAnchor = new GPoint(8,8);
/*
  var _oCenterMarker = new GMarker(_oMap.getCenter(),{icon:_oCenterIcon});
  _oMap.addOverlay(_oCenterMarker);
  GEvent.addListener(_oMap,"move",function(){
    _oMap.clearOverLays();
    var _oCenterMarker2 = new GMarker(_oMap.getCenter(),{icon:_oCenterIcon});
    _oMap.addOverlay(_oCenterMarker2);
  });
*/
}
function loadPositions(){
  var _oAjaxRequest = new Ajax.Request('index.cgi',{
						    method : 'get',
						    parameters : 'mode=locationlib&locationlib=wholeListRequest',
						    onComplete : loadedPositions
						   });
}
function loadedPositions(oOriginalRequest){
  _aoLocations = new Array();
  var _oRoot = oOriginalRequest.responseXML.documentElement;
  var _aoMarkers = _oRoot.getElementsByTagName('gpx');
  var _oBounds = undefined;
  for(var i=0;i < _aoMarkers.length;i++){
    var _oGLatLng = new GLatLng(_aoMarkers[i].firstChild.getAttribute("lat"),_aoMarkers[i].firstChild.getAttribute("lon"));
    var _oLocation = newLocation(_oGLatLng);
    _oLocation.name = _aoMarkers[i].firstChild.firstChild.firstChild.nodeValue;
    _oLocation.id = _aoMarkers[i].getAttribute("id");
    addLocation(_oLocation);
    if(_oBounds == undefined){
      _oBounds = new GLatLngBounds(
				   _oLocation.latlon,
				   _oLocation.latlon
				  );
    }else{
      _oBounds.extend(_oLocation.latlon);
    }
  }
  _oMap.setCenter(_oBounds.getCenter(),1);
  _oMap.setZoom(_oMap.getBoundsZoomLevel(_oBounds));
  refreshSelectList();
}
function updateLocationInServer(_nLNum){
  var _sParams = '&id='+_aoLocations[_nLNum].id+'&name='+_aoLocations[_nLNum].name
    +'&lat='+_aoLocations[_nLNum].latlon.lat()+'&lon='+_aoLocations[_nLNum].latlon.lng();
  var _oAjaxRequest = new Ajax.Request('index.cgi',{
						    method : 'get',
						    parameters : 'mode=locationlib&locationlib=registNewLocation'+_sParams,
						    onComplete : updatedLocations
						   });
  refreshSelectList();
}
function removeLocationInServer(_nLNum){
  var _oAjaxRequest = new Ajax.Request('index.cgi',{
						    method : 'get',
						    parameters : 'mode=locationlib&locationlib=removeLocation&id='+_aoLocations[_nLNum].id,
						    onComplete : updatedLocations
						   });
}
function updatedLocations(oOriginalRequest){
  GLog.write(oOriginalRequest.responseText);
}
function registMarker(_nLNum,_oLocation){
  var _oOptions;
  if(_oLocation.locked){
    _oOptions = {
		 draggable : !_oLocation.locked,
		 icon : _hoMarkers.locked
		};
  }else{
    _oOptions = {
		 draggable : !_oLocation.locked
		};
  }
  removeMarker(_nLNum);
  var _oMarker = new GMarker(_oLocation.latlon,_oOptions);
  _oMap.addOverlay(_oMarker);
  _aoLocations[_nLNum].overlay = _oMarker;
  GEvent.addListener(_oMarker,"click",function(){
    _oMarker.openInfoWindowTabsHtml(generateInfoHTMLTabs(_nLNum));
  });
  if(!_oLocation.locked){
    GEvent.addListener(_oMarker,"dragstart",function(){
      _oMap.closeInfoWindow();
    });
    GEvent.addListener(_oMarker,"dragend",function(){
      _aoLocations[_nLNum].latlonhistory.unshift(_aoLocations[_nLNum].latlon);
      _aoLocations[_nLNum].latlon = _oMarker.getPoint();
      _oMarker.openInfoWindowTabsHtml(generateInfoHTMLTabs(_nLNum));
    });
  }
}
function removeMarker(_nLNum){
  if(_aoLocations[_nLNum].overlay != undefined){
    _oMap.removeOverlay(_aoLocations[_nLNum].overlay);
  }
}
function generateInfoHTMLTabs(_nLNum){
  var _sInfoTabHTMLLocked = '<h1>'+_aoLocations[_nLNum].name
    +'(#'+_nLNum+')</h1><p>'+_aoLocations[_nLNum].latlon
      +'</p><ul><li><a onclick="unlockLocation('+_nLNum
	+')">Unlock</a></li><li><a onclick="centerLocation('+_nLNum
	  +')">Center</a></li><li><a onclick="">GPX</a></li></ul>';
  var _sInfoTabHTMLUnlocked = '<h1>'+_aoLocations[_nLNum].name
    +'(#'+_nLNum+')</h1><p>'+_aoLocations[_nLNum].latlon
      +'</p><ul><li><a onclick="lockLocation('+_nLNum
	+')">Lock</a></li><li><a onclick="centerLocation('+_nLNum
	    +')">Center</a></li><li><a onclick="">GPX</a></li></ul>';
  var _sEditTab = '<h1>Edit</h1><p>NAME:<input type="text" id="n_'+_nLNum+'_edit" value="'+_aoLocations[_nLNum].name+'" /><input type="submit" value="rename" onclick="updateName('+_nLNum+');" /></p><p><input type="submit" value="Save this location to server" onclick="updateName('+_nLNum+');updateLocationInServer('+_nLNum+')"/></p><p><input type="submit" value="Remove this location from server" onclick="removeLocation('+_nLNum+');" /></p>';
  var _sLatlonHistoryTab = '<h1>History</h1><select id="n_latlonhistory_'+_nLNum+'" size="5">';
  for(var i=0;i<_aoLocations[_nLNum].latlonhistory.length;i++){
    _sLatlonHistoryTab += '<option value="'+i+'" id="'+_nLNum+'_'+i+'" onclick="showPreviousLatlon('+_nLNum+','+i+')">'+i+'</option>';
  }
  _sLatlonHistoryTab += '</select><input type="submit" value="Apply history" onclick="undoToPreviousLatlon('+_nLNum+');" />';
  if(_aoLocations[_nLNum].locked){
    return [
	    new GInfoWindowTab('Information',_sInfoTabHTMLLocked)
	   ];
  }else{
    return [
	    new GInfoWindowTab('Information',_sInfoTabHTMLUnlocked),
	    new GInfoWindowTab('Edit',_sEditTab),
	    new GInfoWindowTab('History',_sLatlonHistoryTab)
	   ];
  }
}
function generateNewLocation(){
  var _oLocation = newLocation(_oMap.getCenter());
  _oLocation.locked = false;
  addLocation(_oLocation);
  refreshSelectList();
}
function newLocationNumber(){
  return _aoLocations.length;
}
function addLocation(_oLocation){
  var _nLNum = newLocationNumber();
  _aoLocations[_nLNum] = _oLocation;
  registMarker(_nLNum,_oLocation);
}
function removeLocation(_nLNum){
  if(window.confirm("Location will be removed. Is it OK?")){
    removeLocationInServer(_nLNum);
    removeMarker(_nLNum);
    _aoLocations[_nLNum] = undefined;
    refreshSelectList();
  }
}
function lockLocation(_nLNum){
  _aoLocations[_nLNum].locked = true;
  registMarker(_nLNum,_aoLocations[_nLNum]);
}
function unlockLocation(_nLNum){
  _aoLocations[_nLNum].locked = false;
  registMarker(_nLNum,_aoLocations[_nLNum]);
}
function centerLocation(_nLNum){
  _oMap.setCenter(_aoLocations[_nLNum].latlon);
}
function updateName(_nLNum){
  _aoLocations[_nLNum].name = $('n_'+_nLNum+'_edit').value;
}
function showPreviousLatlon(_nLNum,_nPrevNum){
}
function undoToPreviousLatlon(_nLNum){
  var _i = $('n_latlonhistory_'+_nLNum).value;
  _aoLocations[_nLNum].latlon = _aoLocations[_nLNum].latlonhistory[_i];
  _aoLocations[_nLNum].latlonhistory.splice(0,_i+1);
  registMarker(_nLNum,_aoLocations[_nLNum]);
}
function refreshSelectList(){
  var _sNewSelect = '<div id="div_select_list"><select name="infotech">';
  var _nLNum;
  for(_nLNum=0;_nLNum<_aoLocations.length;_nLNum++){
    _sNewSelect += '<option value="'+_aoLocations[_nLNum].id+'" onclick="centerLocation('+_nLNum+');">'+_aoLocations[_nLNum].name+'</option>';
  }
  _sNewSelect += '</select></div>';
  $('div_select_list').outerHTML = _sNewSelect;
}
