package Scheduler::Schema::TimeOptimized;

use strict;
use warnings;
use Carp;

use Time::Local;
use Scheduler::Schema::Time;

sub new($){
  my $oS = shift;
  my $sISO8601 = shift;
  return bless {
		utc => $oS->setISO8601($sISO8601),
	       };
}
sub setToNow{
  my $oS = shift;
  $oS->{utc} = Scheduler::Schema::Time->now;
}
sub setISO8601($){
  my $oS = shift;
  my $sT = shift;
  if(defined $sT && $sT =~ /^(\d{4})(?:-(\d{2})(?:-(\d{2})(?:T(\d{2}):(\d{2})(?::(\d{2})(?:\.(\d))?)?(Z|([+-]\d{2}):(\d{2}))?)?)?)?$/) {
    my ($year, $month, $day, $hour, $min, $sec, $wday) = ($1, ($2 ? $2 : 1), ($3 ? $3 : 1), $4, $5, $6);
    my $offset = 0;
    $offset = (abs($8) * 60 + $9) * ($8 >= 0 ? 60 : -60) if ($7);
    return ($7) ? &Time::Local::timegm($sec, $min, $hour, $day, $month - 1, $year) - $offset
      : &Time::Local::timelocal($sec, $min, $hour, $day, $month - 1, $year) - $offset;
  }else{
    return 0;
  }
}
sub ISO8601{
  my $oS = shift;
  my ($year,$month,$day,$hour,$minute,$second) = $oS->YMDHMS;
  return sprintf("%04d-%02d-%02dT%02d:%02d:%02d",$year,$month,$day,$hour,$minute,$second).$oS->getTZText;
}
sub setTime{
  my $oS = shift;
  $oS->{utc} = shift;
}
sub time{
  my $oS = shift;
  return $oS->{utc};
}
sub setYMDHMS{
  my $oS = shift;
  my ($nYear,$nMonth,$nDay,$nHour,$nMinute,$nSecond) = @_;
  my $offset = $oS->TZ*3600;
  $oS->{utc} = &Time::Local::timegm($nSecond,$nMinute,$nHour,$nDay,$nMonth-1,$nYear)-$offset;
}
sub YMDHMS{
  my $oS = shift;
  my ($sec,$min,$hour,$day,$month,$year) = @{[gmtime($oS->{utc}+$oS->TZ*3600)]};
  $year += 1900;
  $month++;
  return ($year,$month,$day,$hour,$min,$sec);
}
sub clone{
  my $oS = shift;
  my $oSNew = new Scheduler::Schema::TimeOptimized;
  $oSNew->setTime($oS->time);
  return $oSNew;
}
{
  my $nTZH = 9;
  my $nTZM = 0;

  sub TZ(){
    shift;
    return $nTZH+$nTZM/60;
  }
  sub setTZ($$){
    shift;
    my ($nTZH,$nTZM) = @_;
  }
  sub getTZText(){
    shift;
    return 'Z' if $nTZH == 0 and $nTZM == 0;
    my $sResult = '';
    $sResult = '+' if $nTZH >= 0;
    $sResult .= sprintf("%02d:%02d",$nTZH,$nTZM);
  }
}

1;
