package Configure;

use strict;
use warnings;
use Carp;

use IO::File;
use File::Copy;

use constant CONFIG_FILE_PATH => 'sche.storage.conf';
use constant DEFAULT_CONFIG_FILE_PATH => 'Init/sche.storage.conf.default';

sub new(@){
  shift;
  return bless{
	       isLoaded => 0,
	       rhasResult => {},
	       rhasNewResult => {},
	       isUpdated => 0,
	       deleteList => {},
	      };
}
sub load($){
  my $oS = shift;
  return if $oS->{isLoaded};
  if(!-e CONFIG_FILE_PATH or -z CONFIG_FILE_PATH){
    copy(DEFAULT_CONFIG_FILE_PATH,CONFIG_FILE_PATH);
    chmod(0666,CONFIG_FILE_PATH);
  }
  my $oI = new IO::File(CONFIG_FILE_PATH);
  while(<$oI>){
    chomp;
    next if $_ eq '';
    next if index($_,'#') == 0;
    $_ =~ m|^([\s\t]*)(.+)([\s\t]*)$|;
    $_ = $2;
    my ($sKey,@asValues) = split(m|[\s\t]+|,$_);
    next if !defined $sKey or scalar(@asValues) == 0;
    $oS->{rhasResult}->{$sKey} = [@asValues];
  }
  $oS->{rhasResult}->{encoding} = 'utf8' if !defined $oS->{rhasResult}->{encoding};
  $oS->{isLoaded} = 1;
}
sub get($){
  my $oS = shift;
  my $sKey = shift;
  $oS->load unless $oS->{isLoaded};
  return undef if !defined $oS->{rhasResult}->{$sKey} or $oS->{rhasResult}->{$sKey} eq '';
  my @asResult = @{$oS->{rhasResult}->{$sKey}};
  if(scalar @asResult == 1){
    return $asResult[0];
  }else{
    return @asResult;
  }
}
sub set($$){
  my $oS = shift;
  my $sKey = shift;
  my $sValue = shift;
  return if !defined $sKey or !defined $sValue;
  $oS->{rhasNewResult}->{$sKey} = [$sValue];
  $oS->{isUpdated} = 1;
}
sub isAllNeededInfoInside(){
  my $oS = shift;
  $oS->load;
  foreach(qw|STORAGE_URI DAT_IDENTIFIER LANGUAGE OUTPUT_ENCODING GOOGLE_MAP_ID REFRESH_SECONDS|){
    if(!defined $oS->{rhasResult}->{$_}){
      return 0;
    }
  }
  return 1;
}
sub delete($){
  my $oS = shift;
  return if !defined $_[0] or $_[0] eq '';
  $oS->{deleteList}{$_[0]} = 1;
}
sub update{
  my $oS = shift;
  if($oS->{isUpdated}){
    $oS->load;
    my $oIO = new IO::File('>'.CONFIG_FILE_PATH);
    return if !defined $oIO;
    my %hsKeys;
    foreach(keys %{$oS->{rhasResult}}){
      $hsKeys{$_} = 0;
    }
    foreach(keys %{$oS->{rhasNewResult}}){
      next if $oS->{deleteList}{$_} == 1;
      print $oIO $_.' '.join(' ',@{$oS->{rhasNewResult}{$_}})."\n";
      $hsKeys{$_} = 1;
    }
    foreach(keys %hsKeys){
      next if $hsKeys{$_};
      next if ref($oS->{rhasResult}{$_}) eq '';
      next if $oS->{deleteList}{$_} == 1;
      print $oIO $_.' '.join(' ',@{$oS->{rhasResult}{$_}})."\n";
    }
    undef $oIO;
  }
}

1;
