package Scheduler::Parser::Content;
@ISA = qw|Scheduler::Parser::base|;

use strict;
use warnings;
use Carp;

use Scheduler::Parser::base;
use Scheduler::Parser::ContentPlainText;
use Scheduler::Parser::ContentHyperLink;
use Scheduler::Parser::ContentXHTML;

sub obj($$){
  shift;
  my $oRoot = shift;
  my $oDocument = shift;
  my $oContent;
  if($oRoot->getAttribute('type') eq 'link'){
    $oContent = Scheduler::Parser::ContentHyperLink->obj($oRoot,$oDocument);
  }elsif($oRoot->getAttribute('type') eq 'xhtml'){
    $oContent = Scheduler::Parser::ContentXHTML->obj($oRoot,$oDocument);
  }else{
    $oContent = Scheduler::Parser::ContentPlainText->obj($oRoot,$oDocument);
  }
  return $oContent;
}
sub element($$){
  shift;
  my $oContent = shift;
  my $oDocument = shift;
  return if !defined $oContent or $oContent->isEmpty;
  if($oContent->type eq 'link'){
    return Scheduler::Parser::ContentHyperLink->element($oContent,$oDocument);
  }elsif($oContent->type eq 'xhtml'){
    return Scheduler::Parser::ContentXHTML->element($oContent,$oDocument);
  }else{
    return Scheduler::Parser::ContentPlainText->element($oContent,$oDocument);
  }
}

1;
