package Scheduler::Parser::Location;
@ISA = qw|Scheduler::Parser::base|;

use strict;
use warnings;
use Carp;

use Scheduler::Parser::base;
use Scheduler::Parser::LocationGPX;
use Scheduler::Parser::LocationName;

sub obj($$){
  shift;
  my $oRoot = shift;
  my $oDocument = shift;
  my $oLocation;
  my $oElement = $oRoot->firstChild;
  if($oElement->localname eq 'gpx'){
    $oLocation = Scheduler::Parser::LocationGPX->obj($oElement,$oDocument);
  }elsif($oElement->localname eq 'name'){
    $oLocation = Scheduler::Parser::LocationName->obj($oElement,$oDocument);
  }
  return $oLocation;
}
sub element($$){
  shift;
  my $oLocation = shift;
  my $oDocument = shift;
  my $oRoot = $oDocument->createElement('location');
  if($oLocation->type eq 'gpx'){
    $oRoot->addChild(Scheduler::Parser::LocationGPX->element($oLocation,$oDocument));
  }elsif($oLocation->type eq 'name'){
    $oRoot->addChild(Scheduler::Parser::LocationName->element($oLocation,$oDocument));
  }
  return $oRoot;
}

1;
