package Scheduler::Parser::LocationComplex;
@ISA = qw|Scheduler::Parser::base|;

use strict;
use warnings;
use Carp;

use Scheduler::Parser::base;
use Scheduler::Schema::LocationComplex;
use Scheduler::Parser::LocationGPX;

sub obj($){
  shift;
  my $oComplex = new Scheduler::Schema::LocationComplex;
  my $oRoot = shift;
  my $oDocument = shift;
  my @a = $oRoot->getChildNodes;
  foreach(@a){
    if($_->nodeName ne 'wpt'){
      next;
    }
    my $sID = $_->getAttribute('id');
    $oComplex->addGpxs(Scheduler::Parser::LocationGPX->obj($_,$oDocument));
  }
  return $oComplex;
}
sub element($){
  shift;
  my $oComplex = shift;
  my $oDocument = shift;
  my $oRoot = $oDocument->createElement('cpx');
  foreach(keys %{$oComplex->gpxs}){
    my $oValue = $oComplex->gpxs->{$_};
    my $oElement = Scheduler::Parser::LocationGPX->element($oValue,$oDocument);
    $oElement->setAttribute('id',$_);
    $oRoot->appendChild($oElement);
  }
  return $oRoot;
}

1;
