package Scheduler::Schema::Sche;

use strict;
use warnings;
use Carp;

use Scheduler::Schema::Changeable;
use Scheduler::Schema::Location;

sub new(%){
  shift;
  return bless {
		id => undef,
		aliasid => [],
		uris => [],
		changeables => [],
		generator => undef,
	       };
}
sub id{
  my $oS = shift;
  return defined $oS->{id}?$oS->{id}:"";
}
sub uri{
  return $_[0]->uris(0);
}
sub uris{
  if(defined $_[1]){
    return $_[0]->{uris}->[0];
  }
  return $_[0]->{uris};
}
sub changeables{
  if(defined $_[1]){
    return $_[0]->{changeables}->[0];
  }
  $_[0]->{changeables};
}
sub changeable{
  return $_[0]->changeables(0);
}
sub generator{$_[0]->{generator};}
sub aliasids{
  if(defined $_[1]){
    return $_[0]->{aliasid}->[$_[1]];
  }
  $_[0]->{aliasid};
}
sub aliasid{
  return $_[0]->aliasids(0);
}

sub setId($){$_[0]->{id}=$_[1];}
sub addChangeable($){push(@{$_[0]->{changeables}},$_[1]);}
sub setChangeable($){$_[0]->{changeables} = [$_[1]];}
sub setGenerator{$_[0]->{generator}=$_[1];}
sub addURI($){push(@{$_[0]->{uris}},$_[1]);}
sub addNewURI($){unshift(@{$_[0]->{uris}},$_[1]);}
sub setAliasid($){$_->{aliasid}=[$_[1]];}
sub addAliasid($){push(@{$_->{aliasid}},$_[1]);}

sub isValid{1;}
sub clone{
  my $oS = shift;
  my $oSNew = new Scheduler::Schema::Sche;
  $oSNew->setId($oS->id);
  $oSNew->setGenerator($oS->generator->clone);
  $oSNew->addChangeable($_->clone) for @{$oS->changeables};
  $oSNew->addURI($_) for @{$oS->uris};
  return $oSNew;
}

1;
