package Section::Detail;
@ISA = qw|Section::base|;

use strict;
use warnings;
use Carp;

use Section::base;

sub new{
    shift;
    return bless Section::base->new(@_);
}
sub out{
  my $oS = shift;
  $oS->setHistoryStack('detail');
  $oS->oOut->setSubtitle('Detail');
  $oS->oOut->isUsingPrototypeJS;
  my $sHeader = '<script type="text/javascript">
//<![CDATA[
';
  $sHeader .= $_ while <DATA>;
  $sHeader .= '//]]></script>';
  my @asIDs = $oS->oCGI->param('id');
  my $sRes = $sHeader.$oS->oOut->sectionBegin('DETAIL','detail');
  if(scalar(@asIDs) == 0){
    $sRes .= '<p>'.$oS->getEncLng('DETAIL_NOTHING_TO_SHOW').'</p>';
  }else{
    $sRes .= '<form method="POST" action="index.cgi"><input type="hidden" name="mode" value="edit"><input type="hidden" name="hstack" value="'.$oS->getHistoryStack.'" />';
    my $isOnlyOne = scalar(@asIDs)==1;
    my $nEditableSches = 0;
    my $oGF = Section->new('GlobalFormat::1',$oS->env);
    foreach(@asIDs){
      my $oSche = $oS->oDat->getScheByID($_);
      next if !defined $oSche or !defined $oSche->changeables->[0];
      my $sCheck;
      if($oS->oLgi->isLoggedIn and !defined $oS->oDat->getScheByIDFrom($_,'imported')){
	if($isOnlyOne){
	  $sCheck .= qq|<input type="hidden" name="id" value="$_" />|;
	}else{
	  $sCheck = qq|<input type="checkbox" name="id" value="$_" checked="checked" />|;
	}
	$nEditableSches++;
      }else{
	if(!$isOnlyOne){
	  $sCheck = qq|<input type="checkbox" disabled="disabled" />|;
	}
      }
      $sRes .= qq|<h3>$sCheck$_</h3>|;
      $sRes .= '<div class="sche2"><a href="index.cgi?mode=xsche&id='.$_.'"><span class="xsche">'.$oS->getEncLng('XSCHE').'</span></a></div>';
      $sRes .= $oGF->out($oSche->changeables->[0],
			 id => $_);
      my $nChCount = 1;
      my @aoChangeables = @{$oSche->changeables};
      shift @aoChangeables;
      if(scalar(@aoChangeables) > 0){
	$sRes .= '<h4>'.$oS->getEncLng('REVISIONS').'</h4>';
	$sRes .= '<ol class="revisions">';
	shift @aoChangeables;
	foreach my $oChangeable(@aoChangeables){
	  my @asT = $oChangeable->modified->YMDHMS;
	  my $sTime = sprintf("%04d/%d/%d %d:%02d:%02d",@asT);
	  my @aoAuthors = @{$oChangeable->authors};
	  my @asAuthors = ();
	  foreach(@aoAuthors){
	    my ($sMail,$sURI);
	    $sMail = $_->email;
	    $sURI = $_->uri;
	    my $sName = $oS->oOut->encoded($_->name);
	    $sName = '<a href="mailto:'.$sMail.'">'.$sName.'</a>' if defined $sMail;
	    $sName .= ' <a href="'.$sURI.'">['.$sURI.']</a>' if defined $sURI;
	    push(@asAuthors,$sName);
	  }
	  $sRes .= '<li><input type="button" value="OPEN" onclick="toggleChangeable(\''.$_.'_'.$nChCount.'\');" name="'.$_.'_'.$nChCount.'_button" id="'.$_.'_'.$nChCount.'_button" /> '.$sTime.' : '.join(',',@asAuthors).'</li>';
	  $oS->oOut->appendBodyTagAttribute('onload','hideChangeable(\''.$_.'_'.$nChCount.'\');');
	  $sRes .= $oGF->out($oChangeable,
			     id => $_,
			     revnum => $nChCount++);
	}
	$sRes .= '</ol>';
      }
    }
    if($nEditableSches){
      my $sButtonMessage = $nEditableSches==1
	?$oS->getEncLng('EDIT_THIS_SCHEDULE')
	  :$oS->getEncLng('EDIT_THE_SCHEDULES_CHECKED');
      $sRes .= qq|<input type="submit" value="$sButtonMessage" /></form>|;
    }
  }
  return $sRes.$oS->oOut->sectionEnd;
}

1;

__DATA__
  var hsShowed = new Array();

  function toggleChangeable(id){
    var oDiv = $(id);
    oDiv.toggle();
    var oTag = document.getElementById(id+"_button");
if(oTag.value == "OPEN"){
  oTag.value = "CLOSE";
}else{
  oTag.value = "OPEN";
}
}
  function hideChangeable(id){
    var oDiv = $(id);
    oDiv.hide();
    var oTag = document.getElementById(id+"_button");
oTag.value = "OPEN";
}
