package Scheduler::Parser::Changeable;
@ISA = qw|Scheduler::Parser::base|;

use strict;
use warnings;
use Carp;

use Scheduler::Parser::base;
use Scheduler::Schema::Changeable;
use Scheduler::Schema::TimeOptimized;
use Scheduler::Parser::Changeable;
use Scheduler::Parser::Time;
use Scheduler::Parser::Author;
use Scheduler::Parser::Location;
use Scheduler::Parser::Content;
use Scheduler::Parser::Generator;

sub obj($$){
  shift;
  my $oChangeable = new Scheduler::Schema::Changeable;
  my $oRoot = shift;
  my $oDocument = shift;
  my @a = $oRoot->getChildNodes;
  foreach(@a){
    if($_->nodeName eq 'modified'){
      $oChangeable->setModified(new Scheduler::Schema::TimeOptimized($_->firstChild->nodeValue));
    }elsif($_->nodeName eq 'title'){
      $oChangeable->setTitle($_->firstChild->nodeValue);
    }elsif($_->nodeName eq 'subtitle'){
      $oChangeable->setSubtitle($_->firstChild->nodeValue);
    }elsif($_->nodeName eq 'summary'){
      $oChangeable->setSummary($_->firstChild->nodeValue);
    }elsif($_->nodeName eq 'class'){
      $oChangeable->setClass($_->firstChild->nodeValue);
    }elsif($_->nodeName eq 'time'){
      $oChangeable->setTime(Scheduler::Parser::Time->obj($_,$oDocument));
    }elsif($_->nodeName eq 'author'){
      $oChangeable->addAuthor(Scheduler::Parser::Author->obj($_,$oDocument));
    }elsif($_->nodeName eq 'location'){
      $oChangeable->addLocation(Scheduler::Parser::Location->obj($_,$oDocument));
    }elsif($_->nodeName eq 'content'){
      $oChangeable->setContent(Scheduler::Parser::Content->obj($_,$oDocument));
    }elsif($_->nodeName eq 'reloadinterval'){
      $oChangeable->setReloadinterval($_->firstChild->nodeValue);
    }elsif($_->nodeName eq 'generator'){
      $oChangeable->setGenerator(Scheduler::Parser::Generator->obj($_,$oDocument));
    }
  }
  return $oChangeable;
}
sub element($$){
  shift;
  my $oChangeable = shift;
  my $oDocument = shift;
  my $oRoot = $oDocument->createElement('changeable');
  if(defined $oChangeable->type){
    $oRoot->setAttribute('type',$oChangeable->type);
  }else{
    $oRoot->setAttribute('type','full');
  }
  $oRoot->appendTextChild('modified',$oChangeable->modified->ISO8601);
  $oRoot->appendTextChild('title',$oChangeable->title);
  if(defined $oChangeable->subtitle and $oChangeable->subtitle ne ''){
    $oRoot->appendTextChild('subtitle',$oChangeable->subtitle); }
  if(defined $oChangeable->summary and $oChangeable->summary ne ''){
    $oRoot->appendTextChild('summary',$oChangeable->summary); }
  $oRoot->appendChild(Scheduler::Parser::Time->element($oChangeable->time,$oDocument));
  $oRoot->appendTextChild('class',$oChangeable->class);
  my $oContent = Scheduler::Parser::Content->element($oChangeable->content,$oDocument);
  $oRoot->appendChild($oContent) if defined $oContent;
  foreach(@{$oChangeable->locations}){
    $oRoot->addChild(Scheduler::Parser::Location->element($_,$oDocument));
  }
  foreach(@{$_->authors}){
    $oRoot->addChild(Scheduler::Parser::Author->element($_,$oDocument));
  }
  $oRoot->appendTextChild('reloadinterval',$oChangeable->reloadinterval);
  $oRoot->addChild(Scheduler::Parser::Generator->element($oChangeable->generator,$oDocument))
    if defined $oChangeable->generator;
  return $oRoot;
}

1;
