package xor.main;

import java.util.*;
import java.lang.*;
import java.util.regex.*;
import java.util.logging.*;

public abstract class AbstractInterface implements Runnable{
    protected Kernel m_oKernel;
    private StringBuffer m_sQueryBuffer;

    public AbstractInterface(Kernel _oKernel){
	m_oKernel = _oKernel;
	m_sQueryBuffer = new StringBuffer("");
    }
    public void println(String _sMessage){
	ConsoleEvent _oEv = new ConsoleEvent(this,"println",_sMessage);
	sendConsoleListener(_oEv);
    }
    public void print(String _sMessage){
	ConsoleEvent _oEv = new ConsoleEvent(this,"print",_sMessage);
	sendConsoleListener(_oEv);
    }
    public void clear(){
	ConsoleEvent _oEv = new ConsoleEvent(this,"clear",null);
	sendConsoleListener(_oEv);
    }
    abstract public int makeDecision(String _sMessage);
    protected void hasQuery(String _sQuery){
	ConsoleEvent _oEv = new ConsoleEvent(this,"hasQuery",_sQuery);
	sendConsoleListener(_oEv);
    }
    protected void hasNoQuery(String _sQuery){
	ConsoleEvent _oEv = new ConsoleEvent(this,"hasNoQuery",_sQuery);
	sendConsoleListener(_oEv);
    }
    protected void executedQuery(String _sQuery){
	ConsoleEvent _oEv = new ConsoleEvent(this,"executedQuery",_sQuery);
	sendConsoleListener(_oEv);
    }
    public void run(){
	m_oKernel.getLogger().log(Level.CONFIG,"Starting Interface : "+type());
    }
    synchronized protected void sendQuery(String _sQuery){
	m_oKernel.execQuery(_sQuery);
    }
    synchronized protected void pullTriggerWithUnoptimized(String _sUQuery){
	StringBuffer _sQueryBuffer = new StringBuffer(m_sQueryBuffer);
	_sQueryBuffer.append(" ").append(optimize(_sUQuery.replace("\n"," ").replace("\t"," ")));
	int _nSemicolon;
	boolean _isQueryComplete = false;
	String _sQuery = "";
	while((_nSemicolon = _sQueryBuffer.indexOf(";")) != -1){
	    _sQuery = _sQueryBuffer.substring(0,_nSemicolon);
	    sendQuery(_sQuery);
	    if(_isQueryComplete){
		executedQuery(_sQuery);
	    }
	    _sQueryBuffer = new StringBuffer(_sQueryBuffer.substring(_nSemicolon+1));
	    _isQueryComplete = true;
	}
	if(_isQueryComplete){
	    hasQuery(new String(_sQueryBuffer));
	    m_sQueryBuffer = _sQueryBuffer;
	    executedQuery(_sQuery);
	}else{
	    hasNoQuery(new String(_sQueryBuffer));
	}
    }
    abstract public String type();
    protected String optimize(String _sTarget){
	Pattern _oP;
	Matcher _oM;
	String _oT;
	_oP = Pattern.compile("\\s*,\\s*");
	_oM = _oP.matcher(_sTarget);
	_oT = _oM.replaceAll(",");
	return _oT;
    }
    public Kernel oKernel(){
	return m_oKernel;
    }
    private Vector<ConsoleListener> m_aoConsoleListeners = new Vector<ConsoleListener>();
    public void addConsoleListener(ConsoleListener _oL){
	m_aoConsoleListeners.addElement(_oL);
    }
    public void removeConsoleListener(ConsoleListener _oL){
	m_aoConsoleListeners.removeElement(_oL);
    }
    public void sendConsoleListener(ConsoleEvent _oEv){
	String _sType = _oEv.getType();
	Vector<ConsoleListener> _aoL = (Vector<ConsoleListener>)m_aoConsoleListeners.clone();
	Enumeration _oENum = _aoL.elements();
	if(_sType.equals("print")){
	    while(_oENum.hasMoreElements()){
		ConsoleListener _oL = (ConsoleListener)_oENum.nextElement();
		_oL.print(_oEv);
	    }
	}else if(_sType.equals("println")){
	    while(_oENum.hasMoreElements()){
		ConsoleListener _oL = (ConsoleListener)_oENum.nextElement();
		_oL.println(_oEv);
	    }
	}else if(_sType.equals("clear")){
	    while(_oENum.hasMoreElements()){
		ConsoleListener _oL = (ConsoleListener)_oENum.nextElement();
		_oL.clear(_oEv);
	    }
	}else if(_sType.equals("hasQuery")){
	    while(_oENum.hasMoreElements()){
		ConsoleListener _oL = (ConsoleListener)_oENum.nextElement();
		_oL.hasQuery(_oEv);
	    }
	}else if(_sType.equals("hasNoQuery")){
	    while(_oENum.hasMoreElements()){
		ConsoleListener _oL = (ConsoleListener)_oENum.nextElement();
		_oL.hasNoQuery(_oEv);
	    }
	}else if(_sType.equals("executedQuery")){
	    while(_oENum.hasMoreElements()){
		ConsoleListener _oL = (ConsoleListener)_oENum.nextElement();
		_oL.executedQuery(_oEv);
	    }
	}
    }

    private Vector<DBSetListener> m_aoDBSetListeners = new Vector<DBSetListener>();
    public void addDBSetListener(DBSetListener _oL){
	m_aoDBSetListeners.addElement(_oL);
    }
    public void removeDBSetListener(DBSetListener _oL){
	m_aoDBSetListeners.removeElement(_oL);
    }
    public void sendDBSetListener(DBSetEvent _oEv){
	DBSetEnum _sType = _oEv.getType();
	Vector<DBSetListener> _aoL = (Vector<DBSetListener>)m_aoDBSetListeners.clone();
	Enumeration _oENum = _aoL.elements();
	switch(_sType){
	case ADD:
	    while(_oENum.hasMoreElements()){
		DBSetListener _oL = (DBSetListener)_oENum.nextElement();
		_oL.add(_oEv);
	    }
	    break;
	case REMOVE:
	    while(_oENum.hasMoreElements()){
		DBSetListener _oL = (DBSetListener)_oENum.nextElement();
		_oL.remove(_oEv);
	    }
	    break;
	case SELECT:
	    if(m_oKernel.getDBSet().isBusy()){
		m_oKernel.getLogger().warning("Select was cancelled because DB is busy.");
		break;
	    }
	    while(_oENum.hasMoreElements()){
		DBSetListener _oL = (DBSetListener)_oENum.nextElement();
		_oL.select(_oEv);
	    }
	    break;
	case UNSELECT:
	    while(_oENum.hasMoreElements()){
		DBSetListener _oL = (DBSetListener)_oENum.nextElement();
		_oL.unselect(_oEv);
	    }
	    break;
	case MOVE:
	    while(_oENum.hasMoreElements()){
		DBSetListener _oL = (DBSetListener)_oENum.nextElement();
		_oL.move(_oEv);
	    }
	case UPDATE:
	    while(_oENum.hasMoreElements()){
		DBSetListener _oL = (DBSetListener)_oENum.nextElement();
		_oL.update(_oEv);
	    }
	case DONE:
	    while(_oENum.hasMoreElements()){
		DBSetListener _oL = (DBSetListener)_oENum.nextElement();
		_oL.done(_oEv);
	    }
	default:
	    break;
	}
    }
}
