package xor.main;

import java.util.*;
import xor.sche.*;

final public class DBBuffer extends Node{
    protected Map<String,Sche> m_oSche;

    public DBBuffer(){
	m_oSche = new HashMap<String,Sche>();
    }
    synchronized public boolean addNewSche(Sche _oSche){
	if(!containsSche(_oSche)){
	    m_oSche.put(_oSche.ID(),_oSche);
	    addNode(_oSche.ID(),_oSche);
	    return true;
	}
	return false;
    }
    synchronized public void removeSche(Sche _oSche){
	m_oSche.remove(_oSche.ID());
	deleteNode(_oSche.ID());
    }
    public String type(){
	return "db-buffer";
    }
    public boolean containsSche(Sche _oSche){
	return m_oSche.containsKey(_oSche.ID());
    }
    public boolean containsID(String _sID){
	return m_oSche.containsKey(_sID);
    }
    public Set<String> getIDs(){
	return m_oSche.keySet();
    }
    public Sche getScheWith(String _sID){
	return (Sche)m_oSche.get(_sID);
    }
}
