package xor.main;

import java.net.*;
import java.io.*;
import java.util.*;
import xor.sche.*;

public class Importer extends Node{
    private DBSet m_oDBSet;
    private Kernel m_oKernel;
    private Map<URI,Loader> m_aoURIs;
    private String m_sNetConfigRootPath;
    private SettingNetworkProxy m_oSNP;

    public Importer(Kernel _oKernel,String _sNetConfigRootPath,DBSet _oDBSet){
	m_oKernel = _oKernel;
	m_oDBSet = _oDBSet;
	m_oKernel.getLogger().config("Starting Importer.");
	m_oSNP = new SettingNetworkProxy(_oKernel,_sNetConfigRootPath+"/proxy.conf");
    }
    public void addURIString(String _sURI){
	try{
	    URI _oURI = new URI(_sURI);
	    addURI(_oURI);
	}catch(URISyntaxException e){
	    m_oKernel.getLogger().warning("Syntax error at URI : "+_sURI);
	}
    }
    public void addURI(URI _oURI){
	Loader _oL = new Loader(_oURI);
	new Thread(_oL).start();
    }
    public void setSche(Sche _oNew){
	setSche(_oNew,"palette");
    }
    public void setSche(Sche _oNew,String _sType){
	if(_sType == null){
	    _sType = "palette";
	}
	m_oDBSet.callbackNodeComplete(_oNew,_sType);
    }
    public String type(){
	return "importer";
    }
    public SettingNetworkProxy getSNP(){
	return m_oSNP;
    }
    class Loader implements Runnable{
	private URI m_oURI;
	private boolean m_isDone,m_isProcessDone;
	private String m_sType;
	
	public Loader(URI _oURI){
	    m_oURI = _oURI;
	    m_isDone = m_isProcessDone = false;
	    m_oSNP.refresh();
	    m_sType = null;
	}
	public void setType(String _sType){
	    m_sType = _sType;
	}
	public void run(){
	    m_oKernel.getLogger().fine("Starting URI Importer thread to load : "+m_oURI);
	    try{
		URL _oURL = m_oURI.toURL();
		URLConnection _oURICon = (HttpURLConnection)_oURL.openConnection();
		_oURICon.setUseCaches(false);
		_oURICon.setDefaultUseCaches(false);
		_oURICon.connect();
		BufferedReader _oBR = new BufferedReader(new InputStreamReader(_oURICon.getInputStream(),"UTF-8"));
		StringBuffer _sResult = new StringBuffer("");
		String _sLine;
		while((_sLine = _oBR.readLine()) != null){
		    _sResult.append(_sLine);
		}
		if(m_sType == null){
		    m_sType = "palette";
		}
		xor.main.dbloader.XMLFileLoader _oXFL = new xor.main.dbloader.XMLFileLoader(m_oDBSet,new String(_sResult),m_sType,m_oKernel);
		_oXFL.run();
		m_isDone = true;
	    }catch(java.net.ConnectException e){
		m_oKernel.getLogger().severe("Connection refused.");
	    }catch(Exception e){
		e.printStackTrace();
	    }
	    m_oKernel.getLogger().fine("Ending URI Importer thread to load : "+m_oURI);
	    m_isProcessDone = true;
	}
	public boolean isDone(){
	    return m_isDone;
	}
	public boolean isProcessDone(){
	    return m_isProcessDone;
	}
    }
    public void reloadSche(Sche _oS){
	ScheReloader _oSR = new ScheReloader(_oS);
	Thread _oT = new Thread(_oSR);
	_oSR.setThread(_oT);
	_oT.start();
    }
    class ScheReloader implements Runnable{
	private Sche m_oSche;
	private Thread m_oT;

	ScheReloader(Sche _oSche){
	    m_oSche = _oSche;
	}
	public void setThread(Thread _oT){
	    m_oT = _oT;
	}
	public void run(){
	    AbstractList<URI> _aoURIs = m_oSche.URIs();
	    Iterator _i = _aoURIs.iterator();
	    String _sType = m_oKernel.getDBSet().typeOf(m_oSche);
	    while(_i.hasNext()){
		URI _oL = (URI)_i.next();
		boolean _isLoaded = tryToLoad(_oL,_sType);
		if(_isLoaded){
		    break;
		}
	    }
	}
	private boolean tryToLoad(URI _oURI,String _sType){
	    Loader _oL = new Loader(_oURI);
	    _oL.setType(_sType);
	    new Thread(_oL).start();
	    while(!_oL.isProcessDone()){
		try{
		    m_oT.sleep(1000);
		}catch(InterruptedException _oE){
		    _oE.printStackTrace();
		}
	    }
	    if(_oL.isProcessDone()){
		return true;
	    }
	    return false;
	}
    }
}
