package xor.main;

import java.util.*;
import java.lang.*;
import xor.main.schedul.*;

public class SCHEDULParser extends AbstractQueryParser{
    private Thread m_tParser;

    public SCHEDULParser(Kernel _oKernel){
	super(_oKernel);
	m_oKernel.getLogger().config("Starting ScheDUL Parser.");
    }
    synchronized public boolean parse(String _sQuery,SelectionMap _oSM){
	boolean _isQ = super.parse(_sQuery,_oSM);
	if(!_isQ){return false;}
	m_tParser = new Thread(new Parser(_sQuery,_oSM));
	m_tParser.start();
	return true;
    }
    class Parser implements Runnable{
	private String m_sQuery;
	private SelectionMap m_oSM;
	
	Parser(String _sQuery,SelectionMap _oSM){
	    m_sQuery = _sQuery;
	    m_oSM = _oSM;
	}
	public void run(){
	    m_oKernel.getLogger().fine("Starting ScheDUL parser thread to parse : "+m_sQuery+". Called from "+m_oSM);
	    AbstractList<String> _asT = new LinkedList<String>();
	    StringTokenizer _oST = new StringTokenizer(m_sQuery," ",false);
	    while(_oST.hasMoreTokens()){
		_asT.add(_oST.nextToken());
	    }
	    Root _oRoot = new Root(m_oKernel,m_oSM);
	    _oRoot.parse(_asT);
	    m_oKernel.getLogger().fine("Ending ScheDUL parser thread to parse : "+m_sQuery+". Called from "+m_oSM);
	}
    }
}
