package xor.main;

import java.util.*;
import java.net.*;

public class SettingNetworkProxy{
    private Map<String,AddPair> m_aoProxys;
    private boolean m_isUsingProxyInHTTP1_1;
    private boolean m_isUsingProxyInLocalServer;
    private Set<InetAddress> m_aoProxyIgnoringAddresses;
    private boolean m_isRefreshed;
    private TextConfigFileLoader m_oTCFL;
    
    SettingNetworkProxy(Kernel _oK,String _sPath){
	m_aoProxyIgnoringAddresses = new HashSet<InetAddress>();
	m_aoProxys = new HashMap<String,AddPair>();
	m_oTCFL = new TextConfigFileLoader(_oK,_sPath);
	initMap();
	loadMap();
	m_isUsingProxyInHTTP1_1 = false;
	m_isUsingProxyInLocalServer = false;
	m_isRefreshed = false;
	refresh();
    }
    private void initMap(){
	m_aoProxys.put("http",null);
	m_aoProxys.put("https",null);
	m_aoProxys.put("ftp",null);
	m_aoProxys.put("socks",null);
    }
    private void loadMap(){
	try{
	    if(m_oTCFL.getOne("HTTP_PROXY_HOST") != null){
		AddPair _oAP = new AddPair(
					   "http",
					   m_aoProxyIgnoringAddresses,
					   InetAddress.getByName(m_oTCFL.getOne("HTTP_PROXY_HOST")),
					   Integer.parseInt(m_oTCFL.getOne("HTTP_PROXY_PORT"))
					   );
		m_aoProxys.put("http",_oAP);
	    }else{
		m_aoProxys.put("http",new AddPair("http",m_aoProxyIgnoringAddresses));
	    }
	    if(m_oTCFL.getOne("FTP_PROXY_HOST") != null){
		AddPair _oAP = new AddPair(
					   "ftp",
					   m_aoProxyIgnoringAddresses,
					   InetAddress.getByName(m_oTCFL.getOne("FTP_PROXY_HOST")),
					   Integer.parseInt(m_oTCFL.getOne("FTP_PROXY_PORT"))
					   );
		m_aoProxys.put("ftp",_oAP);
	    }else{
		m_aoProxys.put("ftp",new AddPair("http",m_aoProxyIgnoringAddresses));
	    }
	    if(m_oTCFL.getOne("HTTPS_PROXY_HOST") != null){
		AddPair _oAP = new AddPair(
					   "https",
					   m_aoProxyIgnoringAddresses,
					   InetAddress.getByName(m_oTCFL.getOne("HTTPS_PROXY_HOST")),
					   Integer.parseInt(m_oTCFL.getOne("HTTPS_PROXY_PORT"))
					   );
		m_aoProxys.put("https",_oAP);
	    }else{
		m_aoProxys.put("https",new AddPair("http",m_aoProxyIgnoringAddresses));
	    }
	    if(m_oTCFL.getOne("SOCKS_PROXY_HOST") != null){
		AddPair _oAP = new AddPair(
					   "socks",
					   m_aoProxyIgnoringAddresses,
					   InetAddress.getByName(m_oTCFL.getOne("SOCKS_PROXY_HOST")),
					   Integer.parseInt(m_oTCFL.getOne("SOCKS_PROXY_PORT"))
					   );
		m_aoProxys.put("socks",_oAP);
	    }else{
		m_aoProxys.put("socks",new AddPair("http",m_aoProxyIgnoringAddresses));
	    }
	}catch(Exception e){
	    e.printStackTrace();
	}
    }
    public void setAllProxySettingsToHTTPProxy(){
	AddPair _oAPFTP = m_aoProxys.get("http").clone();
	_oAPFTP.setType("ftp");
	m_aoProxys.put("ftp",_oAPFTP);
	AddPair _oAPHTTPS = m_aoProxys.get("http").clone();
	_oAPHTTPS.setType("https");
	m_aoProxys.put("https",_oAPHTTPS);
	AddPair _oAPSOCKS = m_aoProxys.get("http").clone();
	_oAPSOCKS.setType("socks");
	m_aoProxys.put("socks",_oAPSOCKS);
    }
    public AddPair getPairFor(String _sProtocol){
	return m_aoProxys.get(_sProtocol);
    }
    private void setPairFor(String _sProtocol,AddPair _oAP){
	m_aoProxys.put(_sProtocol,_oAP);
    }
    synchronized public void refresh(){
	Iterator _i = m_aoProxys.keySet().iterator();
	while(_i.hasNext()){
	    AddPair _oAP = m_aoProxys.get((String)_i.next());
	    if(_oAP == null){continue;}
	    _oAP.refresh();
	}
	if(!m_isRefreshed){
	    m_isRefreshed = true;
	}
    }
    synchronized public void update(){
	gatherPairInfos();
	m_oTCFL.update();
	loadMap();
    }
    private void gatherPairInfos(){
	AddPair _oS;
	_oS = m_aoProxys.get("http");
	if(_oS != null && _oS.isSet()){
	    m_oTCFL.set("HTTP_PROXY_HOST",_oS.getInetAdd());
	    m_oTCFL.set("HTTP_PROXY_PORT",new Integer(_oS.getPort()).toString());
	}else{
	    m_oTCFL.remove("HTTP_PROXY_HOST");
	    m_oTCFL.remove("HTTP_PROXY_PORT");
	}
	_oS = m_aoProxys.get("https");
	if(_oS != null && _oS.isSet()){
	    m_oTCFL.set("HTTPS_PROXY_HOST",_oS.getInetAdd());
	    m_oTCFL.set("HTTPS_PROXY_PORT",new Integer(_oS.getPort()).toString());
	}else{
	    m_oTCFL.remove("HTTPS_PROXY_HOST");
	    m_oTCFL.remove("HTTPS_PROXY_PORT");
	}
	_oS = m_aoProxys.get("ftp");
	if(_oS != null && _oS.isSet()){
	    m_oTCFL.set("FTP_PROXY_HOST",_oS.getInetAdd());
	    m_oTCFL.set("FTP_PROXY_PORT",new Integer(_oS.getPort()).toString());
	}else{
	    m_oTCFL.remove("FTP_PROXY_HOST");
	    m_oTCFL.remove("FTP_PROXY_PORT");
	}
	_oS = m_aoProxys.get("socks");
	if(_oS != null && _oS.isSet()){
	    m_oTCFL.set("SOCKS_PROXY_HOST",_oS.getInetAdd());
	    m_oTCFL.set("SOCKS_PROXY_PORT",new Integer(_oS.getPort()).toString());
	}else{
	    m_oTCFL.remove("SOCKS_PROXY_HOST");
	    m_oTCFL.remove("SOCKS_PROXY_PORT");
	}
    }
}
