package xor.main;

import java.io.*;
import java.util.*;
import java.util.regex.*;

public class TextConfigFileLoader extends TextFileLoader{
    protected Map<String,String> m_asDatas;

    public TextConfigFileLoader(Kernel _oKernel,String _sFileName){
	super(_oKernel,_sFileName);
	m_asDatas = new HashMap<String,String>();
    }
    public String getOne(String _sKey){
	if(!m_isFileLoaded){
	    load();
	}
	return m_asDatas.get(_sKey);
    }
    public void set(String _sKey,String _sFirstValue){
	if(!m_isFileLoaded){
	    load();
	}
	remove(_sKey);
	add(_sKey,_sFirstValue);
    }
    public void add(String _sKey,String _sValue){
	if(!m_isFileLoaded){
	    load();
	}
	m_asDatas.put(_sKey,_sValue);
    }
    public void remove(String _sKey){
	if(!m_isFileLoaded){
	    load();
	}
	m_asDatas.remove(_sKey);
    }
    synchronized private void load(){
	checkFiles();
	try{
	    BufferedReader _oBL = new BufferedReader(new InputStreamReader(new FileInputStream(m_sFileName),"UTF-8"));
	    String _sLine;
	    Pattern _oPt = Pattern.compile("[\\s\\t]+");
	    while((_sLine = _oBL.readLine()) != null){
		int _nCommentOut = _sLine.indexOf("#");
		if(_nCommentOut != -1){
		    _sLine = _sLine.substring(0,_nCommentOut);
		}
		Matcher _oM = _oPt.matcher(_sLine);
		_sLine = _oM.replaceAll(" ");
		StringTokenizer _oST = new StringTokenizer(_sLine," ",false);
		if(_oST.hasMoreTokens()){
		    String _sKey = (String)_oST.nextToken();
		    String _sValues = "";
		    while(_oST.hasMoreTokens()){
			if(!_sValues.equals("")){
			    _sValues = _sValues+" ";
			}
			_sValues = _sValues+(String)_oST.nextToken();
		    }
		    m_asDatas.put(_sKey,_sValues);
		}
	    }
	    _oBL.close();
	    m_isFileLoaded = true;
	}catch(Exception e){
	    e.printStackTrace();
	}
	m_oKernel.getLogger().fine("Loaded "+m_sFileName);
    }
    synchronized public void update(){
	checkFiles();
	try{
	    BufferedWriter _oFW = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(m_sFileName),"UTF-8"));
	    Iterator _iKeys = m_asDatas.keySet().iterator();
	    while(_iKeys.hasNext()){
		String _sKey = (String)_iKeys.next();
		_oFW.write(_sKey);
		_oFW.write(" ");
		_oFW.write(m_asDatas.get(_sKey));
		_oFW.write("\n");
	    }
	    _oFW.close();
	}catch(Exception e){
	    e.printStackTrace();
	}
	m_oKernel.getLogger().fine("Updated "+m_sFileName);
    }
}
