package xor.main.dbloader.xml;

import java.io.*;
import xor.sche.*;
import org.w3c.dom.*;
import javax.xml.parsers.*;
import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.stream.*;

abstract class AbstractXScheConverter{
    protected DocumentBuilder m_oBuilder;
    protected Document m_oD;

    abstract public ScheObj obj(Element _oE) throws ParseErrorException;
    abstract public Element element(ScheObj _oS);
    
    public AbstractXScheConverter(){
	try{
	    m_oBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
	    m_oD = m_oBuilder.newDocument();
	}catch(Exception e){
	    e.printStackTrace();
	}
    }
    public AbstractXScheConverter(Document _oD){
	m_oD = _oD;
    }
    public ScheObj objFromFile(File _oF) throws ParseErrorException{
	Element _oRoot = null;
	try{
	    m_oD = m_oBuilder.parse(_oF);
	    _oRoot = m_oD.getDocumentElement();
	}catch(Exception e){
	    e.printStackTrace();
	}
	return obj(_oRoot);
    }
    public void writeFileFromObj(File _oF,ScheObj _oS){
	m_oD.appendChild(element(_oS));
	Source _oDC = new DOMSource(m_oD);
	StreamResult _oSR = new StreamResult(_oF);
	try{
	    Transformer _oTF = TransformerFactory.newInstance().newTransformer();
	    _oTF.transform(_oDC,_oSR);
	}catch(Exception e){
	    e.printStackTrace();
	}
    }
    protected String getText(Node _oN){
	short _nNodeType = _oN.getFirstChild().getNodeType();
	if(_nNodeType == Node.TEXT_NODE){
	    return _oN.getFirstChild().getNodeValue();
	}else if(_nNodeType == Node.CDATA_SECTION_NODE){
	    if(_oN.getFirstChild().getFirstChild() == null){
		return _oN.getFirstChild().getNodeValue();
	    }else{
		return _oN.getFirstChild().getFirstChild().getNodeValue();
	    }
	}
	return "";
    }
}
