package xor.main.swing;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.color.*;
import java.awt.event.*;
import java.util.*;
import java.text.*;
import xor.main.*;
import xor.sche.*;

public class Calendar extends Inside{
    /*
      [COMPOSITION TREE]
      - Calendar
        - DateBuffer
          - ScheduleSet
        - Dates(CalendarControl)
          - DateCell(CalendarDayCell)
            - ScheduleList

      [How to ADD Sche]
        Add DateBuffer the Sche
          DateBuffer makes ScheduleSet for each day that depends on the given Sche
        ScheduleList foreach DateCell will automaticly read ScheduleSets and generate

      [How to REMOVE Sche]
        Remove Sche from DateBuffer
	  DateBuffer will delete Sche from ScheduleSet that depends on the given Sche
        Refresh the Dates(CalendarControl)
          All DateCells will be refreshed, and the ScheduleList will re-read ScheduleSets

      [How to SELECT Sche]
        Set m_aoSelected that includes selected sches
        Refresh the Datas(CalendarControl)

      [How to UNSELECT Sche]
        Clear m_aoSelected
        Refresh the Datas(CalendarControl)

    */

    private JPanel m_oMain;
    private Dates m_oDates;
    private ScrollBar m_oScrollBar;
    static private int s_nRows = 7;
    private DateBuffer m_oBuffer;
    private Set<Sche> m_aoSelected;
    static private boolean s_isUnselectExceptIterating = false;
    static private boolean s_isSelected = false;
    private ToolBar m_oTB;
    private String m_sToday;
    
    Calendar(SwingInterface _oI,Kernel _oKernel,MDI _oMDI){
	super(_oKernel,_oI,_oMDI);
	m_oMain = new JPanel(new BorderLayout());
	m_oBuffer = new DateBuffer();
    }
    public void set(){
	m_oScrollBar = new ScrollBar();
	m_oScrollBar.setOrientation(JScrollBar.VERTICAL);
	m_oMain.add(m_oScrollBar,BorderLayout.EAST);
	m_oDates = new Dates();
	m_oMain.add(m_oDates,BorderLayout.CENTER);
	m_oMain.add(new NowTimeDisplay(),BorderLayout.SOUTH);
	DBSetChecker _oDBSC = new DBSetChecker();
	m_oI.addDBSetListener(_oDBSC);
	m_oTB = new ToolBar();
	m_oMain.add(m_oTB,BorderLayout.NORTH);
	m_aoSelected = new HashSet<Sche>();
	m_oMain.setVisible(false);
    }
    public void refreshForce(){}
    class ScrollBar extends JScrollBar{
	private boolean m_isResettedByMouse,m_isBaseDateSet;
	private int m_nErrorFromBase;

	ScrollBar(){
	    setMaximum(s_nRows*3);
	    setMinimum(0);
	    setVisibleAmount(s_nRows);
	    resetPos();
	    addAdjustmentListener(new ScrollBarChangeListener());
	    addMouseListener(new MouseChangeListener());
	    m_isResettedByMouse = m_isBaseDateSet = false;
	    setBaseDate();
	}
	public void setBaseDate(){
	    m_nErrorFromBase = s_nRows;
	}
	private void resetPos(){
	    setBaseDate();
	    setValue(s_nRows);
	}
	private void setPos(){
	    if(m_isResettedByMouse){
		if(!m_isBaseDateSet){
		    setBaseDate();
		    m_isBaseDateSet = true;
		}
		int _nNowPos = getValue();
		int _nDiffPos = _nNowPos-m_nErrorFromBase;
		if(_nDiffPos > 0){
		    while(_nDiffPos > 0){
			m_oDates.rowDown();
			_nDiffPos--;
		    }
		}else if(_nDiffPos < 0){
		    while(_nDiffPos < 0){
			m_oDates.rowUp();
			_nDiffPos++;
		    }
		}
		m_nErrorFromBase = _nNowPos;
	    }else{
		m_isResettedByMouse = false;
		m_isBaseDateSet = false;
	    }
	}
	class ScrollBarChangeListener implements AdjustmentListener{
	    public void adjustmentValueChanged(AdjustmentEvent e){
		setPos();
	    }
	}
	class MouseChangeListener extends MouseAdapter{
	    public void mouseReleased(MouseEvent e){
		m_isResettedByMouse = true;
		resetPos();
	    }
	}
    }
    class ToolBar extends JToolBar{
	private JCheckBox m_oCB;
	private boolean m_isChecked;
	
	ToolBar(){
	    m_oCB = new JCheckBox("Show palette",true);
	    m_oCB.addItemListener(new CheckBoxChecker(m_oCB));
	    add(m_oCB);
	    m_isChecked = false;
	}
	public boolean isShowingPalette(){
	    return m_isChecked;
	}
	class CheckBoxChecker implements ItemListener{
	    private JCheckBox m_oParent;
	    
	    CheckBoxChecker(JCheckBox _oParent){
		m_oParent = _oParent;
	    }
	    public void itemStateChanged(ItemEvent e){
		if(m_oParent == e.getSource()){
		    if(e.getStateChange() == ItemEvent.SELECTED){
			m_isChecked = true;
		    }else{
			m_isChecked = false;
		    }
		    m_oDates.refresh();
		}
	    }
	}
    }
    public JComponent panel(){
	return m_oMain;
    }
    public String type(){
	return "calendar";
    }
    public Calendar oThis(){
	return this;
    }
    public DateBuffer getDateBuffer(){
	return m_oBuffer;
    }
    class Dates extends CalendarControl{
	Dates(){
	    super();
	    setRowNumber(s_nRows);
	    setDayTemplateCell(new DateCell());
	    setWeekTemplateCell(new WeekCell());
	    generate();
	}
	public void refreshCellAt(Date _oD){
	    DateCell _oCDC = (DateCell)getCellFromBuffer(_oD);
	    if(_oCDC != null){
		_oCDC.refresh();
	    }
	}
	public void unselectAll(){
	    Iterator _i = m_oBuffer.keySet().iterator();
	    while(_i.hasNext()){
		String _sDateIt = (String)_i.next();
		DateCell _oCDC = (DateCell)m_oBuffer.get(_sDateIt);
		_oCDC.unselectAll();
	    }
	}
	public void unselectExceptCellAt(Date _oD){
	    unselectExceptCellAt(getDateBuffer().format(_oD));
	}
	public void unselectExceptCellAt(String _sDate){
	    if(!s_isUnselectExceptIterating){
		Iterator _i = m_oBuffer.keySet().iterator();
		s_isUnselectExceptIterating = true;
		while(_i.hasNext()){
		    String _sDateIt = (String)_i.next();
		    if(_sDate.equals(_sDateIt)){
			continue;
		    }
		    DateCell _oCDC = (DateCell)m_oBuffer.get(_sDateIt);
		    _oCDC.unselectAll();
		}
		s_isUnselectExceptIterating = false;
	    }
	}
	public void setCalledFromOuter(boolean _isCa){
	    Iterator _i = m_oBuffer.keySet().iterator();
	    while(_i.hasNext()){
		DateCell _oCDC = (DateCell)m_oBuffer.get((String)_i.next());
		_oCDC.setCalledFromOuter(_isCa);
	    }
	}
    }
    class DateCell extends CalendarDayCell{
	private SimpleDateFormat m_oSDF;
	private ScheduleList m_oSL;
	private JButton m_oDateDisp;
	private JPopupMenu m_oMenu;

	DateCell(){
	    super();
	    m_oSDF = new SimpleDateFormat("d");
	    m_oDateDisp = new JButton();
	    m_oDateDisp.setHorizontalAlignment(SwingConstants.LEADING);
	    m_oDateDisp.setVerticalAlignment(SwingConstants.TOP);
	    m_oSL = new ScheduleList();
	}
	public void setDate(Date _oD){
	    super.setDate(_oD);
	    m_oDateDisp.setText(m_oSDF.format(_oD));
	    add(m_oDateDisp,BorderLayout.NORTH);
	    JScrollPane _oSP = new JScrollPane(m_oSL);
	    _oSP.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
	    add(_oSP,BorderLayout.CENTER);
	    setVisible(true);
	    m_oDateDisp.addMouseListener(new ButtonClickedChecker());
	    if(isToday()){
		m_oDateDisp.setBackground(Color.yellow);
	    }
	    m_oMenu = new JPopupMenu();
	    m_oMenu.add(new ActionSetDayAndJumpToPicker());
	}
	public void refresh(){
	    m_oSL.refresh(getDate());
	}
	public void unselectAll(){
	    m_oSL.unselectAll();
	}
	public DateCell clone(){
	    return new DateCell();
	}
	class ButtonClickedChecker extends MouseAdapter{
	    public void mouseClicked(MouseEvent e){
		if(SwingUtilities.isRightMouseButton(e)){
		    m_oMenu.show(e.getComponent(),
				 e.getX(),
				 e.getY());
		}else{
		    showSelectedDate();
		}
	    }
	}
	class ActionSetDayAndJumpToPicker extends AbstractAction{
	    ActionSetDayAndJumpToPicker(){
		super("Show this day by picker");
	    }
	    public void actionPerformed(ActionEvent e){
		showSelectedDate();
	    }
	}
	public void setCalledFromOuter(boolean _isC){
	    m_oSL.setCalledFromOuter(_isC);
	}
	private void showSelectedDate(){
	    DisplayBoundsEvent _oDBE = new DisplayBoundsEvent(this);
	    _oDBE.setBegin(getDate());
	    _oDBE.setEnd(getEndDate());
	    m_oI.sendDisplayBoundsListener(_oDBE);
	    m_oI.sendWindowShowListener(new WindowShowEvent(this,"Picker"));
	}
    }
    class WeekCell extends CalendarWeekCell{
	private JButton m_oDateDisp;
	private JPopupMenu m_oMenu;

	WeekCell(){
	    super();
	    m_oDateDisp = new JButton();
	    m_oDateDisp.setHorizontalAlignment(SwingConstants.LEADING);
	    m_oDateDisp.setVerticalAlignment(SwingConstants.TOP);
	}
	public void setDate(Date _oD){
	    super.setDate(_oD);
	    int _nNum = CalendarUtil.getNumberOfWeek(_oD);
	    m_oDateDisp.setText("#"+new Integer(_nNum).toString());
	    add(m_oDateDisp,BorderLayout.CENTER);
	    m_oDateDisp.addMouseListener(new ButtonClickedChecker());
	    m_oMenu = new JPopupMenu();
	    m_oMenu.add(new ActionSetWeekAndJumpToPicker());
	}
	public void refresh(){
	}
	public void unselectAll(){
	}
	public WeekCell clone(){
	    return new WeekCell();
	}
	class ButtonClickedChecker extends MouseAdapter{
	    public void mouseClicked(MouseEvent e){
		if(SwingUtilities.isRightMouseButton(e)){
		    m_oMenu.show(e.getComponent(),
				 e.getX(),
				 e.getY());
		}else{
		    showSelectedDate();
		}
	    }
	}
	class ActionSetWeekAndJumpToPicker extends AbstractAction{
	    ActionSetWeekAndJumpToPicker(){
		super("Show this week by picker");
	    }
	    public void actionPerformed(ActionEvent e){
		showSelectedDate();
	    }
	}
	private void showSelectedDate(){
	    DisplayBoundsEvent _oDBE = new DisplayBoundsEvent(this);
	    _oDBE.setBegin(getDate());
	    _oDBE.setEnd(getEndDate());
	    m_oI.sendDisplayBoundsListener(_oDBE);
	    m_oI.sendWindowShowListener(new WindowShowEvent(this,"Picker"));
	}
    }
    class ScheduleList extends JList{
	private AbstractList<Sche> m_oL;
	private DefaultListModel m_oModel;
	private SimpleDateFormat m_oSDF;
	private boolean m_isCalledFromOuter;
	private Date m_oDate;

	ScheduleList(){
	    m_oSDF = new SimpleDateFormat("HH:mm");
	    m_oModel = new DefaultListModel();
	    setModel(m_oModel);
	    m_oL = new Vector<Sche>();
	    addListSelectionListener(new ListSelectionChecker());
	    m_isCalledFromOuter = false;
	    setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
	    ThisCellRenderer _oTCR = new ThisCellRenderer();
	    setCellRenderer(_oTCR);
	}
	public void refresh(){
	    refresh(m_oDate);
	}
	public void refresh(Date _oD){
	    m_oDate = _oD;
	    ScheduleSet _oSet = m_oBuffer.getScheduleAt(_oD);
	    Iterator _i = _oSet.keyIterator();
	    while(_i.hasNext()){
		Sche _oS = (Sche)_i.next();
		if(!m_oL.contains(_oS) && needDisplay(_oS)){
		    ScheRegisteredStatusEnum _oSRSE = _oSet.statusOf(_oS);
		    add(_oS,_oSRSE);
		}
	    }
	    _i = m_oL.iterator();
	    Set<Sche> _oRemoving = new HashSet<Sche>();
	    while(_i.hasNext()){
		Sche _oS = (Sche)_i.next();
		if(!_oSet.contains(_oS) || !needDisplay(_oS)){
		    _oRemoving.add(_oS);
		}
	    }
	    _i = _oRemoving.iterator();
	    while(_i.hasNext()){
		Sche _oS = (Sche)_i.next();
		remove(_oS);
	    }
	    clearSelection();
	    int _nRows = m_oModel.getSize();
	    int _nIt;
	    for(_nIt=0;_nIt<_nRows;_nIt++){
		if(_nIt >= m_oL.size()){
		    break;
		}
		Sche _oS = m_oL.get(_nIt);
		if(m_aoSelected.contains(_oS)){
		    addSelectionInterval(_nIt,_nIt);
		}
	    }
	}
	private boolean needDisplay(Sche _oS){
	    return ((!m_oTB.isShowingPalette() && !m_oKernel.getDBSet().typeOf(_oS).equals("palette"))||
		    (m_oTB.isShowingPalette()));
	}
	class ThisCellRenderer extends JLabel implements ListCellRenderer{
	    ThisCellRenderer(){
		setOpaque(true);
	    }
	    public Component getListCellRendererComponent(JList _oList,
							  Object _oValue,
							  int _nPos,
							  boolean _isSelected,
							  boolean _hasFocus){
		String _sValue = _oValue.toString();
		setText(_sValue);
		if(_nPos < m_oL.size()){
		    Sche _oS = m_oL.get(_nPos);
		    if(m_oKernel.getDBSet().typeOf(_oS).equals("palette")){
			if(_isSelected){
			    setForeground(Color.white);
			    setBackground(Color.gray);
			}else{
			    setBackground(Color.white);
			    setForeground(Color.gray);
			}
		    }else{
			if(_isSelected){
			    setForeground(Color.white);
			    setBackground(Color.black);
			}else{
			    setBackground(Color.white);
			    setForeground(Color.black);
			}
		    }
		}
		return this;
	    }
	}
	public void add(Sche _oS,ScheRegisteredStatusEnum _oSRSE){
	    if(!m_oL.contains(_oS)){
		String _sFormatted = format(_oS,_oSRSE);
		m_oModel.addElement(format(_oS,_oSRSE));
		m_oL.add(_oS);
	    }
	}
	public void remove(Sche _oS){
	    int _nPos = m_oL.indexOf(_oS);
	    m_oModel.removeElementAt(_nPos);
	    m_oL.remove(_oS);
	}
	private String format(Sche _oS,ScheRegisteredStatusEnum _oSRSE){
	    Changeable _oC = _oS.changeables().get(0);
	    String _sTitle = _oC.title();
	    String _sTimeRangeBegin = "";
	    String _sTimeRangeEnd = "";
	    switch(_oSRSE){
	    case BEGIN:
		_sTimeRangeBegin = m_oSDF.format(_oC.time().begin());
		break;
	    case END:
		_sTimeRangeEnd = m_oSDF.format(_oC.time().end());
		break;
	    case BEGIN_AND_END:
		_sTimeRangeBegin = m_oSDF.format(_oC.time().begin());
		_sTimeRangeEnd = m_oSDF.format(_oC.time().end());
	    default:
		break;
	    }
	    return _sTimeRangeBegin+"-"+_sTimeRangeEnd+" "+_sTitle;
	}
	synchronized public void select(){
	    if(!m_isCalledFromOuter){
		boolean _isSelected = false;
		int[] _aoIndices = getSelectedIndices();
		for(int _nI=0;_nI<_aoIndices.length;_nI++){
		    if(_aoIndices[_nI] >= m_oL.size()){
			continue;
		    }
		    _isSelected = true;
		    Sche _oS = m_oL.get(_aoIndices[_nI]);
		    ScheduleSet _oSS = m_oBuffer.getScheduleAt(m_oDate);
		    m_oBuffer.selectSche(_oS,m_oDate);
		}
	    }
	}
	synchronized public void unselectExceptMe(){
	    m_oBuffer.unselectExcept(m_oDate);
	}
	public void unselectAll(){
	    clearSelection();
	}
	public void setCalledFromOuter(boolean _isCa){
	    m_isCalledFromOuter = _isCa;
	}
	private ScheduleList oSLThis(){
	    return this;
	}
	private void selectFromMe(){
	    if(m_oDates.isRefreshed()){
		unselectExceptMe();
		select();
		generateQueryAndSend();
	    }
	}
	synchronized private void generateQueryAndSend(){
	    StringBuffer _sCMD = new StringBuffer("select");
	    Iterator _i = m_aoSelected.iterator();
	    if(!_i.hasNext()){
		return;
	    }
	    while(_i.hasNext()){
		Sche _oS = (Sche)_i.next();
		String _sID = _oS.ID();
		String _sPath = m_oI.oKernel().getDBSet().pathOf(_sID);
		_sCMD.append(" "+_sPath);
	    }
	    m_oKernel.execQuery(new String(_sCMD),oThis());
	}
	class ListSelectionChecker implements ListSelectionListener{
	    public void valueChanged(ListSelectionEvent _oEv){
		if(oSLThis() == _oEv.getSource() && !_oEv.getValueIsAdjusting()){
		    select();
		}
	    }
	    private void select(){
		if(!s_isSelected){
		    s_isSelected = true;
		    selectFromMe();
		    s_isSelected = false;
		}
	    }
	}
    }
    class NowTimeDisplay extends JLabel{
	private Date m_oNow;
	private SimpleDateFormat m_oSDF;

	NowTimeDisplay(){
	    m_oSDF = new SimpleDateFormat("yyyy/M/d H:mm:ss");
	    setHorizontalAlignment(SwingConstants.RIGHT);
	    refreshTime();
	    refresh();
	}
	private void refreshTime(){
	    m_oNow = new Date();
	}
	private void refresh(){
	    setText(m_oSDF.format(m_oNow));
	}
    }
    class DateBuffer{
	private Map<String,ScheduleSet> m_oMap;
	private SimpleDateFormat m_oSDFForKey;
	
	DateBuffer(){
	    m_oSDFForKey = new SimpleDateFormat("yyyy-MM-d");
	    m_oMap = new HashMap<String,ScheduleSet>();
	}
	synchronized public void addSche(Sche _oS){
	    String _sBegin = format(_oS.changeables().get(0).time().begin());
	    String _sEnd = format(_oS.changeables().get(0).time().end());
	    if(_sBegin == null && _sEnd == null){
		return;
	    }
	    if(_sBegin != null && _sEnd != null){
		if(_sBegin.equals(_sEnd)){
		    ScheduleSet _oSS = getScheduleAt(_sBegin);
		    _oSS.addSche(_oS,ScheRegisteredStatusEnum.BEGIN_AND_END);
		}else{
		    ScheduleSet _oSSB = getScheduleAt(_sBegin);
		    _oSSB.addSche(_oS,ScheRegisteredStatusEnum.BEGIN);
		    ScheduleSet _oSSE = getScheduleAt(_sEnd);
		    _oSSE.addSche(_oS,ScheRegisteredStatusEnum.END);
		}
	    }else if(_sBegin == null){
		ScheduleSet _oSS = getScheduleAt(_sEnd);
		_oSS.addSche(_oS,ScheRegisteredStatusEnum.END);
	    }else{
		ScheduleSet _oSS = getScheduleAt(_sBegin);
		_oSS.addSche(_oS,ScheRegisteredStatusEnum.BEGIN);
	    }
	    m_oDates.refresh();
	}
	public void remove(){
	    Iterator _i = m_aoSelected.iterator();
	    while(_i.hasNext()){
		Sche _oS = (Sche)_i.next();
		removeSche(_oS);
	    }
	    m_oDates.refresh();
	}
	synchronized private void removeSche(Sche _oS){
	    Iterator _i = m_oMap.keySet().iterator();
	    while(_i.hasNext()){
		ScheduleSet _oSS = m_oMap.get((String)_i.next());
		_oSS.removeSche(_oS);
	    }
	}
	synchronized public void selectSche(Sche _oS){
	    selectSche(_oS,false);
	}
	synchronized public void selectSche(Sche _oS,boolean _isAdd){
	    selectSche(_oS,null,_isAdd);
	}
	synchronized public void selectSche(Sche _oS,Date _oD){
	    selectSche(_oS,_oD,false);
	}
	synchronized public void selectSche(Sche _oS,Date _oD,boolean _isAdd){
	    if(!_isAdd){
		clearSelection();
	    }
	    m_aoSelected.add(_oS);
	    if(!_isAdd){
		if(_oD != null){
		    unselectExcept(_oD);
		}else{
		    unselectAll();
		}
	    }
	    m_oDates.refresh();
	}
	synchronized public void unselectAll(){
	    m_oDates.unselectAll();
	}
	synchronized public void unselectExcept(Date _oD){
	    unselectExcept(format(_oD));
	}
	synchronized public void clearSelection(){
	    m_aoSelected.clear();
	}
	synchronized public void unselectExcept(String _sDateKey){
	    if(_sDateKey == null){
		return;
	    }
	    ScheduleSet _oSS = m_oMap.get(_sDateKey);
	    if(_oSS == null){
		return;
	    }
	    m_oDates.unselectExceptCellAt(_sDateKey);
	}
	private void makeNewDateSet(Date _oD){
	    makeNewDateSet(format(_oD));
	}
	private void makeNewDateSet(String _sDateKey){
	    if(_sDateKey == null){
		return;
	    }
	    if(!m_oMap.containsKey(_sDateKey)){
		ScheduleSet _oS = new ScheduleSet(parse(_sDateKey));
		m_oMap.put(_sDateKey,_oS);
	    }
	}
	public String format(Date _oD){
	    if(_oD == null){
		return null;
	    }
	    return m_oSDFForKey.format(_oD);
	}
	public Date parse(String _sQ){
	    if(_sQ == null){
		return null;
	    }
	    try{
		return m_oSDFForKey.parse(_sQ);
	    }catch(ParseException e){
		e.printStackTrace();
	    }
	    return null;
	}
	private ScheduleSet getScheduleAt(Date _oD){
	    return getScheduleAt(format(_oD));
	}
	private ScheduleSet getScheduleAt(String _sD){
	    makeNewDateSet(_sD);
	    return m_oMap.get(_sD);
	}
	public void refresh(){
	    m_oDates.refresh();
	}
    }
    class ScheduleSet{
	private Map<Sche,ScheRegisteredStatusEnum> m_oR;
	private Date m_oDate;
	
	ScheduleSet(Date _oDate){
	    m_oDate = _oDate;
	    m_oR = new HashMap<Sche,ScheRegisteredStatusEnum>();
	}
	public void addSche(Sche _oS,ScheRegisteredStatusEnum _oR){
	    m_oR.put(_oS,_oR);
	    m_oDates.refresh();
	}
	public void removeSche(Sche _oS){
	    m_oR.remove(_oS);
	    m_oDates.refresh();
	}
	public ScheRegisteredStatusEnum statusOf(Sche _oS){
	    return m_oR.get(_oS);
	}
	public boolean contains(Sche _oS){
	    return m_oR.containsKey(_oS);
	}
	public Iterator keyIterator(){
	    return m_oR.keySet().iterator();
	}
    }
    enum ScheRegisteredStatusEnum{
	BEGIN,
	END,
	BEGIN_AND_END
    }
    class DBSetChecker extends DBSetAdapter{
	synchronized public void add(DBSetEvent _oEv){
	    if(_oEv == null ||
	       _oEv.getSelectionMap() == null ||
	       _oEv.getSelectionMap().isAlreadyChanged(oThis())
	       ){return;}
	    Iterator _i = _oEv.getSelectionMap().sches().iterator();
	    while(_i.hasNext()){
		m_oBuffer.addSche((Sche)_i.next());
	    }
	}
	public void remove(DBSetEvent _oEv){
	    if(_oEv == null){
		return;
	    }
	    m_oBuffer.remove();
	}
	public void select(DBSetEvent _oEv){
	    Iterator _i = _oEv.getSelectionMap().sches().iterator();
	    m_oDates.setCalledFromOuter(true);
	    m_oBuffer.clearSelection();
	    m_oBuffer.unselectAll();
	    while(_i.hasNext()){
		m_oBuffer.selectSche((Sche)_i.next(),true);
	    }
	    m_oDates.setCalledFromOuter(false);
	}
	public void unselect(DBSetEvent _oEv){
	    if(_oEv == null){
		return;
	    }
	    m_oBuffer.unselectAll();
	}
	public void move(DBSetEvent _oEv){
	    m_oBuffer.refresh();
	}
    }
}
