package xor.main.swing;

import java.util.*;
import java.text.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.*;
import java.awt.*;
import xor.main.*;
import xor.sche.*;

public class Detail extends Inside{
    private JTabbedPane m_oTab;
    private AbstractList<Sche> m_aoSches;
    private Map<Sche,SchePanel> m_oPanelBuffer;
    private boolean m_isCalledFromOuter;
    private boolean m_isCalledAsSelection;
    
    Detail(SwingInterface _oI,Kernel _oKernel,MDI _oMDI){
	super(_oKernel,_oI,_oMDI);
	m_oTab = new JTabbedPane();
	m_oTab.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);
	m_oPanelBuffer = new HashMap<Sche,SchePanel>();
	m_oTab.addChangeListener(new TabClickChecker());
	m_isCalledFromOuter = m_isCalledAsSelection = false;
    }
    public void set(){
	m_aoSches = new Vector<Sche>();
	m_oTab.setVisible(true);
	m_oI.addDBSetListener(new DBSetChecker());
    }
    public JTabbedPane panel(){
	return m_oTab;
    }
    private void changeScheForOuterRequest(Sche _oS){
	m_isCalledFromOuter = true;
	bringThisTabToTop(_oS);
	m_isCalledFromOuter = false;
    }
    private void changeScheForInnerRequest(Sche _oS){
	if(!m_isCalledFromOuter || m_isCalledAsSelection){
	    sendSelectionChange(_oS);
	}
    }
    public void refreshForce(){}
    synchronized private void addSche(Sche _oS){
	addThisScheToBuffer(_oS);
	addThisScheAsTab(_oS);
    }
    synchronized private void removeSelected(){
	int _nI = m_oTab.getSelectedIndex();
	m_oTab.removeTabAt(_nI);
	Sche _oS = m_aoSches.get(_nI);
	m_oPanelBuffer.remove(_oS);
	m_aoSches.remove(_nI);
    }
    synchronized private void updateSche(Sche _oS){
	updateTabName(_oS);
	m_oPanelBuffer.get(_oS).update(_oS);
    }
    private void updateTabName(Sche _oS){
	int _n = m_aoSches.indexOf(_oS);
	m_oTab.setTitleAt(_n,_oS.changeables().get(0).title());
    }
    synchronized private void sendSelectionChange(Sche _oS){
	if(!m_isCalledFromOuter){
	    String _sPath = m_oI.oKernel().getDBSet().pathOf(_oS);
	    SelectionMap _oSM = null;
	    m_oI.oKernel().execQuery("select "+_sPath,_oSM,oThis());
	}
    }
    synchronized private void addThisScheToBuffer(Sche _oS){
	if(!m_oPanelBuffer.containsKey(_oS)){
	    SchePanel _oSSP = new SchePanel(_oS);
	    m_oPanelBuffer.put(_oS,_oSSP);
	}
    }
    synchronized private void addThisScheAsTab(Sche _oS){
	if(!m_aoSches.contains(_oS)){
	    m_aoSches.add(0,_oS); 
	}
	SchePanel _oSSP = m_oPanelBuffer.get(_oS);
	String _sTitle = _oS.changeables().get(0).title();
	m_oTab.insertTab(_sTitle,
			 null,
			 _oSSP,
			 null,
			 0
			 );
    }
    synchronized private void bringThisTabToTop(Sche _oS){
	if(m_aoSches.contains(_oS)){
	    if(m_oTab.getTabCount() == 1){
		return;
	    }
	    int _nPos = m_aoSches.indexOf(_oS);
	    m_aoSches.remove(_oS);
	    m_oTab.remove(_nPos);
	}
	addThisScheAsTab(_oS);
	m_isCalledAsSelection = true;
	m_oTab.setSelectedIndex(0);
	m_isCalledAsSelection = false;
    }
    public String type(){
	return "detail";
    }
    public Detail oThis(){
	return this;
    }
    abstract class AbstractSchePanel extends JPanel{
	AbstractSchePanel(){
	    super(new BorderLayout());
	}
	abstract public void update(Sche _oS);
    }
    class TabClickChecker implements ChangeListener{
	synchronized public void stateChanged(ChangeEvent e){
	    JTabbedPane _oThis = (JTabbedPane)e.getSource();
	    int _nSelected = _oThis.getSelectedIndex();
	    if(_nSelected == -1){return;}
	    Sche _oS = m_aoSches.get(_nSelected);
	    changeScheForInnerRequest(_oS);
	}
    }
    class SchePanelWithRevision extends AbstractSchePanel{
	private JSplitPane m_oJSP;
	private ScheRevisionSelecter m_oSRS;
	private ScheDetailPanel m_oSDP;
	private AbstractList<Changeable> m_aoChangeables;

	SchePanelWithRevision(Sche _oS){
	    m_oJSP = new JSplitPane();
	    m_oJSP.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
	    add(m_oJSP,BorderLayout.CENTER);
	    m_aoChangeables = _oS.changeables();
	    m_oSRS = new ScheRevisionSelecter();
	    m_oJSP.setLeftComponent(m_oSRS);
	    setChangeableTo(_oS.changeables().get(0));
	}
	private void setChangeableTo(Changeable _oC){
	    m_oSDP = new ScheDetailPanel(_oC);
	    m_oJSP.setRightComponent(m_oSDP);
	}
	public void update(Sche _oS){
	    m_oSDP.update();
	    m_aoChangeables = _oS.changeables();
	    m_oSRS.update();
	}
	class ScheRevisionSelecter extends JPanel{
	    private AbstractList<Changeable> m_oChangeables;
	    private JList m_oList;
	    private DefaultListModel m_oLModel;
	    private boolean m_isUpdating;
	    
	    ScheRevisionSelecter(){
		super(new BorderLayout());
		m_oLModel = new DefaultListModel();
		m_oChangeables = m_aoChangeables;
		m_oList = new JList(m_oLModel);
		JScrollPane _oJSP = new JScrollPane(m_oList);
		add(_oJSP,BorderLayout.CENTER);
		m_oList.addListSelectionListener(new SelectionChecker());
		m_isUpdating = false;
		addRevisions();
	    }
	    synchronized public void update(){
		m_oChangeables = m_aoChangeables;
		m_isUpdating = true;
		addRevisions();
		removeAll();
		JScrollPane _oJSP = new JScrollPane(m_oList);
		add(_oJSP,BorderLayout.CENTER);
		repaint();
		m_isUpdating = false;
	    }
	    public void addRevisions(){	
		SimpleDateFormat _oSDF = new SimpleDateFormat("MM/dd");
		m_oLModel.clear();
		Iterator _i = m_oChangeables.iterator();
		while(_i.hasNext()){
		    Changeable _oC = (Changeable)_i.next();
		    Date _oModified = _oC.modified();
		    String _sDate = _oSDF.format(_oModified);
		    m_oLModel.addElement(_sDate);
		}
		m_oList.setSelectedIndex(0);
	    }
	    class SelectionChecker implements ListSelectionListener{
		public void valueChanged(ListSelectionEvent e){
		    JList _oSource = (JList)e.getSource();
		    if(e.getValueIsAdjusting() == false &&
		       !m_isUpdating
		       ){
			setChangeableTo(m_oChangeables.get(_oSource.getSelectedIndex()));
		    }
		}
	    }
	}
    }
    class SchePanelWithoutRevision extends AbstractSchePanel{
	private ScheDetailPanel m_oSDP;
	
	SchePanelWithoutRevision(Changeable _oC){
	    m_oSDP = new ScheDetailPanel(_oC);
	    add(m_oSDP,BorderLayout.CENTER);
	}
	public void update(Sche _oS){
	    m_oSDP.update();
	}
    }
    class SchePanel extends JPanel{
	private AbstractSchePanel m_oASP;
	
	SchePanel(Sche _oS){
	    super(new BorderLayout());
	    if(_oS.changeables().size() == 1){
		m_oASP = new SchePanelWithoutRevision(_oS.changeables().get(0));
	    }else{
		m_oASP = new SchePanelWithRevision(_oS);
	    }
	    add(m_oASP,BorderLayout.CENTER);
	    setVisible(true);
	}
	public void update(Sche _oS){
	    m_oASP.update(_oS);
	}
    }
    class ScheDetailPanel extends JPanel{
	private ContentPanel m_oCP;

	ScheDetailPanel(Changeable _oC){
	    super(new BorderLayout());
	    HeaderPanel _oHP = new HeaderPanel(_oC);
	    add(_oHP,BorderLayout.NORTH);
	    JScrollPane _oJSP = new JScrollPane(new MainPanel(_oC));
	    m_oCP = new ContentPanel(_oC);
	    ContentPanels _oCPs = new ContentPanels(_oJSP,m_oCP);
	    add(_oCPs,BorderLayout.CENTER);
	}
	public void update(){}
	class HeaderPanel extends JLabel{
	    HeaderPanel(Changeable _oC){
		super();
		setHorizontalAlignment(SwingConstants.LEFT);
		Date _oModified = _oC.modified();
		SimpleDateFormat _oSDF = new SimpleDateFormat("yyyy/MM/dd HH:mm");
		String _sModified = _oSDF.format(_oModified);
		setText("Modified : "+_sModified);
	    }
	}
	class ContentPanels extends JSplitPane{
	    ContentPanels(JComponent _oMain,JComponent _oSub){
		super(JSplitPane.VERTICAL_SPLIT);
		setTopComponent(_oMain);
		setBottomComponent(_oSub);
		setDividerLocation(100);
		setOneTouchExpandable(true);
	    }
	}
	class ContentPanel extends JPanel{
	    private AbstractSingleContentWinPanel m_oTA;
	    private JLabel m_oLa;
	    private Changeable m_oC;

	    ContentPanel(Changeable _oC){
		super(new BorderLayout());
		m_oC = _oC;
		m_oLa = new JLabel("Title of the showing component comes here.");
		add(m_oLa,BorderLayout.NORTH);
		findDefaultContentToShow(_oC);
	    }
	    public void setContent(String _sTitle){
		AbstractSingleContentWinPanel _oTABefore = m_oTA;
		ContentWinPanelFactory _oCWPF = new ContentWinPanelFactory();
		m_oTA = _oCWPF.get(_sTitle,getContentFor(_sTitle));
		if(_oTABefore != null){
		    remove(_oTABefore);
		}
		if(m_oTA != null){
		    add(m_oTA,BorderLayout.CENTER);
		}
		m_oLa.setText(_sTitle);
		repaint();
	    }
	    public Object getContentFor(String _sTitle){
		if(_sTitle.equals("Title")){
		    return m_oC.title();
		}else if(_sTitle.equals("Subtitle")){
		    return m_oC.subtitle();
		}else if(_sTitle.equals("Summary")){
		    return m_oC.summary();
		}else if(_sTitle.equals("Content")){
		    return m_oC.content();
		}else if(_sTitle.equals("Location")){
		    return m_oC.location();
		}else if(_sTitle.equals("Begin time")){
		    if(m_oC.time() != null){
			return m_oC.time().begin();
		    }
		}else if(_sTitle.equals("End time")){
		    if(m_oC.time() != null){
			return m_oC.time().end();
		    }
		}else if(_sTitle.equals("Author")){
		    return m_oC.author();
		}
		return null;
	    }
	    public void findDefaultContentToShow(Changeable _oC){
		if(_oC.content() != null){
		    setContent("Content");
		}
	    }
	    class ContentWinPanelFactory{
		ContentWinPanelFactory(){}
		public AbstractSingleContentWinPanel get(String _sType,Object _oTarg){
		    if(_sType == null){
			return null;
		    }else if(_sType.equals("Title") || _sType.equals("Subtitle")){
			return new SingleRowTextWinPanel((String)_oTarg);
		    }else if(_sType.equals("Summary")){
			return new MultiRowTextWinPanel((String)_oTarg);
		    }else if(_sType.equals("Content") && ((AbstractContent)_oTarg).contentType().equals("plaintext")){
			return new MultiRowTextWinPanel(((ContentPlainText)_oTarg).toString());
		    }else if(_sType.equals("Author")){
			return new AuthorWinPanel((Author)_oTarg);
		    }
		    return null;
		}
	    }
	    abstract class AbstractSingleContentWinPanel extends JPanel{
		AbstractSingleContentWinPanel(){
		    super(new BorderLayout());
		}
	    }
	    class SingleRowTextWinPanel extends AbstractSingleContentWinPanel{
		SingleRowTextWinPanel(String _sInside){
		    super();
		    JTextField _oTF = new JTextField(_sInside);
		    _oTF.setEditable(false);
		    add(_oTF,BorderLayout.NORTH);
		}
	    }
	    class MultiRowTextWinPanel extends AbstractSingleContentWinPanel{
		MultiRowTextWinPanel(String _sInside){
		    super();
		    JTextArea _oTA = new JTextArea(_sInside);
		    _oTA.setEditable(false);
		    _oTA.setLineWrap(true);
		    JScrollPane _oJSP = new JScrollPane();
		    JViewport _oVP = _oJSP.getViewport();
		    _oVP.setView(_oTA);
		    _oJSP.setViewport(_oVP);
		    add(_oJSP,BorderLayout.CENTER);
		}
	    }
	    class AuthorWinPanel extends AbstractSingleContentWinPanel{
		AuthorWinPanel(Author _oA){
		    JLabel _oJL = new JLabel();
		    String _sHTMLInside = "<html><dl><dt>Name</dt><dd>"+_oA.name()+"</dd>";
		    if(_oA.email() != null){
			String _sEmailAdd = _oA.email();
			_sHTMLInside = _sHTMLInside+"<dt>Email</dt><dd><a href=\""+_sEmailAdd+"\">"+_sEmailAdd+"</a></dd>";
		    }
		    if(_oA.uri() != null){
			String _sURIAdd = _oA.uri().toString();
			_sHTMLInside = _sHTMLInside+"<dt>Website URL</dt><dd><a href=\""+_sURIAdd+"\">"+_sURIAdd+"</a></dd>";
		    }
		    _oJL.setText(_sHTMLInside);
		    JScrollPane _oJSP = new JScrollPane(_oJL);
		    add(_oJSP,BorderLayout.NORTH);
		}
	    }
	}
	class MainPanel extends JTable{
	    private Changeable m_oC;
	    private TableModel m_oTableModel;
	    
	    MainPanel(Changeable _oC){
		m_oC = _oC;
		Object[] _oTitle = {"Key","Value"};
		m_oTableModel = new TableModel(_oTitle);
		setModel(m_oTableModel);
		setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		refresh();
	    }
	    private void refresh(){
		addTitle();
		addSubtitle();
		addTime();
		addLocation();
		addSummary();
		addContent();
		addAuthor();
	    }
	    public void valueChanged(ListSelectionEvent _oLSE){
		super.valueChanged(_oLSE);
		if(_oLSE.getValueIsAdjusting()){
		    return;
		}
		int _nSRow = getSelectedRow();
		m_oCP.setContent((String)getValueAt(_nSRow,0));
	    }
	    private void addTitle(){
		Object[] _oRow = {"Title",m_oC.title()};
		m_oTableModel.addRow(_oRow);
	    }
	    private void addSubtitle(){
		if(m_oC.subtitle() != null){
		    Object[] _oRow = {"Subtitle",m_oC.subtitle()};
		    m_oTableModel.addRow(_oRow);
		}
	    }
	    private void addSummary(){
		if(m_oC.summary() != null){
		    Object[] _oRow = {"Summary",m_oC.summary()};
		    m_oTableModel.addRow(_oRow);
		}
	    }
	    private void addTime(){
		SimpleDateFormat _oSDF = new SimpleDateFormat("yyyy/MM/dd(E) HH:mm:ss");
		if(m_oC.time().begin() != null){
		    Object[] _oRowBegin = {"Begin time",_oSDF.format(m_oC.time().begin())};
		    m_oTableModel.addRow(_oRowBegin);
		}
		if(m_oC.time().end() != null){
		    Object[] _oRowEnd = {"End time",_oSDF.format(m_oC.time().end())};
		    m_oTableModel.addRow(_oRowEnd);
		}
	    }
	    private void addContent(){
		if(m_oC.content() != null){
		    if(m_oC.content().contentType().equals("plaintext")){
			Object[] _oRow = {"Content",((ContentPlainText)m_oC.content()).toString()};
			m_oTableModel.addRow(_oRow);
		    }else if(m_oC.content().contentType().equals("hyperlink")){
			Object[] _oRow = {"Content",((ContentHyperLink)m_oC.content()).toString()};
			m_oTableModel.addRow(_oRow);
		    }
		}
	    }
	    private void addLocation(){
		if(m_oC.location() != null){
		    if(m_oC.location().locationType().equals("gpx")){
			Object[] _oRow = {"Location",((LocationGPX)m_oC.location()).name()};
			m_oTableModel.addRow(_oRow);
		    }else if(m_oC.location().locationType().equals("name")){
			Object[] _oRow = {"Location",((LocationName)m_oC.location()).name()};
			m_oTableModel.addRow(_oRow);
		    }
		}
	    }
	    private void addAuthor(){
		Object[] _oRowName = {"Author",m_oC.author().name()};
		m_oTableModel.addRow(_oRowName);
	    }
	    class TableModel extends DefaultTableModel{
		TableModel(Object[] _o){
		    super(_o,0);
		}
		public boolean isCellEditable(int row,int column){
		    return false;
		}
	    }
	}
    }
    class DBSetChecker extends DBSetAdapter{
	synchronized public void add(DBSetEvent _oEv){
	    Iterator _i = _oEv.getSelectionMap().sches().iterator();
	    while(_i.hasNext()){
		addSche((Sche)_i.next());
	    }
	}
	public void select(DBSetEvent _oEv){
	    if(_oEv == null ||
	       _oEv.getSelectionMap() == null ||
	       _oEv.getSelectionMap().isAlreadyChanged(oThis())
	       ){return;}
	    int _nSize = _oEv.getSelectionMap().sches().size();
	    if(_nSize == 1){
		changeScheForOuterRequest((Sche)_oEv.getSelectionMap().sches().iterator().next());
	    }
	}
	public void remove(DBSetEvent _oEv){
	    if(_oEv == null){return;}
	    removeSelected();
	}
	synchronized public void update(DBSetEvent _oEv){
	    if(_oEv == null){return;}
	    Iterator _i = _oEv.getSelectionMap().sches().iterator();
	    while(_i.hasNext()){
		updateSche((Sche)_i.next());
	    }
	}
    }
}
