package xor.main.swing;

import javax.swing.*;
import xor.main.*;

abstract public class Inside extends QueryCaller implements Runnable,Refreshable{
    protected SwingInterface m_oI;
    protected boolean m_isDisplayed;
    protected Kernel m_oKernel;
    protected String m_oType;
    protected JPanel m_oContentPane;
    protected MDI m_oMDI;
    private boolean m_isSet;

    public Inside(Kernel _oKernel,SwingInterface _oI,MDI _oMDI){
	m_oKernel = _oKernel;
	m_oI = _oI;
	m_oMDI = _oMDI;
	m_isSet = false;
    }
    public void run(){
	m_oKernel.getLogger().config("Starting Inside : "+type()+".");
	panel().setVisible(true);
	refresh();
    }
    public void refresh(){
	if(!m_isSet){
	    m_isSet = true;
	    set();
	}
    }
    abstract public void refreshForce();
    abstract public JComponent panel();
    abstract public String type();
    abstract public void set();
    public void isDisplayed(){
	m_isDisplayed = true;
    }
    public void setContentPane(JPanel _oCP){
	m_oContentPane = _oCP;
    }
    public JPanel contentPane(){
	return m_oContentPane;
    }
}
