package xor.main.swing;

import javax.swing.*;
import java.awt.event.*;
import java.util.*;
import java.lang.*;
import xor.sche.*;
import xor.main.*;

public class Picker extends Inside{
    private JSplitPane m_oRoot;
    private PickerFrame m_oMain,m_oSub;

    Picker(SwingInterface _oI,Kernel _oKernel,MDI _oMDI){
	super(_oKernel,_oI,_oMDI);
	m_oRoot = new JSplitPane();
	m_oMain = new PickerFrame(m_oI,"1 Day",_oKernel,_oMDI);
	m_oSub = new PickerFrame(m_oI,"1 Week",_oKernel,_oMDI);
	m_oMain.panel().addComponentListener(new ResizeChecker());
	m_oI.addDBSetListener(new DBSetChecker(m_oMain));
	m_oI.addDBSetListener(new DBSetChecker(m_oSub));
	m_oI.addDisplayBoundsListener(new DispBChecker(m_oMain));
    }
    public void set(){
	m_oRoot.setOrientation(JSplitPane.VERTICAL_SPLIT);
	m_oRoot.setTopComponent(m_oSub.panel());
	m_oRoot.setBottomComponent(m_oMain.panel());
	m_oRoot.setContinuousLayout(false);
	m_oRoot.setOneTouchExpandable(true);
	m_oRoot.setDividerLocation(0.4);
	m_oMain.set();
	m_oSub.set();
	refresh();
	m_oRoot.setVisible(false);
    }
    synchronized public void refresh(){
	super.refresh();
	m_oMain.refresh();
	m_oSub.refresh();
    }
    public void refreshForce(){}
    public JComponent panel(){
	return m_oRoot;
    }
    public String type(){
	return "Picker";
    }
    class ResizeChecker extends ComponentAdapter{
	public void componentResized(ComponentEvent e){
	    refresh();
	}
	public void componentShown(ComponentEvent e){
	    refresh();
	}
	public void componentMoved(ComponentEvent e){
	    refresh();
	}
    }
    class DBSetChecker extends DBSetAdapter{
	private PickerFrame m_oThis;

	DBSetChecker(PickerFrame _oThis){
	    m_oThis = _oThis;
	}
	synchronized public void add(DBSetEvent _oEv){
	    if(_oEv == null || _oEv.getSelectionMap() == null || _oEv.getSelectionMap().isAlreadyChanged(m_oThis)){return;}
	    Iterator _i = _oEv.getSelectionMap().sches().iterator();
	    while(_i.hasNext()){
		m_oThis.addSche((Sche)_i.next());
	    }
	}
	public void remove(DBSetEvent _oEv){
	    if(_oEv == null){return;}
	    m_oThis.removeSelected();
	}
	synchronized public void select(DBSetEvent _oEv){
	    if(_oEv == null || _oEv.getSelectionMap() == null || _oEv.getSelectionMap().isAlreadyChanged(m_oThis)){return;}
	    Iterator _i = _oEv.getSelectionMap().sches().iterator();
	    DisplayBounds _oDB = new DisplayBounds();
	    while(_i.hasNext()){
		Sche _oS = (Sche)_i.next();
		m_oThis.selectSche(_oS,_oEv.getSelectionMap());
		DisplayBounds _oDBT = new DisplayBounds(_oS);
		_oDB.makeUnionFor(_oDBT);
	    }
	    if(m_oThis == m_oMain){
		m_oI.sendDisplayBoundsListener(new DisplayBoundsEvent(this,_oDB));
	    }
	}
	public void unselect(DBSetEvent _oEv){
	    if(_oEv == null){return;}
	    m_oThis.unselectSche();
	}
	public void move(DBSetEvent _oEv){
	    if(_oEv == null || _oEv.getSelectionMap() == null || _oEv.getSelectionMap().isAlreadyChanged(m_oThis)){return;}
	    m_oThis.moveScheTo(_oEv.getPaletteType());
	}
	public void update(DBSetEvent _oEv){
	    refresh();
	}
    }
    class DispBChecker extends DisplayBoundsAdapter{
	private PickerFrame m_oThis;

	DispBChecker(PickerFrame _oThis){
	    m_oThis = _oThis;
	}
	public void set(DisplayBoundsEvent _oE){
	    m_oThis.setCenterAndLength(_oE.getCenter(),_oE.getMinRateToDisplay());
	}
    }
}
