package xor.main.swing;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

class RootTabPane extends RootPane{
    private ComponentSocket m_oCenter,m_oEast;
    private OuterPanels m_oOP;
    
    public RootTabPane(SwingInterface _oI){
	super(_oI);
	m_oCenter = new ComponentSocket();
	m_oEast = new ComponentSocket();
	m_oOP = new OuterPanels();
	JSplitPane _oJSPRight = new JSplitPane();
	_oJSPRight.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
	_oJSPRight.setOneTouchExpandable(true);
	_oJSPRight.setLeftComponent(m_oCenter);
	_oJSPRight.setRightComponent(m_oEast);
	m_oPanel = new JPanel(new BorderLayout());
	m_oPanel.add(_oJSPRight,BorderLayout.CENTER);
    }
    public void addInside(Inside _oIn,String _sName){
	InsideContainable _oIC = bestContainable(_sName);
	if(_oIC != null){
	    _oIC.addInside(_oIn,_sName);
	    setInside(_sName,_oIn);
	}
    }
    public void removeInside(String _sName){
	InsideContainable _oIC = bestContainable(_sName);
	if(_oIC != null){
	    _oIC.removeInside(_sName);
	}
    }
    public void bringToTop(String _sName){
	InsideContainable _oIC = bestContainable(_sName);
	if(_oIC != null){
	    _oIC.bringToTop(_sName);
	}
    }
    public boolean exists(String _sName){
	InsideContainable _oIC = bestContainable(_sName);
	if(_oIC != null){
	    return _oIC.contains(_sName);
	}
	return false;
    }
    public int makeDecision(String _sMessage){
	return JOptionPane.showConfirmDialog(null,_sMessage);
    }
    private InsideContainable bestContainable(String _sName){
	if(_sName == null){
	    return m_oOP;
	}
	if(_sName.equals("ScheList") ||
	   _sName.equals("Picker") ||
	   _sName.equals("Calendar")){
	    return m_oCenter;
	}else if(_sName.equals("Detail") ||
		 _sName.equals("Updated")){
	    return m_oEast;
	}
	return m_oOP;
    }
    class ComponentSocket extends JTabbedPane implements InsideContainable{
	ComponentSocket(){
	    addChangeListener(new TabClickChecker());
	}
	public void addInside(Inside _oIn,String _sName){
	    addTab(_sName,_oIn.panel());
	    _oIn.panel().setVisible(true);
	    invisibleExcept();
	}
	public void removeInside(String _sName){
	    int _nPos = indexOfTab(_sName);
	    if(_nPos == -1){
		return;
	    }
	    removeTabAt(_nPos);
	}
	private void invisibleExcept(){
	    invisibleExcept(getTabCount()-1);
	}
	private void invisibleExcept(int _n){
	    int _nTabs = getTabCount();
	    if(_nTabs < 0){
		return;
	    }
	    int _nI = 0;
	    for(;_nI<_nTabs;_nI++){
		if(_nI != _n){
		    JComponent _oC = (JComponent)getComponentAt(_nI);
		    _oC.setVisible(false);
		}
	    }
	}
	public void bringToTop(String _sName){
	    int _nTabs = getTabCount();
	    if(_nTabs == -1){
		return;
	    }
	    int _nI = 0;
	    for(;_nI<_nTabs;_nI++){
		String _sTitle = getTitleAt(_nI);
		if(_sTitle.equals(_sName)){
		    setSelectedIndex(_nI);
		    JComponent _oC = (JComponent)getComponentAt(_nI);
		    _oC.setVisible(true);
		    break;
		}
	    }
	    invisibleExcept(_nI);
	    refreshForce();
	}
	private void refreshForce(){
	    int _nSelected = getSelectedIndex();
	    String _sTitle = getTitleAt(_nSelected);
	    Inside _oI = getInside(_sTitle);
	    if(_oI != null){
		_oI.refreshForce();
	    }
	}
	public boolean contains(String _sName){
	    int _nTabs = getTabCount();
	    int _nI = 0;
	    for(;_nI<_nTabs;_nI++){
		String _sTitle = getTitleAt(_nI);
		if(_sTitle.equals(_sName)){
		    return true;
		}
	    }
	    return false;
	}
	class TabClickChecker implements ChangeListener{
	    synchronized public void stateChanged(ChangeEvent e){
		refreshForce();
	    }
	}
    }
    class OuterPanels implements InsideContainable{
	private Map<String,OuterPanel> m_oPanels;

	OuterPanels(){
	    m_oPanels = new HashMap<String,OuterPanel>();
	}
	public void addInside(Inside _oIn,String _sName){
	    if(!m_oPanels.containsKey(_sName)){
		OuterPanel _oNewFrame = new OuterPanel(_sName,_oIn);
		m_oPanels.put(_sName,_oNewFrame);
	    }
	    m_oPanels.get(_sName).setVisible(true);
	}
	public void removeInside(String _sName){
	    if(!m_oPanels.containsKey(_sName)){
		return;
	    }
	    m_oPanels.get(_sName).setVisible(false);
	}
	public void bringToTop(String _sName){
	    if(!m_oPanels.containsKey(_sName)){
		return;
	    }
	    m_oPanels.get(_sName).toFront();
	}
	public boolean contains(String _sName){
	    return m_oPanels.containsKey(_sName);
	}
	private void kill(String _sName){
	    m_oPanels.remove(_sName);
	}
	class OuterPanel extends JFrame{
	    private Inside m_oIn;
	    private String m_sName;

	    OuterPanel(String _sName,Inside _oIn){
		super("Sche::SWING "+_sName);
		Container _oCF = getContentPane();
		setSize(640,480);
		setLocationRelativeTo(null);
		_oCF.add(_oIn.panel());
		setVisible(true);
		_oIn.refresh();
		m_oIn = _oIn;
		m_sName = _sName;
		addWindowListener(new WindowEventChecker());
	    }
	    class WindowEventChecker extends WindowAdapter{
		public void windowClosing(WindowEvent e){
		    kill(m_sName);
		}
	    }
	}
    }
    interface InsideContainable{
	public void addInside(Inside _oIn,String _sName);
	public void removeInside(String _sName);
	public void bringToTop(String _sName);
	public boolean contains(String _sName);
    }
}
