package xor.main.swing;

import java.util.*;

abstract public class SwingInterface extends xor.main.AbstractInterface{
    ConsoleFrame m_oFrame;
    
    public SwingInterface(xor.main.Kernel _oKernel){
	super(_oKernel);
    }
    public void run(){
	super.run();
	printCopyright();
    }
    public void printCopyright(){
	println("Welcome to SCHE::Swing");
    }
    public void callCommandWith(String _sQuery){
	pullTriggerWithUnoptimized(_sQuery);
    }
    public int makeDecision(String _sMessage){
	return m_oFrame.makeDecision(_sMessage);
    }

    private Vector<DisplayBoundsListener> m_aoDBListeners = new Vector<DisplayBoundsListener>();
    public void addDisplayBoundsListener(DisplayBoundsListener _oL){
	m_aoDBListeners.addElement(_oL);
    }
    public void removeDisplayBoundsListener(DisplayBoundsListener _oL){
	m_aoDBListeners.removeElement(_oL);
    }
    public void sendDisplayBoundsListener(DisplayBoundsEvent _oE){
	Vector<DisplayBoundsListener> _aoL = (Vector<DisplayBoundsListener>)m_aoDBListeners.clone();
	Enumeration _oENum = _aoL.elements();
	while(_oENum.hasMoreElements()){
	    DisplayBoundsListener _oL = (DisplayBoundsListener)_oENum.nextElement();
	    _oL.set(_oE);
	}
    }
    private Vector<WindowShowListener> m_aoWSListeners = new Vector<WindowShowListener>();
    public void addWindowShowListener(WindowShowListener _oL){
	m_aoWSListeners.addElement(_oL);
    }
    public void removeWindowShowListener(WindowShowListener _oL){
	m_aoWSListeners.removeElement(_oL);
    }
    public void sendWindowShowListener(WindowShowEvent _oE){
	Vector<WindowShowListener> _aoL = (Vector<WindowShowListener>)m_aoWSListeners.clone();
	Enumeration _oENum = _aoL.elements();
	while(_oENum.hasMoreElements()){
	    WindowShowListener _oL = (WindowShowListener)_oENum.nextElement();
	    _oL.show(_oE);
	}
    }

    private Vector<AnnouncementListener> m_aoAnnouncementListeners = new Vector<AnnouncementListener>();
    public void addAnnouncementListener(AnnouncementListener _oL){
	m_aoAnnouncementListeners.addElement(_oL);
    }
    public void removeAnnouncementListener(AnnouncementListener _oL){
	m_aoAnnouncementListeners.removeElement(_oL);
    }
    public void sendAnnouncementListener(AnnouncementEvent _oEv){
	AnnouncementEnum _sType = _oEv.getType();
	Vector<AnnouncementListener> _aoL = (Vector<AnnouncementListener>)m_aoAnnouncementListeners.clone();
	Enumeration _oENum = _aoL.elements();
	while(_oENum.hasMoreElements()){
	    AnnouncementListener _oL = (AnnouncementListener)_oENum.nextElement();
	    _oL.set(_oEv);
	}
    }
    public String getConfigFileDir(){
	return m_oKernel.getConfigFileDir()+"/swing";
    }
}
